/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.json.storage.service.persistence.impl;

import com.liferay.json.storage.exception.NoSuchJSONStorageEntryException;
import com.liferay.json.storage.model.JSONStorageEntry;
import com.liferay.json.storage.model.JSONStorageEntryTable;
import com.liferay.json.storage.model.impl.JSONStorageEntryImpl;
import com.liferay.json.storage.model.impl.JSONStorageEntryModelImpl;
import com.liferay.json.storage.service.persistence.JSONStorageEntryPersistence;
import com.liferay.json.storage.service.persistence.JSONStorageEntryUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={JSONStorageEntryPersistence.class})
public class JSONStorageEntryPersistenceImpl
extends BasePersistenceImpl<JSONStorageEntry>
implements JSONStorageEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = JSONStorageEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCN_CPK;
    private FinderPath _finderPathWithoutPaginationFindByCN_CPK;
    private FinderPath _finderPathCountByCN_CPK;
    private static final String _FINDER_COLUMN_CN_CPK_CLASSNAMEID_2 = "jsonStorageEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_CLASSPK_2 = "jsonStorageEntry.classPK = ?";
    private FinderPath _finderPathWithPaginationFindByC_CN_I_T_VL;
    private FinderPath _finderPathWithoutPaginationFindByC_CN_I_T_VL;
    private FinderPath _finderPathCountByC_CN_I_T_VL;
    private static final String _FINDER_COLUMN_C_CN_I_T_VL_COMPANYID_2 = "jsonStorageEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_I_T_VL_CLASSNAMEID_2 = "jsonStorageEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_I_T_VL_INDEX_2 = "jsonStorageEntry.index = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_I_T_VL_TYPE_2 = "jsonStorageEntry.type = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_I_T_VL_VALUELONG_2 = "jsonStorageEntry.valueLong = ?";
    private FinderPath _finderPathWithPaginationFindByC_CN_K_T_VL;
    private FinderPath _finderPathWithoutPaginationFindByC_CN_K_T_VL;
    private FinderPath _finderPathCountByC_CN_K_T_VL;
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_COMPANYID_2 = "jsonStorageEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_CLASSNAMEID_2 = "jsonStorageEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_KEY_2 = "jsonStorageEntry.key = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_KEY_3 = "(jsonStorageEntry.key IS NULL OR jsonStorageEntry.key = '') AND ";
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_TYPE_2 = "jsonStorageEntry.type = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_K_T_VL_VALUELONG_2 = "jsonStorageEntry.valueLong = ?";
    private FinderPath _finderPathFetchByCN_CPK_P_I_K;
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_CLASSNAMEID_2 = "jsonStorageEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_CLASSPK_2 = "jsonStorageEntry.classPK = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_PARENTJSONSTORAGEENTRYID_2 = "jsonStorageEntry.parentJSONStorageEntryId = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_INDEX_2 = "jsonStorageEntry.index = ? AND ";
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_KEY_2 = "jsonStorageEntry.key = ?";
    private static final String _FINDER_COLUMN_CN_CPK_P_I_K_KEY_3 = "(jsonStorageEntry.key IS NULL OR jsonStorageEntry.key = '')";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_JSONSTORAGEENTRY = "SELECT jsonStorageEntry FROM JSONStorageEntry jsonStorageEntry";
    private static final String _SQL_SELECT_JSONSTORAGEENTRY_WHERE = "SELECT jsonStorageEntry FROM JSONStorageEntry jsonStorageEntry WHERE ";
    private static final String _SQL_COUNT_JSONSTORAGEENTRY = "SELECT COUNT(jsonStorageEntry) FROM JSONStorageEntry jsonStorageEntry";
    private static final String _SQL_COUNT_JSONSTORAGEENTRY_WHERE = "SELECT COUNT(jsonStorageEntry) FROM JSONStorageEntry jsonStorageEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "jsonStorageEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No JSONStorageEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No JSONStorageEntry exists with the key {";
    private static final Log _log;
    private static final Set<String> _badColumnNames;

    public List<JSONStorageEntry> findByCN_CPK(long classNameId, long classPK) {
        return this.findByCN_CPK(classNameId, classPK, -1, -1, null);
    }

    public List<JSONStorageEntry> findByCN_CPK(long classNameId, long classPK, int start, int end) {
        return this.findByCN_CPK(classNameId, classPK, start, end, null);
    }

    public List<JSONStorageEntry> findByCN_CPK(long classNameId, long classPK, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator) {
        return this.findByCN_CPK(classNameId, classPK, start, end, orderByComparator, true);
    }

    public List<JSONStorageEntry> findByCN_CPK(long classNameId, long classPK, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByCN_CPK;
                    finderArgs = new Object[]{classNameId, classPK};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByCN_CPK;
                finderArgs = new Object[]{classNameId, classPK, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (JSONStorageEntry jsonStorageEntry : list) {
                    if (classNameId == jsonStorageEntry.getClassNameId() && classPK == jsonStorageEntry.getClassPK()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
                sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_CN_CPK_CLASSPK_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY jsonStorageEntry.index ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public JSONStorageEntry findByCN_CPK_First(long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByCN_CPK_First(classNameId, classPK, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByCN_CPK_First(long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator) {
        List<JSONStorageEntry> list = this.findByCN_CPK(classNameId, classPK, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry findByCN_CPK_Last(long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByCN_CPK_Last(classNameId, classPK, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("classNameId=");
        sb.append(classNameId);
        sb.append(", classPK=");
        sb.append(classPK);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByCN_CPK_Last(long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator) {
        int count = this.countByCN_CPK(classNameId, classPK);
        if (count == 0) {
            return null;
        }
        List<JSONStorageEntry> list = this.findByCN_CPK(classNameId, classPK, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry[] findByCN_CPK_PrevAndNext(long jsonStorageEntryId, long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.findByPrimaryKey(jsonStorageEntryId);
        Session session = null;
        try {
            session = this.openSession();
            JSONStorageEntry[] array = new JSONStorageEntryImpl[]{this.getByCN_CPK_PrevAndNext(session, jsonStorageEntry, classNameId, classPK, orderByComparator, true), jsonStorageEntry, this.getByCN_CPK_PrevAndNext(session, jsonStorageEntry, classNameId, classPK, orderByComparator, false)};
            JSONStorageEntry[] jSONStorageEntryArray = array;
            return jSONStorageEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected JSONStorageEntry getByCN_CPK_PrevAndNext(Session session, JSONStorageEntry jsonStorageEntry, long classNameId, long classPK, OrderByComparator<JSONStorageEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
        sb.append("jsonStorageEntry.classNameId = ? AND ");
        sb.append(_FINDER_COLUMN_CN_CPK_CLASSPK_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY jsonStorageEntry.index ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(classNameId);
        queryPos.add(classPK);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)jsonStorageEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (JSONStorageEntry)list.get(1);
        }
        return null;
    }

    public void removeByCN_CPK(long classNameId, long classPK) {
        for (JSONStorageEntry jsonStorageEntry : this.findByCN_CPK(classNameId, classPK, -1, -1, null)) {
            this.remove((BaseModel)jsonStorageEntry);
        }
    }

    public int countByCN_CPK(long classNameId, long classPK) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            FinderPath finderPath = this._finderPathCountByCN_CPK;
            Object[] finderArgs = new Object[]{classNameId, classPK};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(3);
                sb.append(_SQL_COUNT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_CN_CPK_CLASSPK_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public List<JSONStorageEntry> findByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong) {
        return this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, -1, -1, null);
    }

    public List<JSONStorageEntry> findByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong, int start, int end) {
        return this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, start, end, null);
    }

    public List<JSONStorageEntry> findByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator) {
        return this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, start, end, orderByComparator, true);
    }

    public List<JSONStorageEntry> findByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByC_CN_I_T_VL;
                    finderArgs = new Object[]{companyId, classNameId, index, type, valueLong};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByC_CN_I_T_VL;
                finderArgs = new Object[]{companyId, classNameId, index, type, valueLong, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (JSONStorageEntry jsonStorageEntry : list) {
                    if (companyId == jsonStorageEntry.getCompanyId() && classNameId == jsonStorageEntry.getClassNameId() && index == jsonStorageEntry.getIndex() && type == jsonStorageEntry.getType() && valueLong == jsonStorageEntry.getValueLong()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(7);
                sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.companyId = ? AND ");
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                sb.append("jsonStorageEntry.index = ? AND ");
                sb.append("jsonStorageEntry.type = ? AND ");
                sb.append("jsonStorageEntry.valueLong = ?");
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY jsonStorageEntry.index ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(companyId);
                    queryPos.add(classNameId);
                    queryPos.add(index);
                    queryPos.add(type);
                    queryPos.add(valueLong);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public JSONStorageEntry findByC_CN_I_T_VL_First(long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByC_CN_I_T_VL_First(companyId, classNameId, index, type, valueLong, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(12);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", index=");
        sb.append(index);
        sb.append(", type=");
        sb.append(type);
        sb.append(", valueLong=");
        sb.append(valueLong);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByC_CN_I_T_VL_First(long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) {
        List<JSONStorageEntry> list = this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry findByC_CN_I_T_VL_Last(long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByC_CN_I_T_VL_Last(companyId, classNameId, index, type, valueLong, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(12);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", index=");
        sb.append(index);
        sb.append(", type=");
        sb.append(type);
        sb.append(", valueLong=");
        sb.append(valueLong);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByC_CN_I_T_VL_Last(long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) {
        int count = this.countByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong);
        if (count == 0) {
            return null;
        }
        List<JSONStorageEntry> list = this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry[] findByC_CN_I_T_VL_PrevAndNext(long jsonStorageEntryId, long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.findByPrimaryKey(jsonStorageEntryId);
        Session session = null;
        try {
            session = this.openSession();
            JSONStorageEntry[] array = new JSONStorageEntryImpl[]{this.getByC_CN_I_T_VL_PrevAndNext(session, jsonStorageEntry, companyId, classNameId, index, type, valueLong, orderByComparator, true), jsonStorageEntry, this.getByC_CN_I_T_VL_PrevAndNext(session, jsonStorageEntry, companyId, classNameId, index, type, valueLong, orderByComparator, false)};
            JSONStorageEntry[] jSONStorageEntryArray = array;
            return jSONStorageEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected JSONStorageEntry getByC_CN_I_T_VL_PrevAndNext(Session session, JSONStorageEntry jsonStorageEntry, long companyId, long classNameId, int index, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(8 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(7);
        sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
        sb.append("jsonStorageEntry.companyId = ? AND ");
        sb.append("jsonStorageEntry.classNameId = ? AND ");
        sb.append("jsonStorageEntry.index = ? AND ");
        sb.append("jsonStorageEntry.type = ? AND ");
        sb.append("jsonStorageEntry.valueLong = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY jsonStorageEntry.index ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(classNameId);
        queryPos.add(index);
        queryPos.add(type);
        queryPos.add(valueLong);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)jsonStorageEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (JSONStorageEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong) {
        for (JSONStorageEntry jsonStorageEntry : this.findByC_CN_I_T_VL(companyId, classNameId, index, type, valueLong, -1, -1, null)) {
            this.remove((BaseModel)jsonStorageEntry);
        }
    }

    public int countByC_CN_I_T_VL(long companyId, long classNameId, int index, int type, long valueLong) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            FinderPath finderPath = this._finderPathCountByC_CN_I_T_VL;
            Object[] finderArgs = new Object[]{companyId, classNameId, index, type, valueLong};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(6);
                sb.append(_SQL_COUNT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.companyId = ? AND ");
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                sb.append("jsonStorageEntry.index = ? AND ");
                sb.append("jsonStorageEntry.type = ? AND ");
                sb.append("jsonStorageEntry.valueLong = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(companyId);
                    queryPos.add(classNameId);
                    queryPos.add(index);
                    queryPos.add(type);
                    queryPos.add(valueLong);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public List<JSONStorageEntry> findByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong) {
        return this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, -1, -1, null);
    }

    public List<JSONStorageEntry> findByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong, int start, int end) {
        return this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, start, end, null);
    }

    public List<JSONStorageEntry> findByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator) {
        return this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, start, end, orderByComparator, true);
    }

    public List<JSONStorageEntry> findByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong, int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            key = Objects.toString(key, "");
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByC_CN_K_T_VL;
                    finderArgs = new Object[]{companyId, classNameId, key, type, valueLong};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByC_CN_K_T_VL;
                finderArgs = new Object[]{companyId, classNameId, key, type, valueLong, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (JSONStorageEntry jsonStorageEntry : list) {
                    if (companyId == jsonStorageEntry.getCompanyId() && classNameId == jsonStorageEntry.getClassNameId() && key.equals(jsonStorageEntry.getKey()) && type == jsonStorageEntry.getType() && valueLong == jsonStorageEntry.getValueLong()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(7);
                sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.companyId = ? AND ");
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                boolean bindKey = false;
                if (key.isEmpty()) {
                    sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_3);
                } else {
                    bindKey = true;
                    sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_2);
                }
                sb.append("jsonStorageEntry.type = ? AND ");
                sb.append("jsonStorageEntry.valueLong = ?");
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY jsonStorageEntry.index ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(companyId);
                    queryPos.add(classNameId);
                    if (bindKey) {
                        queryPos.add(key);
                    }
                    queryPos.add(type);
                    queryPos.add(valueLong);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public JSONStorageEntry findByC_CN_K_T_VL_First(long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByC_CN_K_T_VL_First(companyId, classNameId, key, type, valueLong, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(12);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", key=");
        sb.append(key);
        sb.append(", type=");
        sb.append(type);
        sb.append(", valueLong=");
        sb.append(valueLong);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByC_CN_K_T_VL_First(long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) {
        List<JSONStorageEntry> list = this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry findByC_CN_K_T_VL_Last(long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByC_CN_K_T_VL_Last(companyId, classNameId, key, type, valueLong, orderByComparator);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        StringBundler sb = new StringBundler(12);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append(", key=");
        sb.append(key);
        sb.append(", type=");
        sb.append(type);
        sb.append(", valueLong=");
        sb.append(valueLong);
        sb.append("}");
        throw new NoSuchJSONStorageEntryException(sb.toString());
    }

    public JSONStorageEntry fetchByC_CN_K_T_VL_Last(long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) {
        int count = this.countByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong);
        if (count == 0) {
            return null;
        }
        List<JSONStorageEntry> list = this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public JSONStorageEntry[] findByC_CN_K_T_VL_PrevAndNext(long jsonStorageEntryId, long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator) throws NoSuchJSONStorageEntryException {
        key = Objects.toString(key, "");
        JSONStorageEntry jsonStorageEntry = this.findByPrimaryKey(jsonStorageEntryId);
        Session session = null;
        try {
            session = this.openSession();
            JSONStorageEntry[] array = new JSONStorageEntryImpl[]{this.getByC_CN_K_T_VL_PrevAndNext(session, jsonStorageEntry, companyId, classNameId, key, type, valueLong, orderByComparator, true), jsonStorageEntry, this.getByC_CN_K_T_VL_PrevAndNext(session, jsonStorageEntry, companyId, classNameId, key, type, valueLong, orderByComparator, false)};
            JSONStorageEntry[] jSONStorageEntryArray = array;
            return jSONStorageEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected JSONStorageEntry getByC_CN_K_T_VL_PrevAndNext(Session session, JSONStorageEntry jsonStorageEntry, long companyId, long classNameId, String key, int type, long valueLong, OrderByComparator<JSONStorageEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(8 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(7);
        sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
        sb.append("jsonStorageEntry.companyId = ? AND ");
        sb.append("jsonStorageEntry.classNameId = ? AND ");
        boolean bindKey = false;
        if (key.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_3);
        } else {
            bindKey = true;
            sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_2);
        }
        sb.append("jsonStorageEntry.type = ? AND ");
        sb.append("jsonStorageEntry.valueLong = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY jsonStorageEntry.index ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(classNameId);
        if (bindKey) {
            queryPos.add(key);
        }
        queryPos.add(type);
        queryPos.add(valueLong);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)jsonStorageEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (JSONStorageEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong) {
        for (JSONStorageEntry jsonStorageEntry : this.findByC_CN_K_T_VL(companyId, classNameId, key, type, valueLong, -1, -1, null)) {
            this.remove((BaseModel)jsonStorageEntry);
        }
    }

    public int countByC_CN_K_T_VL(long companyId, long classNameId, String key, int type, long valueLong) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            key = Objects.toString(key, "");
            FinderPath finderPath = this._finderPathCountByC_CN_K_T_VL;
            Object[] finderArgs = new Object[]{companyId, classNameId, key, type, valueLong};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(6);
                sb.append(_SQL_COUNT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.companyId = ? AND ");
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                boolean bindKey = false;
                if (key.isEmpty()) {
                    sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_3);
                } else {
                    bindKey = true;
                    sb.append(_FINDER_COLUMN_C_CN_K_T_VL_KEY_2);
                }
                sb.append("jsonStorageEntry.type = ? AND ");
                sb.append("jsonStorageEntry.valueLong = ?");
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(companyId);
                    queryPos.add(classNameId);
                    if (bindKey) {
                        queryPos.add(key);
                    }
                    queryPos.add(type);
                    queryPos.add(valueLong);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public JSONStorageEntry findByCN_CPK_P_I_K(long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByCN_CPK_P_I_K(classNameId, classPK, parentJSONStorageEntryId, index, key);
        if (jsonStorageEntry == null) {
            StringBundler sb = new StringBundler(12);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("classNameId=");
            sb.append(classNameId);
            sb.append(", classPK=");
            sb.append(classPK);
            sb.append(", parentJSONStorageEntryId=");
            sb.append(parentJSONStorageEntryId);
            sb.append(", index=");
            sb.append(index);
            sb.append(", key=");
            sb.append(key);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchJSONStorageEntryException(sb.toString());
        }
        return jsonStorageEntry;
    }

    public JSONStorageEntry fetchByCN_CPK_P_I_K(long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key) {
        return this.fetchByCN_CPK_P_I_K(classNameId, classPK, parentJSONStorageEntryId, index, key, true);
    }

    public JSONStorageEntry fetchByCN_CPK_P_I_K(long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            JSONStorageEntry jSONStorageEntry;
            JSONStorageEntry jsonStorageEntry;
            key = Objects.toString(key, "");
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{classNameId, classPK, parentJSONStorageEntryId, index, key};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByCN_CPK_P_I_K, finderArgs, (BasePersistence)this);
            }
            if (result instanceof JSONStorageEntry && (classNameId != (jsonStorageEntry = (JSONStorageEntry)result).getClassNameId() || classPK != jsonStorageEntry.getClassPK() || parentJSONStorageEntryId != jsonStorageEntry.getParentJSONStorageEntryId() || index != jsonStorageEntry.getIndex() || !Objects.equals(key, jsonStorageEntry.getKey()))) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(7);
                sb.append(_SQL_SELECT_JSONSTORAGEENTRY_WHERE);
                sb.append("jsonStorageEntry.classNameId = ? AND ");
                sb.append(_FINDER_COLUMN_CN_CPK_P_I_K_CLASSPK_2);
                sb.append(_FINDER_COLUMN_CN_CPK_P_I_K_PARENTJSONSTORAGEENTRYID_2);
                sb.append("jsonStorageEntry.index = ? AND ");
                boolean bindKey = false;
                if (key.isEmpty()) {
                    sb.append(_FINDER_COLUMN_CN_CPK_P_I_K_KEY_3);
                } else {
                    bindKey = true;
                    sb.append(_FINDER_COLUMN_CN_CPK_P_I_K_KEY_2);
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    List list;
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(classNameId);
                    queryPos.add(classPK);
                    queryPos.add(parentJSONStorageEntryId);
                    queryPos.add(index);
                    if (bindKey) {
                        queryPos.add(key);
                    }
                    if ((list = query.list()).isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByCN_CPK_P_I_K, finderArgs, (Object)list);
                        }
                    } else {
                        JSONStorageEntry jsonStorageEntry2 = (JSONStorageEntry)list.get(0);
                        result = jsonStorageEntry2;
                        this.cacheResult(jsonStorageEntry2);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                jSONStorageEntry = null;
                return jSONStorageEntry;
            }
            jSONStorageEntry = (JSONStorageEntry)result;
            return jSONStorageEntry;
        }
    }

    public JSONStorageEntry removeByCN_CPK_P_I_K(long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.findByCN_CPK_P_I_K(classNameId, classPK, parentJSONStorageEntryId, index, key);
        return (JSONStorageEntry)this.remove((BaseModel)jsonStorageEntry);
    }

    public int countByCN_CPK_P_I_K(long classNameId, long classPK, long parentJSONStorageEntryId, int index, String key) {
        JSONStorageEntry jsonStorageEntry = this.fetchByCN_CPK_P_I_K(classNameId, classPK, parentJSONStorageEntryId, index, key);
        if (jsonStorageEntry == null) {
            return 0;
        }
        return 1;
    }

    public JSONStorageEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("index", "index_");
        dbColumnNames.put("key", "key_");
        dbColumnNames.put("type", "type_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(JSONStorageEntry.class);
        this.setModelImplClass(JSONStorageEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)JSONStorageEntryTable.INSTANCE);
    }

    public void cacheResult(JSONStorageEntry jsonStorageEntry) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)jsonStorageEntry.getCtCollectionId());){
            this.entityCache.putResult(JSONStorageEntryImpl.class, (Serializable)Long.valueOf(jsonStorageEntry.getPrimaryKey()), (Serializable)jsonStorageEntry);
            this.finderCache.putResult(this._finderPathFetchByCN_CPK_P_I_K, new Object[]{jsonStorageEntry.getClassNameId(), jsonStorageEntry.getClassPK(), jsonStorageEntry.getParentJSONStorageEntryId(), jsonStorageEntry.getIndex(), jsonStorageEntry.getKey()}, (Object)jsonStorageEntry);
        }
    }

    public void cacheResult(List<JSONStorageEntry> jsonStorageEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && jsonStorageEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (JSONStorageEntry jsonStorageEntry : jsonStorageEntries) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)jsonStorageEntry.getCtCollectionId());
            try {
                if (this.entityCache.getResult(JSONStorageEntryImpl.class, (Serializable)Long.valueOf(jsonStorageEntry.getPrimaryKey())) != null) continue;
                this.cacheResult(jsonStorageEntry);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(JSONStorageEntryImpl.class);
        this.finderCache.clearCache(JSONStorageEntryImpl.class);
    }

    public void clearCache(JSONStorageEntry jsonStorageEntry) {
        this.entityCache.removeResult(JSONStorageEntryImpl.class, (BaseModel)jsonStorageEntry);
    }

    public void clearCache(List<JSONStorageEntry> jsonStorageEntries) {
        for (JSONStorageEntry jsonStorageEntry : jsonStorageEntries) {
            this.entityCache.removeResult(JSONStorageEntryImpl.class, (BaseModel)jsonStorageEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(JSONStorageEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(JSONStorageEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(JSONStorageEntryModelImpl jsonStorageEntryModelImpl) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)jsonStorageEntryModelImpl.getCtCollectionId());){
            Object[] args = new Object[]{jsonStorageEntryModelImpl.getClassNameId(), jsonStorageEntryModelImpl.getClassPK(), jsonStorageEntryModelImpl.getParentJSONStorageEntryId(), jsonStorageEntryModelImpl.getIndex(), jsonStorageEntryModelImpl.getKey()};
            this.finderCache.putResult(this._finderPathFetchByCN_CPK_P_I_K, args, (Object)jsonStorageEntryModelImpl);
        }
    }

    public JSONStorageEntry create(long jsonStorageEntryId) {
        JSONStorageEntryImpl jsonStorageEntry = new JSONStorageEntryImpl();
        jsonStorageEntry.setNew(true);
        jsonStorageEntry.setPrimaryKey(jsonStorageEntryId);
        jsonStorageEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return jsonStorageEntry;
    }

    public JSONStorageEntry remove(long jsonStorageEntryId) throws NoSuchJSONStorageEntryException {
        return this.remove(Long.valueOf(jsonStorageEntryId));
    }

    public JSONStorageEntry remove(Serializable primaryKey) throws NoSuchJSONStorageEntryException {
        Session session = null;
        try {
            session = this.openSession();
            JSONStorageEntry jsonStorageEntry = (JSONStorageEntry)session.get(JSONStorageEntryImpl.class, primaryKey);
            if (jsonStorageEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchJSONStorageEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            JSONStorageEntry jSONStorageEntry = (JSONStorageEntry)this.remove((BaseModel)jsonStorageEntry);
            return jSONStorageEntry;
        }
        catch (NoSuchJSONStorageEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected JSONStorageEntry removeImpl(JSONStorageEntry jsonStorageEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)jsonStorageEntry)) {
                jsonStorageEntry = (JSONStorageEntry)session.get(JSONStorageEntryImpl.class, jsonStorageEntry.getPrimaryKeyObj());
            }
            if (jsonStorageEntry != null && this.ctPersistenceHelper.isRemove((CTModel)jsonStorageEntry)) {
                session.delete((Object)jsonStorageEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (jsonStorageEntry != null) {
            this.clearCache(jsonStorageEntry);
        }
        return jsonStorageEntry;
    }

    public JSONStorageEntry updateImpl(JSONStorageEntry jsonStorageEntry) {
        boolean isNew = jsonStorageEntry.isNew();
        if (!(jsonStorageEntry instanceof JSONStorageEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(jsonStorageEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)jsonStorageEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in jsonStorageEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom JSONStorageEntry implementation " + jsonStorageEntry.getClass());
        }
        JSONStorageEntryModelImpl jsonStorageEntryModelImpl = (JSONStorageEntryModelImpl)jsonStorageEntry;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)jsonStorageEntry)) {
                if (!isNew) {
                    session.evict(JSONStorageEntryImpl.class, jsonStorageEntry.getPrimaryKeyObj());
                }
                session.save((Object)jsonStorageEntry);
            } else {
                jsonStorageEntry = (JSONStorageEntry)session.merge((Object)jsonStorageEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(JSONStorageEntryImpl.class, (BaseModel)jsonStorageEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(jsonStorageEntryModelImpl);
        if (isNew) {
            jsonStorageEntry.setNew(false);
        }
        jsonStorageEntry.resetOriginalValues();
        return jsonStorageEntry;
    }

    public JSONStorageEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchJSONStorageEntryException {
        JSONStorageEntry jsonStorageEntry = this.fetchByPrimaryKey(primaryKey);
        if (jsonStorageEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchJSONStorageEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return jsonStorageEntry;
    }

    public JSONStorageEntry findByPrimaryKey(long jsonStorageEntryId) throws NoSuchJSONStorageEntryException {
        return this.findByPrimaryKey(Long.valueOf(jsonStorageEntryId));
    }

    public JSONStorageEntry fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(JSONStorageEntry.class, primaryKey)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                JSONStorageEntry jSONStorageEntry = (JSONStorageEntry)super.fetchByPrimaryKey(primaryKey);
                return jSONStorageEntry;
            }
        }
        JSONStorageEntry jsonStorageEntry = (JSONStorageEntry)this.entityCache.getResult(JSONStorageEntryImpl.class, primaryKey);
        if (jsonStorageEntry != null) {
            return jsonStorageEntry;
        }
        Session session = null;
        try {
            session = this.openSession();
            jsonStorageEntry = (JSONStorageEntry)session.get(JSONStorageEntryImpl.class, primaryKey);
            if (jsonStorageEntry != null) {
                this.cacheResult(jsonStorageEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return jsonStorageEntry;
    }

    public JSONStorageEntry fetchByPrimaryKey(long jsonStorageEntryId) {
        return this.fetchByPrimaryKey(Long.valueOf(jsonStorageEntryId));
    }

    public Map<Serializable, JSONStorageEntry> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(JSONStorageEntry.class)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Map map = super.fetchByPrimaryKeys(primaryKeys);
                return map;
            }
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, JSONStorageEntry> map = new HashMap<Serializable, JSONStorageEntry>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            JSONStorageEntry jsonStorageEntry = this.fetchByPrimaryKey(primaryKey);
            if (jsonStorageEntry != null) {
                map.put(primaryKey, jsonStorageEntry);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class, primaryKey);
            try {
                JSONStorageEntry jsonStorageEntry = (JSONStorageEntry)this.entityCache.getResult(JSONStorageEntryImpl.class, primaryKey);
                if (jsonStorageEntry == null) {
                    if (uncachedPrimaryKeys == null) {
                        uncachedPrimaryKeys = new HashSet<Serializable>();
                    }
                    uncachedPrimaryKeys.add(primaryKey);
                    continue;
                }
                map.put(primaryKey, jsonStorageEntry);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (JSONStorageEntry jsonStorageEntry : query.list()) {
                map.put(jsonStorageEntry.getPrimaryKeyObj(), jsonStorageEntry);
                this.cacheResult(jsonStorageEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<JSONStorageEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<JSONStorageEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<JSONStorageEntry> findAll(int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<JSONStorageEntry> findAll(int start, int end, OrderByComparator<JSONStorageEntry> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindAll;
                    finderArgs = FINDER_ARGS_EMPTY;
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindAll;
                finderArgs = new Object[]{start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache) {
                list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            }
            if (list == null) {
                StringBundler sb = null;
                String sql = null;
                if (orderByComparator != null) {
                    sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                    sb.append(_SQL_SELECT_JSONSTORAGEENTRY);
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                    sql = sb.toString();
                } else {
                    sql = _SQL_SELECT_JSONSTORAGEENTRY;
                    sql = sql.concat(" ORDER BY jsonStorageEntry.index ASC");
                }
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public void removeAll() {
        for (JSONStorageEntry jsonStorageEntry : this.findAll()) {
            this.remove((BaseModel)jsonStorageEntry);
        }
    }

    public int countAll() {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(JSONStorageEntry.class);){
            Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
            if (count == null) {
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(_SQL_COUNT_JSONSTORAGEENTRY);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "jsonStorageEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_JSONSTORAGEENTRY;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return JSONStorageEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "JSONStorageEntry";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCN_CPK = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCN_CPK", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathWithoutPaginationFindByCN_CPK = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCN_CPK", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, true);
        this._finderPathCountByCN_CPK = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCN_CPK", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"classNameId", "classPK"}, false);
        this._finderPathWithPaginationFindByC_CN_I_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_CN_I_T_VL", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "classNameId", "index_", "type_", "valueLong"}, true);
        this._finderPathWithoutPaginationFindByC_CN_I_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_CN_I_T_VL", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId", "index_", "type_", "valueLong"}, true);
        this._finderPathCountByC_CN_I_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_CN_I_T_VL", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId", "index_", "type_", "valueLong"}, false);
        this._finderPathWithPaginationFindByC_CN_K_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_CN_K_T_VL", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "classNameId", "key_", "type_", "valueLong"}, true);
        this._finderPathWithoutPaginationFindByC_CN_K_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_CN_K_T_VL", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId", "key_", "type_", "valueLong"}, true);
        this._finderPathCountByC_CN_K_T_VL = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_CN_K_T_VL", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId", "key_", "type_", "valueLong"}, false);
        this._finderPathFetchByCN_CPK_P_I_K = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByCN_CPK_P_I_K", new String[]{Long.class.getName(), Long.class.getName(), Long.class.getName(), Integer.class.getName(), String.class.getName()}, new String[]{"classNameId", "classPK", "parentJSONStorageEntryId", "index_", "key_"}, true);
        JSONStorageEntryUtil.setPersistence((JSONStorageEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        JSONStorageEntryUtil.setPersistence(null);
        this.entityCache.removeCache(JSONStorageEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.json.storage.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.json.storage.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.json.storage.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctMergeColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("classNameId");
        ctStrictColumnNames.add("classPK");
        ctMergeColumnNames.add("parentJSONStorageEntryId");
        ctMergeColumnNames.add("index_");
        ctMergeColumnNames.add("key_");
        ctMergeColumnNames.add("type_");
        ctMergeColumnNames.add("valueLong");
        ctMergeColumnNames.add("valueString");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("jsonStorageEntryId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"classNameId", "classPK", "parentJSONStorageEntryId", "index_", "key_"});
        _log = LogFactoryUtil.getLog(JSONStorageEntryPersistenceImpl.class);
        _badColumnNames = SetUtil.fromArray((Object[])new String[]{"index", "key", "type"});
    }
}

