/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ip.geocoder.internal;

import com.liferay.ip.geocoder.IPGeocoder;
import com.liferay.ip.geocoder.IPInfo;
import com.maxmind.geoip.Location;
import com.maxmind.geoip.LookupService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.tukaani.xz.XZInputStream;

@Component(configurationPolicy=ConfigurationPolicy.OPTIONAL, name="IPGeocoder", property={"ip.geocoder.file.path=", "ip.geocoder.file.url=http://cdn.mirrors.liferay.com/geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.xz"}, service={IPGeocoder.class})
public class IPGeocoderImpl
implements IPGeocoder {
    private static Logger _logger = Logger.getLogger(IPGeocoderImpl.class);
    private static LookupService _lookupService;

    @Activate
    public void activate(Map<String, String> properties) {
        if (_lookupService != null) {
            return;
        }
        String filePath = properties.get("ip.geocoder.file.path");
        if (filePath == null || filePath.equals("")) {
            filePath = System.getProperty("java.io.tmpdir") + "/liferay/geoip/GeoIPCity.dat";
        }
        String fileURL = properties.get("ip.geocoder.file.url");
        try {
            File ipGeocoderFile = this.getIPGeocoderFile(filePath, fileURL, false);
            _lookupService = new LookupService(ipGeocoderFile, 1);
        }
        catch (IOException ioe) {
            _logger.error((Object)"Unable to activate Liferay IP Geocoder", (Throwable)ioe);
        }
    }

    @Deactivate
    public void deactivate(Map<String, String> properties) {
        _lookupService = null;
    }

    @Override
    public IPInfo getIPInfo(String ipAddress) {
        if (_lookupService == null) {
            return null;
        }
        Location location = _lookupService.getLocation(ipAddress);
        return new IPInfo(ipAddress, location);
    }

    @Modified
    public void modified(Map<String, String> properties) {
        if (properties.containsKey("ip.geocoder.file.path") || properties.containsKey("ip.geocoder.file.url")) {
            _lookupService = null;
            this.activate(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getIPGeocoderFile(String filePath, String fileURL, boolean forceDownload) throws IOException {
        File file = new File(filePath);
        if (file.exists() && !forceDownload) {
            return file;
        }
        IPGeocoderImpl iPGeocoderImpl = this;
        synchronized (iPGeocoderImpl) {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("Downloading " + fileURL));
            }
            URL url = new URL(fileURL);
            URLConnection urlConnection = url.openConnection();
            File xzFile = new File(System.getProperty("java.io.tmpdir") + "/liferay/geoip/GeoIPCity.dat.xz");
            this.write(xzFile, urlConnection.getInputStream());
            this.write(file, (InputStream)new XZInputStream((InputStream)new FileInputStream(xzFile)));
        }
        return file;
    }

    protected void write(File file, InputStream inputStream) throws IOException {
        File parentFile = file.getParentFile();
        if (parentFile == null) {
            return;
        }
        try {
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int i = 0;
            while ((i = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(i);
            }
            bufferedOutputStream.flush();
        }
    }
}

