/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.internal.resource.v1_0;

import com.liferay.headless.object.dto.v1_0.ObjectEntryFolder;
import com.liferay.headless.object.resource.v1_0.ObjectEntryFolderResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PermissionServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.crud.VulcanCRUDItemDelegate;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseObjectEntryFolderResourceImpl
implements EntityModelResource,
ObjectEntryFolderResource,
VulcanBatchEngineTaskItemDelegate<ObjectEntryFolder>,
VulcanCRUDItemDelegate<ObjectEntryFolder> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<ObjectEntryFolder>, UnsafeFunction<ObjectEntryFolder, ObjectEntryFolder, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<ObjectEntryFolder>, UnsafeConsumer<ObjectEntryFolder, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseObjectEntryFolderResourceImpl.class);

    @Operation(description="Deletes the object entry folder and returns a 204 if the operation succeeds.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @DELETE
    @Path(value="/object-entry-folders/{objectEntryFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteObjectEntryFolder(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/object-entry-folders/batch")
    @Produces(value={"application/json"})
    public Response deleteObjectEntryFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(ObjectEntryFolder.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @DELETE
    @Path(value="/scopes/{scopeKey}/object-entry-folder/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteScopeScopeKeyObjectEntryFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    protected abstract ObjectEntryFolder doGetObjectEntryFolder(Long var1) throws Exception;

    @Operation(description="Retrieves the object entry folder.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @GET
    @Path(value="/object-entry-folders/{objectEntryFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public final ObjectEntryFolder getObjectEntryFolder(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId) throws Exception {
        ObjectEntryFolder getObjectEntryFolder = this.doGetObjectEntryFolder(objectEntryFolderId);
        getObjectEntryFolder.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
            Page<Permission> permissionsPage = this.getObjectEntryFolderPermissionsPage(getObjectEntryFolder.getId(), null);
            Collection permissions = permissionsPage.getItems();
            return permissions.toArray(new Permission[permissions.size()]);
        }));
        return getObjectEntryFolder;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @GET
    @Path(value="/object-entry-folders/{objectEntryFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getObjectEntryFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(objectEntryFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(objectEntryFolderId);
        PermissionServiceUtil.checkPermission((long)this.getPermissionCheckerGroupId(objectEntryFolderId), (String)resourceName, (long)resourceId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getObjectEntryFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putObjectEntryFolderPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, roleNames);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @GET
    @Path(value="/scopes/{scopeKey}/object-entry-folder/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntryFolder getScopeScopeKeyObjectEntryFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new ObjectEntryFolder();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="flatten"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @GET
    @Path(value="/scopes/{scopeKey}/object-entry-folders")
    @Produces(value={"application/json", "application/xml"})
    public Page<ObjectEntryFolder> getScopeScopeKeyObjectEntryFoldersPage(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @QueryParam(value="flatten") Boolean flatten, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/object-entry-folders/{objectEntryFolderId}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntryFolder patchObjectEntryFolder(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId, ObjectEntryFolder objectEntryFolder) throws Exception {
        ObjectEntryFolder existingObjectEntryFolder = this.getObjectEntryFolder(objectEntryFolderId);
        if (objectEntryFolder.getDescription() != null) {
            existingObjectEntryFolder.setDescription(objectEntryFolder.getDescription());
        }
        if (objectEntryFolder.getExternalReferenceCode() != null) {
            existingObjectEntryFolder.setExternalReferenceCode(objectEntryFolder.getExternalReferenceCode());
        }
        if (objectEntryFolder.getLabel() != null) {
            existingObjectEntryFolder.setLabel(objectEntryFolder.getLabel());
        }
        if (objectEntryFolder.getLabel_i18n() != null) {
            existingObjectEntryFolder.setLabel_i18n(objectEntryFolder.getLabel_i18n());
        }
        if (objectEntryFolder.getParentObjectEntryFolderExternalReferenceCode() != null) {
            existingObjectEntryFolder.setParentObjectEntryFolderExternalReferenceCode(objectEntryFolder.getParentObjectEntryFolderExternalReferenceCode());
        }
        if (objectEntryFolder.getParentObjectEntryFolderId() != null) {
            existingObjectEntryFolder.setParentObjectEntryFolderId(objectEntryFolder.getParentObjectEntryFolderId());
        }
        if (objectEntryFolder.getPermissions() != null) {
            existingObjectEntryFolder.setPermissions(objectEntryFolder.getPermissions());
        }
        if (objectEntryFolder.getTitle() != null) {
            existingObjectEntryFolder.setTitle(objectEntryFolder.getTitle());
        }
        if (objectEntryFolder.getViewableBy() != null) {
            existingObjectEntryFolder.setViewableBy(objectEntryFolder.getViewableBy());
        }
        this.preparePatch(objectEntryFolder, existingObjectEntryFolder);
        return this.putObjectEntryFolder(objectEntryFolderId, existingObjectEntryFolder);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/scopes/{scopeKey}/object-entry-folder/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntryFolder patchScopeScopeKeyObjectEntryFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ObjectEntryFolder objectEntryFolder) throws Exception {
        ObjectEntryFolder existingObjectEntryFolder = this.getScopeScopeKeyObjectEntryFolderByExternalReferenceCode(scopeKey, externalReferenceCode);
        if (objectEntryFolder.getDescription() != null) {
            existingObjectEntryFolder.setDescription(objectEntryFolder.getDescription());
        }
        if (objectEntryFolder.getExternalReferenceCode() != null) {
            existingObjectEntryFolder.setExternalReferenceCode(objectEntryFolder.getExternalReferenceCode());
        }
        if (objectEntryFolder.getLabel() != null) {
            existingObjectEntryFolder.setLabel(objectEntryFolder.getLabel());
        }
        if (objectEntryFolder.getLabel_i18n() != null) {
            existingObjectEntryFolder.setLabel_i18n(objectEntryFolder.getLabel_i18n());
        }
        if (objectEntryFolder.getParentObjectEntryFolderExternalReferenceCode() != null) {
            existingObjectEntryFolder.setParentObjectEntryFolderExternalReferenceCode(objectEntryFolder.getParentObjectEntryFolderExternalReferenceCode());
        }
        if (objectEntryFolder.getParentObjectEntryFolderId() != null) {
            existingObjectEntryFolder.setParentObjectEntryFolderId(objectEntryFolder.getParentObjectEntryFolderId());
        }
        if (objectEntryFolder.getPermissions() != null) {
            existingObjectEntryFolder.setPermissions(objectEntryFolder.getPermissions());
        }
        if (objectEntryFolder.getTitle() != null) {
            existingObjectEntryFolder.setTitle(objectEntryFolder.getTitle());
        }
        if (objectEntryFolder.getViewableBy() != null) {
            existingObjectEntryFolder.setViewableBy(objectEntryFolder.getViewableBy());
        }
        this.preparePatch(objectEntryFolder, existingObjectEntryFolder);
        return this.putScopeScopeKeyObjectEntryFolderByExternalReferenceCode(scopeKey, externalReferenceCode, existingObjectEntryFolder);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/scopes/{scopeKey}/object-entry-folders")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ObjectEntryFolder postScopeScopeKeyObjectEntryFolder(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, ObjectEntryFolder objectEntryFolder) throws Exception {
        return new ObjectEntryFolder();
    }

    protected abstract ObjectEntryFolder doPutObjectEntryFolder(Long var1, ObjectEntryFolder var2) throws Exception;

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/object-entry-folders/{objectEntryFolderId}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public final ObjectEntryFolder putObjectEntryFolder(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId, ObjectEntryFolder objectEntryFolder) throws Exception {
        Permission[] permissions = objectEntryFolder.getPermissions();
        ObjectEntryFolder putObjectEntryFolder = this.doPutObjectEntryFolder(objectEntryFolderId, objectEntryFolder);
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putObjectEntryFolderPermissionsPage(putObjectEntryFolder.getId(), permissions);
            putObjectEntryFolder.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[collection.size()]);
            }));
        }
        return putObjectEntryFolder;
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json"})
    @Path(value="/object-entry-folders/batch")
    @Produces(value={"application/json"})
    @PUT
    public Response putObjectEntryFolderBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.putImportTask(ObjectEntryFolder.class.getName(), callbackURL, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="objectEntryFolderId")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/object-entry-folders/{objectEntryFolderId}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putObjectEntryFolderPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="objectEntryFolderId") Long objectEntryFolderId, Permission[] permissions) throws Exception {
        String resourceName = this.getPermissionCheckerResourceName(objectEntryFolderId);
        Long resourceId = this.getPermissionCheckerResourceId(objectEntryFolderId);
        PermissionServiceUtil.checkPermission((long)this.getPermissionCheckerGroupId(objectEntryFolderId), (String)resourceName, (long)resourceId);
        ModelPermissions modelPermissions = ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService);
        Collection roleNames = modelPermissions.getRoleNames();
        for (ResourcePermission resourcePermission : this.resourcePermissionLocalService.getResourcePermissions(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId))) {
            Role role = this.roleLocalService.fetchRole(resourcePermission.getRoleId());
            if (role == null || roleNames.contains(role.getName())) continue;
            for (ResourceAction resourceAction : this.resourceActionLocalService.getResourceActions(resourceName)) {
                this.resourcePermissionLocalService.removeResourcePermission(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId), role.getRoleId(), resourceAction.getActionId());
            }
        }
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), this.getPermissionCheckerGroupId(objectEntryFolderId).longValue(), resourceName, String.valueOf(resourceId), modelPermissions);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", "getObjectEntryFolderPermissionsPage", resourceName, resourceId)).put((Object)"replace", this.addAction("PERMISSIONS", "putObjectEntryFolderPermissionsPage", resourceName, resourceId)).build(), resourceId, resourceName, null);
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="scopeKey"), @Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="ObjectEntryFolder")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/scopes/{scopeKey}/object-entry-folder/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public ObjectEntryFolder putScopeScopeKeyObjectEntryFolderByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="scopeKey") String scopeKey, @Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, ObjectEntryFolder objectEntryFolder) throws Exception {
        return new ObjectEntryFolder();
    }

    public void create(Collection<ObjectEntryFolder> objectEntryFolders, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<ObjectEntryFolder> objectEntryFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction objectEntryFolderUnsafeFunction = objectEntryFolder -> {
            this.deleteObjectEntryFolder(objectEntryFolder.getId());
            return objectEntryFolder;
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(objectEntryFolders, (Object)objectEntryFolderUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(objectEntryFolders, arg_0 -> ((UnsafeFunction)objectEntryFolderUnsafeFunction).apply(arg_0));
        } else {
            for (ObjectEntryFolder objectEntryFolder2 : objectEntryFolders) {
                objectEntryFolderUnsafeFunction.apply((Object)objectEntryFolder2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE", "UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "ObjectEntryFolder";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<ObjectEntryFolder> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<ObjectEntryFolder> objectEntryFolders, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction objectEntryFolderUnsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            objectEntryFolderUnsafeFunction = objectEntryFolder -> this.patchObjectEntryFolder(objectEntryFolder.getId(), (ObjectEntryFolder)objectEntryFolder);
        }
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
            objectEntryFolderUnsafeFunction = objectEntryFolder -> this.putObjectEntryFolder(objectEntryFolder.getId(), (ObjectEntryFolder)objectEntryFolder);
        }
        if (objectEntryFolderUnsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for ObjectEntryFolder");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(objectEntryFolders, (Object)objectEntryFolderUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(objectEntryFolders, arg_0 -> ((UnsafeFunction)objectEntryFolderUnsafeFunction).apply(arg_0));
        } else {
            for (ObjectEntryFolder objectEntryFolder2 : objectEntryFolders) {
                objectEntryFolderUnsafeFunction.apply((Object)objectEntryFolder2);
            }
        }
    }

    public ObjectEntryFolder getItem(Long id) throws Exception {
        return this.getObjectEntryFolder(id);
    }

    protected String getPermissionCheckerActionsResourceName(Object id) throws Exception {
        return this.getPermissionCheckerResourceName(id);
    }

    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerPortletName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Long getPermissionCheckerResourceId(Object id) throws Exception {
        return GetterUtil.getLong((Object)id);
    }

    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, StringUtil.split((String)roleNames)));
        }
        return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, null));
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        HashMap<String, 2> permissions = new HashMap<String, 2>();
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
        List actionIds = this.transform(resourceActions, resourceAction -> resourceAction.getActionId());
        HashSet resourcePermissions = new HashSet();
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 1, String.valueOf(companyId)));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 2, String.valueOf(GroupThreadLocal.getGroupId())));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 3, "0"));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId)));
        List resources = this.transform(resourcePermissions, resourcePermission -> ResourceLocalServiceUtil.getResource((long)resourcePermission.getCompanyId(), (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey()));
        HashSet<Role> roles = new HashSet<Role>();
        if (roleNames != null) {
            for (String string : roleNames) {
                roles.add(this.roleLocalService.getRole(companyId, string));
            }
        } else {
            for (ResourcePermission resourcePermission2 : resourcePermissions) {
                Role role = this.roleLocalService.getRole(resourcePermission2.getRoleId());
                roles.add(role);
            }
        }
        for (final Role role : roles) {
            final HashSet actionsIdsSet = new HashSet();
            for (Resource resource : resources) {
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 1, String.valueOf(resource.getCompanyId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 2, String.valueOf(GroupThreadLocal.getGroupId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 3, "0", role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds));
            }
            if (actionsIdsSet.isEmpty()) continue;
            Permission permission = new Permission(){
                {
                    this.actionIds = actionsIdsSet.toArray(new String[0]);
                    this.roleName = role.getName();
                }
            };
            permissions.put(role.getName(), permission);
        }
        return permissions.values();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<ObjectEntryFolder>, UnsafeFunction<ObjectEntryFolder, ObjectEntryFolder, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<ObjectEntryFolder>, UnsafeConsumer<ObjectEntryFolder, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-object";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(ObjectEntryFolder objectEntryFolder, ObjectEntryFolder existingObjectEntryFolder) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

