/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.client.resource.v1_0;

import com.liferay.headless.object.client.dto.v1_0.Collaborator;
import com.liferay.headless.object.client.http.HttpInvoker;
import com.liferay.headless.object.client.pagination.Page;
import com.liferay.headless.object.client.pagination.Pagination;
import com.liferay.headless.object.client.problem.Problem;
import com.liferay.headless.object.client.serdes.v1_0.CollaboratorSerDes;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface CollaboratorResource {
    public static Builder builder() {
        return new Builder();
    }

    public Page<Collaborator> getObjectEntryFolderCollaboratorsPage(Long var1, Pagination var2) throws Exception;

    public HttpInvoker.HttpResponse getObjectEntryFolderCollaboratorsPageHttpResponse(Long var1, Pagination var2) throws Exception;

    public Page<Collaborator> getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPage(String var1, String var2, Pagination var3) throws Exception;

    public HttpInvoker.HttpResponse getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(String var1, String var2, Pagination var3) throws Exception;

    public Page<Collaborator> postObjectEntryFolderCollaboratorsPage(Long var1, Collaborator[] var2) throws Exception;

    public HttpInvoker.HttpResponse postObjectEntryFolderCollaboratorsPageHttpResponse(Long var1, Collaborator[] var2) throws Exception;

    public void postObjectEntryFolderCollaboratorsPageExportBatch(Long var1, String var2, String var3, String var4) throws Exception;

    public HttpInvoker.HttpResponse postObjectEntryFolderCollaboratorsPageExportBatchHttpResponse(Long var1, String var2, String var3, String var4) throws Exception;

    public Page<Collaborator> postScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPage(String var1, String var2, Collaborator[] var3) throws Exception;

    public HttpInvoker.HttpResponse postScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(String var1, String var2, Collaborator[] var3) throws Exception;

    public static class Builder {
        private String _contextPath = "";
        private Map<String, String> _headers = new LinkedHashMap<String, String>();
        private String _host = "localhost";
        private Locale _locale;
        private String _login;
        private String _password;
        private Map<String, String> _parameters = new LinkedHashMap<String, String>();
        private int _port = 8080;
        private String _scheme = "http";

        public Builder authentication(String login, String password) {
            this._login = login;
            this._password = password;
            return this;
        }

        public Builder bearerToken(String token) {
            return this.header("Authorization", "Bearer " + token);
        }

        public CollaboratorResource build() {
            return new CollaboratorResourceImpl(this);
        }

        public Builder contextPath(String contextPath) {
            this._contextPath = contextPath;
            return this;
        }

        public Builder endpoint(String address, String scheme) {
            String[] addressParts = address.split(":");
            String host = addressParts[0];
            int port = 443;
            if (addressParts.length > 1) {
                String portString = addressParts[1];
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse port from " + portString);
                }
            }
            return this.endpoint(host, port, scheme);
        }

        public Builder endpoint(String host, int port, String scheme) {
            this._host = host;
            this._port = port;
            this._scheme = scheme;
            return this;
        }

        public Builder endpoint(URL url) {
            return this.endpoint(url.getHost(), url.getPort(), url.getProtocol());
        }

        public Builder header(String key, String value) {
            this._headers.put(key, value);
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder parameter(String key, String value) {
            this._parameters.put(key, value);
            return this;
        }

        public Builder parameters(String ... parameters) {
            if (parameters.length % 2 != 0) {
                throw new IllegalArgumentException("Parameters length is not an even number");
            }
            for (int i = 0; i < parameters.length; i += 2) {
                String parameterName = String.valueOf(parameters[i]);
                String parameterValue = String.valueOf(parameters[i + 1]);
                this._parameters.put(parameterName, parameterValue);
            }
            return this;
        }

        private Builder() {
        }
    }

    public static class CollaboratorResourceImpl
    implements CollaboratorResource {
        private static final Logger _logger = Logger.getLogger(CollaboratorResource.class.getName());
        private Builder _builder;

        @Override
        public Page<Collaborator> getObjectEntryFolderCollaboratorsPage(Long objectEntryFolderId, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getObjectEntryFolderCollaboratorsPageHttpResponse(objectEntryFolderId, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, CollaboratorSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getObjectEntryFolderCollaboratorsPageHttpResponse(Long objectEntryFolderId, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-object/v1.0/object-entry-folders/{objectEntryFolderId}/collaborators");
            httpInvoker.path("objectEntryFolderId", objectEntryFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Collaborator> getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPage(String scopeKey, String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(scopeKey, externalReferenceCode, pagination);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, CollaboratorSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse getScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(String scopeKey, String externalReferenceCode, Pagination pagination) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.GET);
            if (pagination != null) {
                httpInvoker.parameter("page", String.valueOf(pagination.getPage()));
                httpInvoker.parameter("pageSize", String.valueOf(pagination.getPageSize()));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-object/v1.0/scopes/{scopeKey}/object-entry-folders/by-external-reference-code/{externalReferenceCode}/collaborators");
            httpInvoker.path("scopeKey", scopeKey);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Collaborator> postObjectEntryFolderCollaboratorsPage(Long objectEntryFolderId, Collaborator[] collaborators) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postObjectEntryFolderCollaboratorsPageHttpResponse(objectEntryFolderId, collaborators);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, CollaboratorSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postObjectEntryFolderCollaboratorsPageHttpResponse(Long objectEntryFolderId, Collaborator[] collaborators) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            ArrayList<String> values = new ArrayList<String>();
            for (Collaborator collaboratorValue : collaborators) {
                values.add(String.valueOf(collaboratorValue));
            }
            httpInvoker.body(((Object)values).toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-object/v1.0/object-entry-folders/{objectEntryFolderId}/collaborators");
            httpInvoker.path("objectEntryFolderId", objectEntryFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public void postObjectEntryFolderCollaboratorsPageExportBatch(Long objectEntryFolderId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postObjectEntryFolderCollaboratorsPageExportBatchHttpResponse(objectEntryFolderId, callbackURL, contentType, fieldNames);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
        }

        @Override
        public HttpInvoker.HttpResponse postObjectEntryFolderCollaboratorsPageExportBatchHttpResponse(Long objectEntryFolderId, String callbackURL, String contentType, String fieldNames) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            httpInvoker.body("[]", "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry<String, String> entry : this._builder._headers.entrySet()) {
                httpInvoker.header(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter(entry.getKey(), entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            if (callbackURL != null) {
                httpInvoker.parameter("callbackURL", String.valueOf(callbackURL));
            }
            if (contentType != null) {
                httpInvoker.parameter("contentType", String.valueOf(contentType));
            }
            if (fieldNames != null) {
                httpInvoker.parameter("fieldNames", String.valueOf(fieldNames));
            }
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-object/v1.0/object-entry-folders/{objectEntryFolderId}/collaborators/export-batch");
            httpInvoker.path("objectEntryFolderId", objectEntryFolderId);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        @Override
        public Page<Collaborator> postScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPage(String scopeKey, String externalReferenceCode, Collaborator[] collaborators) throws Exception {
            HttpInvoker.HttpResponse httpResponse = this.postScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(scopeKey, externalReferenceCode, collaborators);
            String content = httpResponse.getContent();
            if (httpResponse.getStatusCode() / 100 != 2) {
                _logger.log(Level.WARNING, "Unable to process HTTP response content: " + content);
                _logger.log(Level.WARNING, "HTTP response message: " + httpResponse.getMessage());
                _logger.log(Level.WARNING, "HTTP response status code: " + httpResponse.getStatusCode());
                Problem.ProblemException problemException = null;
                if (Objects.equals(httpResponse.getContentType(), "application/json")) {
                    problemException = new Problem.ProblemException(Problem.toDTO(content));
                } else {
                    _logger.log(Level.WARNING, "Unable to process content type: " + httpResponse.getContentType());
                    Problem problem = new Problem();
                    problem.setStatus(String.valueOf(httpResponse.getStatusCode()));
                    problemException = new Problem.ProblemException(problem);
                }
                throw problemException;
            }
            _logger.fine("HTTP response content: " + content);
            _logger.fine("HTTP response message: " + httpResponse.getMessage());
            _logger.fine("HTTP response status code: " + httpResponse.getStatusCode());
            try {
                return Page.of(content, CollaboratorSerDes::toDTO);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to process HTTP response: " + content, e);
                throw new Problem.ProblemException(Problem.toDTO(content));
            }
        }

        @Override
        public HttpInvoker.HttpResponse postScopeScopeKeyObjectEntryFolderByExternalReferenceCodeCollaboratorsPageHttpResponse(String scopeKey, String externalReferenceCode, Collaborator[] collaborators) throws Exception {
            HttpInvoker httpInvoker = HttpInvoker.newHttpInvoker();
            ArrayList<String> values = new ArrayList<String>();
            for (Collaborator collaboratorValue : collaborators) {
                values.add(String.valueOf(collaboratorValue));
            }
            httpInvoker.body(((Object)values).toString(), "application/json");
            if (this._builder._locale != null) {
                httpInvoker.header("Accept-Language", this._builder._locale.toLanguageTag());
            }
            for (Map.Entry entry : this._builder._headers.entrySet()) {
                httpInvoker.header((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry entry : this._builder._parameters.entrySet()) {
                httpInvoker.parameter((String)entry.getKey(), (String)entry.getValue());
            }
            httpInvoker.httpMethod(HttpInvoker.HttpMethod.POST);
            httpInvoker.path(this._builder._scheme + "://" + this._builder._host + ":" + this._builder._port + this._builder._contextPath + "/o/headless-object/v1.0/scopes/{scopeKey}/object-entry-folders/by-external-reference-code/{externalReferenceCode}/collaborators");
            httpInvoker.path("scopeKey", scopeKey);
            httpInvoker.path("externalReferenceCode", externalReferenceCode);
            if (this._builder._login != null && this._builder._password != null) {
                httpInvoker.userNameAndPassword(this._builder._login + ":" + this._builder._password);
            }
            return httpInvoker.invoke();
        }

        private CollaboratorResourceImpl(Builder builder) {
            this._builder = builder;
        }
    }
}

