/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.util.v1_0;

import com.liferay.headless.object.dto.v1_0.Collaborator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.model.SharingEntryModel;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryLocalService;
import com.liferay.sharing.service.SharingEntryService;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CollaboratorUtil {
    public static Collaborator addOrUpdateCollaborator(AcceptLanguage acceptLanguage, long classNameId, long classPK, Collaborator collaborator, long collaboratorId, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, long groupId, SharingEntryService sharingEntryService, String type, UserGroupLocalService userGroupLocalService, UriInfo uriInfo, User user, UserLocalService userLocalService) throws Exception {
        CollaboratorUtil._validateType(type);
        return CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, CollaboratorUtil._addOrUpdateSharingEntry(classNameId, classPK, collaborator, collaboratorId, groupId, sharingEntryService, type, userGroupLocalService, userLocalService), uriInfo, user);
    }

    public static Page<Collaborator> addOrUpdateCollaborators(AcceptLanguage acceptLanguage, long classNameId, long classPK, Collaborator[] collaborators, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, long groupId, SharingEntryService sharingEntryService, UriInfo uriInfo, User user, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) throws Exception {
        List oldSharingEntries = sharingEntryService.getSharingEntries(classNameId, classPK, groupId, -1, -1, null);
        ArrayList<SharingEntry> newSharingEntries = new ArrayList<SharingEntry>();
        ArrayList<Long> sharingEntriesIds = new ArrayList<Long>();
        for (Collaborator collaborator : collaborators) {
            SharingEntry sharingEntry2 = CollaboratorUtil._addOrUpdateSharingEntry(classNameId, classPK, collaborator, collaborator.getId(), groupId, sharingEntryService, collaborator.getType(), userGroupLocalService, userLocalService);
            newSharingEntries.add(sharingEntry2);
            sharingEntriesIds.add(sharingEntry2.getSharingEntryId());
        }
        for (SharingEntry sharingEntry3 : oldSharingEntries) {
            if (sharingEntriesIds.contains(sharingEntry3.getSharingEntryId())) continue;
            sharingEntryService.deleteSharingEntry(sharingEntry3);
        }
        Collections.sort(newSharingEntries, Comparator.comparing(SharingEntryModel::getCreateDate, Comparator.reverseOrder()).thenComparing(SharingEntryModel::getSharingEntryId, Comparator.reverseOrder()));
        return Page.of((Collection)TransformUtil.transform(newSharingEntries, sharingEntry -> CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, sharingEntry, uriInfo, user)));
    }

    public static void deleteCollaborator(long classNameId, long classPK, Long collaboratorId, SharingEntryService sharingEntryService, String type) throws Exception {
        CollaboratorUtil._validateType(type);
        if (StringUtil.equals((String)"User", (String)type)) {
            sharingEntryService.deleteSharingEntry(0L, collaboratorId.longValue(), classNameId, classPK);
        } else {
            sharingEntryService.deleteSharingEntry(collaboratorId.longValue(), 0L, classNameId, classPK);
        }
    }

    public static Collaborator getCollaborator(AcceptLanguage acceptLanguage, long classNameId, long classPK, Long collaboratorId, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, SharingEntryService sharingEntryService, String type, UriInfo uriInfo, User user) throws Exception {
        CollaboratorUtil._validateType(type);
        if (StringUtil.equals((String)"User", (String)type)) {
            return CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, sharingEntryService.getSharingEntry(0L, collaboratorId.longValue(), classNameId, classPK), uriInfo, user);
        }
        return CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, sharingEntryService.getSharingEntry(collaboratorId.longValue(), 0L, classNameId, classPK), uriInfo, user);
    }

    public static Page<Collaborator> getCollaborators(AcceptLanguage acceptLanguage, long classNameId, long classPK, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, long groupId, Pagination pagination, SharingEntryLocalService sharingEntryLocalService, SharingEntryService sharingEntryService, UriInfo uriInfo, User user) throws Exception {
        return Page.of((Collection)TransformUtil.transform((Collection)sharingEntryService.getSharingEntries(classNameId, classPK, groupId, pagination.getStartPosition(), pagination.getEndPosition(), OrderByComparatorFactoryUtil.create((String)"SharingEntry", (Object[])new Object[]{"createDate", false, "sharingEntryId", false})), sharingEntry -> CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, sharingEntry, uriInfo, user)), (Pagination)pagination, (long)sharingEntryLocalService.getSharingEntriesCount(classNameId, classPK));
    }

    public static long getGroupId(long companyId, GroupLocalService groupLocalService, String scopeKey) throws Exception {
        Long groupId = GroupUtil.getGroupId((long)companyId, (String)scopeKey, (GroupLocalService)groupLocalService);
        if (groupId != null) {
            return groupId;
        }
        if (Objects.equals(scopeKey, "0")) {
            return 0L;
        }
        throw new NoSuchGroupException();
    }

    public static Collaborator toCollaborator(AcceptLanguage acceptLanguage, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, SharingEntry sharingEntry, UriInfo uriInfo, User user) throws Exception {
        return (Collaborator)dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(acceptLanguage.isAcceptAllLanguages(), new HashMap(), dtoConverterRegistry, (Object)sharingEntry.getSharingEntryId(), acceptLanguage.getPreferredLocale(), uriInfo, user), (Object)sharingEntry);
    }

    private static SharingEntry _addOrUpdateSharingEntry(long classNameId, long classPK, Collaborator collaborator, long collaboratorId, long groupId, SharingEntryService sharingEntryService, String type, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) throws Exception {
        CollaboratorUtil._validateType(type);
        long toUserGroupId = 0L;
        long toUserId = 0L;
        if (StringUtil.equals((String)"UserGroup", (String)type)) {
            UserGroup userGroup = userGroupLocalService.getUserGroup(collaboratorId);
            toUserGroupId = userGroup.getUserGroupId();
        } else {
            User user = userLocalService.getUser(collaboratorId);
            toUserId = user.getUserId();
        }
        boolean shareable = false;
        if (collaborator.getShare() != null) {
            shareable = collaborator.getShare();
        }
        return sharingEntryService.addOrUpdateSharingEntry(null, toUserGroupId, toUserId, classNameId, classPK, groupId, shareable, (Collection)TransformUtil.transformToList((Object[])collaborator.getActionIds(), SharingEntryAction::parseFromActionId), collaborator.getDateExpired(), new ServiceContext());
    }

    private static void _validateType(String type) {
        if (!StringUtil.equals((String)"User", (String)type) && !StringUtil.equals((String)"UserGroup", (String)type)) {
            throw new IllegalArgumentException("Collaborator type must be \"User\" or \"UserGroup\"");
        }
    }
}

