/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.object.util.v1_0;

import com.liferay.headless.object.dto.v1_0.Collaborator;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.security.permission.SharingEntryAction;
import com.liferay.sharing.service.SharingEntryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;

public class CollaboratorUtil {
    public static Page<Collaborator> addOrUpdateCollaborators(AcceptLanguage acceptLanguage, long classNameId, long classPK, Collaborator[] collaborators, long companyId, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, long groupId, SharingEntryService sharingEntryService, UriInfo uriInfo, User user, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) throws Exception {
        List oldSharingEntries = sharingEntryService.getSharingEntries(classNameId, classPK, groupId, -1, -1);
        ArrayList<SharingEntry> newSharingEntries = new ArrayList<SharingEntry>();
        ArrayList<Long> sharingEntriesIds = new ArrayList<Long>();
        for (Collaborator collaborator : collaborators) {
            SharingEntry sharingEntry2 = CollaboratorUtil._addOrUpdateSharingEntry(classNameId, classPK, collaborator, companyId, groupId, sharingEntryService, userGroupLocalService, userLocalService);
            newSharingEntries.add(sharingEntry2);
            sharingEntriesIds.add(sharingEntry2.getSharingEntryId());
        }
        for (SharingEntry sharingEntry3 : oldSharingEntries) {
            if (sharingEntriesIds.contains(sharingEntry3.getSharingEntryId())) continue;
            sharingEntryService.deleteSharingEntry(sharingEntry3);
        }
        return Page.of((Collection)TransformUtil.transform(newSharingEntries, sharingEntry -> CollaboratorUtil.toCollaborator(acceptLanguage, dtoConverter, dtoConverterRegistry, sharingEntry, uriInfo, user)));
    }

    public static long getGroupId(long companyId, GroupLocalService groupLocalService, String scopeKey) throws Exception {
        Long groupId = GroupUtil.getGroupId((long)companyId, (String)scopeKey, (GroupLocalService)groupLocalService);
        if (groupId != null) {
            return groupId;
        }
        if (Objects.equals(scopeKey, "0")) {
            return 0L;
        }
        throw new NoSuchGroupException();
    }

    public static Collaborator toCollaborator(AcceptLanguage acceptLanguage, DTOConverter<SharingEntry, Collaborator> dtoConverter, DTOConverterRegistry dtoConverterRegistry, SharingEntry sharingEntry, UriInfo uriInfo, User user) throws Exception {
        return (Collaborator)dtoConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(acceptLanguage.isAcceptAllLanguages(), new HashMap(), dtoConverterRegistry, (Object)sharingEntry.getSharingEntryId(), acceptLanguage.getPreferredLocale(), uriInfo, user), (Object)sharingEntry);
    }

    private static SharingEntry _addOrUpdateSharingEntry(long classNameId, long classPK, Collaborator collaborator, long companyId, long groupId, SharingEntryService sharingEntryService, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) throws Exception {
        long toUserGroupId = 0L;
        long toUserId = 0L;
        if (Objects.equals((Object)Collaborator.Type.USER_GROUP, (Object)collaborator.getType())) {
            UserGroup userGroup = userGroupLocalService.getUserGroupByExternalReferenceCode(collaborator.getExternalReferenceCode(), companyId);
            toUserGroupId = userGroup.getUserGroupId();
        } else {
            User user = userLocalService.getUserByExternalReferenceCode(collaborator.getExternalReferenceCode(), companyId);
            toUserId = user.getUserId();
        }
        boolean shareable = false;
        if (collaborator.getShare() != null) {
            shareable = collaborator.getShare();
        }
        return sharingEntryService.addOrUpdateSharingEntry(null, toUserGroupId, toUserId, classNameId, classPK, groupId, shareable, (Collection)TransformUtil.transformToList((Object[])collaborator.getActionIds(), SharingEntryAction::parseFromActionId), collaborator.getDateExpired(), new ServiceContext());
    }
}

