/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.TransformUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseAssetLibraryResourceImpl
implements AssetLibraryResource,
EntityModelResource,
VulcanBatchEngineTaskItemDelegate<AssetLibrary> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeFunction<AssetLibrary, AssetLibrary, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeConsumer<AssetLibrary, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseAssetLibraryResourceImpl.class);

    @Operation(description="Deletes the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @DELETE
    @Path(value="/asset-libraries/batch")
    @Produces(value={"application/json"})
    public Response deleteAssetLibraryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.deleteImportTask(AssetLibrary.class.getName(), callbackURL, object)).build();
    }

    @Operation(description="Deletes the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Unpins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryByExternalReferenceCodePin(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
    }

    @Operation(description="Unpins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @DELETE
    @Path(value="/asset-libraries/{assetLibraryId}/pins")
    @Produces(value={"application/json", "application/xml"})
    public void deleteAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
    }

    @Operation(description="Retrieves the asset libraries. Results can be paginated, filtered, searched, and sorted.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="keywords"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries")
    @Produces(value={"application/json", "application/xml"})
    public Page<AssetLibrary> getAssetLibrariesPage(@Parameter(hidden=true) @QueryParam(value="keywords") String keywords, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the pinned asset libraries.")
    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/pinned-by-me")
    @Produces(value={"application/json", "application/xml"})
    public Page<AssetLibrary> getAssetLibrariesPinnedByMePage(@Context Pagination pagination) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Retrieves the asset library by external reference code.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @GET
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary getAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/{assetLibraryId}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibrary(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Updates the asset library using only the fields received in the request body with the given external reference code. Any other fields are left untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary patchAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        AssetLibrary existingAssetLibrary = this.getAssetLibraryByExternalReferenceCode(externalReferenceCode);
        if (assetLibrary.getAssetLibraryKey() != null) {
            existingAssetLibrary.setAssetLibraryKey(assetLibrary.getAssetLibraryKey());
        }
        if (assetLibrary.getDescription() != null) {
            existingAssetLibrary.setDescription(assetLibrary.getDescription());
        }
        if (assetLibrary.getDescription_i18n() != null) {
            existingAssetLibrary.setDescription_i18n(assetLibrary.getDescription_i18n());
        }
        if (assetLibrary.getExternalReferenceCode() != null) {
            existingAssetLibrary.setExternalReferenceCode(assetLibrary.getExternalReferenceCode());
        }
        if (assetLibrary.getName() != null) {
            existingAssetLibrary.setName(assetLibrary.getName());
        }
        if (assetLibrary.getName_i18n() != null) {
            existingAssetLibrary.setName_i18n(assetLibrary.getName_i18n());
        }
        this.preparePatch(assetLibrary, existingAssetLibrary);
        return this.putAssetLibraryByExternalReferenceCode(externalReferenceCode, existingAssetLibrary);
    }

    @Operation(description="Adds a new asset library")
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Parameters(value={@Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json"})
    @Path(value="/asset-libraries/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postAssetLibraryBatch(@Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(AssetLibrary.class.getName(), callbackURL, null, object)).build();
    }

    @Operation(description="Replaces the asset library with information sent in the request body with the given external reference code. Any missing fields are deleted unless they are required.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryByExternalReferenceCode(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Pins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="externalReferenceCode")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/by-external-reference-code/{externalReferenceCode}/pins")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryByExternalReferenceCodePin(@Parameter(hidden=true) @NotNull @PathParam(value="externalReferenceCode") String externalReferenceCode) throws Exception {
        return new AssetLibrary();
    }

    @Operation(description="Pins the asset library.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="assetLibraryId")})
    @Tags(value={@Tag(name="AssetLibrary")})
    @Path(value="/asset-libraries/{assetLibraryId}/pins")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public AssetLibrary putAssetLibraryPin(@Parameter(hidden=true) @NotNull @PathParam(value="assetLibraryId") Long assetLibraryId) throws Exception {
        return new AssetLibrary();
    }

    public void create(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction assetLibraryUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            assetLibraryUnsafeFunction = assetLibrary -> this.postAssetLibrary((AssetLibrary)assetLibrary);
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT")) {
            String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
                assetLibraryUnsafeFunction = assetLibrary -> {
                    AssetLibrary persistedAssetLibrary = null;
                    try {
                        AssetLibrary getAssetLibrary = this.getAssetLibraryByExternalReferenceCode(assetLibrary.getExternalReferenceCode());
                        persistedAssetLibrary = this.patchAssetLibrary(getAssetLibrary.getId() != null ? getAssetLibrary.getId() : (Long)parameters.get("assetLibraryId"), (AssetLibrary)assetLibrary);
                    }
                    catch (NoSuchModelException noSuchModelException) {
                        persistedAssetLibrary = this.postAssetLibrary((AssetLibrary)assetLibrary);
                    }
                    return persistedAssetLibrary;
                };
            }
            if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"UPDATE")) {
                assetLibraryUnsafeFunction = assetLibrary -> this.putAssetLibraryByExternalReferenceCode(assetLibrary.getExternalReferenceCode(), (AssetLibrary)assetLibrary);
            }
        }
        if (assetLibraryUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for AssetLibrary");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(assetLibraries, (Object)assetLibraryUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(assetLibraries, arg_0 -> ((UnsafeFunction)assetLibraryUnsafeFunction).apply(arg_0));
        } else {
            for (AssetLibrary assetLibrary2 : assetLibraries) {
                assetLibraryUnsafeFunction.apply((Object)assetLibrary2);
            }
        }
    }

    public void delete(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction assetLibraryUnsafeFunction = assetLibrary -> {
            if (assetLibrary.getId() != null) {
                try {
                    this.deleteAssetLibrary(assetLibrary.getId());
                    return assetLibrary;
                }
                catch (Exception exception) {
                    if (assetLibrary.getExternalReferenceCode() != null) {
                        this.deleteAssetLibraryByExternalReferenceCode(assetLibrary.getExternalReferenceCode());
                        return assetLibrary;
                    }
                }
            } else if (assetLibrary.getExternalReferenceCode() != null) {
                this.deleteAssetLibraryByExternalReferenceCode(assetLibrary.getExternalReferenceCode());
                return assetLibrary;
            }
            throw new UnsupportedOperationException("Unable to delete by external reference code or ID");
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(assetLibraries, (Object)assetLibraryUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(assetLibraries, arg_0 -> ((UnsafeFunction)assetLibraryUnsafeFunction).apply(arg_0));
        } else {
            for (AssetLibrary assetLibrary2 : assetLibraries) {
                assetLibraryUnsafeFunction.apply((Object)assetLibrary2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT", "UPSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"PARTIAL_UPDATE"});
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "AssetLibrary";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<AssetLibrary> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        return this.getAssetLibrariesPage((String)((Object)parameters.get("keywords")), search, filter, pagination, sorts);
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<AssetLibrary> assetLibraries, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction assetLibraryUnsafeFunction = null;
        String updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")));
        if (StringUtil.equalsIgnoreCase((String)updateStrategy, (String)"PARTIAL_UPDATE")) {
            assetLibraryUnsafeFunction = assetLibrary -> this.patchAssetLibrary(assetLibrary.getId() != null ? assetLibrary.getId() : (Long)parameters.get("assetLibraryId"), (AssetLibrary)assetLibrary);
        }
        if (assetLibraryUnsafeFunction == null) {
            throw new NotSupportedException("Update strategy \"" + updateStrategy + "\" is not supported for AssetLibrary");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(assetLibraries, (Object)assetLibraryUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(assetLibraries, arg_0 -> ((UnsafeFunction)assetLibraryUnsafeFunction).apply(arg_0));
        } else {
            for (AssetLibrary assetLibrary2 : assetLibraries) {
                assetLibraryUnsafeFunction.apply((Object)assetLibrary2);
            }
        }
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeFunction<AssetLibrary, AssetLibrary, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<AssetLibrary>, UnsafeConsumer<AssetLibrary, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        if (contextHttpServletRequest != null && contextHttpServletRequest.getAttribute("CTX") == null) {
            contextHttpServletRequest.setAttribute("CTX", (Object)ServletContextPool.get((String)""));
        }
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = contextUriInfo;
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(AssetLibrary assetLibrary, AssetLibrary existingAssetLibrary) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        try {
            return this.unsafeTransformToLongArray(collection, unsafeFunction);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return (long[])this._unsafeTransformToPrimitiveArray(collection, unsafeFunction, long[].class);
    }

    private <T, R, E extends Throwable> Object _unsafeTransformToPrimitiveArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<?> clazz) throws E {
        List<R> list = this.unsafeTransform(collection, unsafeFunction);
        Object array = clazz.cast(Array.newInstance(clazz.getComponentType(), list.size()));
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }
}

