/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.dto.v1_0.converter;

import com.liferay.headless.asset.library.dto.v1_0.Role;
import com.liferay.headless.asset.library.dto.v1_0.UserAccount;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.User"}, service={DTOConverter.class})
public class UserAccountDTOConverter
implements DTOConverter<User, UserAccount> {
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return UserAccount.class.getName();
    }

    public UserAccount toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        final User user = this._userLocalService.getUser(((Long)dtoConverterContext.getId()).longValue());
        return new UserAccount(){
            {
                this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                this.setId(() -> ((User)user).getUserId());
                this.setImage(() -> {
                    if (user.getPortraitId() == 0L) {
                        return null;
                    }
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setPathImage(UserAccountDTOConverter.this._portal.getPathImage());
                        }
                    };
                    return user.getPortraitURL(themeDisplay);
                });
                this.setName(() -> ((User)user).getFullName());
                this.setRoles(() -> (Role[])NestedFieldsSupplier.supply((String)"roles", nestedFieldNames -> (Role[])TransformUtil.transformToArray((Collection)UserAccountDTOConverter.this._roleLocalService.getUserRoles(user.getUserId()), role -> UserAccountDTOConverter.this._toRole((com.liferay.portal.kernel.model.Role)role), Role.class)));
            }
        };
    }

    private Role _toRole(final com.liferay.portal.kernel.model.Role role) throws PortalException {
        return new Role(){
            {
                this.setExternalReferenceCode(() -> ((com.liferay.portal.kernel.model.Role)role).getExternalReferenceCode());
                this.setId(() -> ((com.liferay.portal.kernel.model.Role)role).getRoleId());
                this.setName(() -> ((com.liferay.portal.kernel.model.Role)role).getName());
                this.setRoleType(() -> ((com.liferay.portal.kernel.model.Role)role).getType());
            }
        };
    }
}

