/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.depot.model.DepotAppCustomization;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotAppCustomizationLocalService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.Settings;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-library.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetLibraryResource.class})
public class AssetLibraryResourceImpl
extends BaseAssetLibraryResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.AssetLibraryDTOConverter)")
    private DTOConverter<DepotEntry, AssetLibrary> _assetLibraryDTOConverter;
    @Reference
    private DepotAppCustomizationLocalService _depotAppCustomizationLocalService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;

    @Override
    public void deleteAssetLibrary(Long assetLibraryId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        this._depotEntryService.deleteDepotEntry(depotEntry.getDepotEntryId());
    }

    @Override
    public void deleteAssetLibraryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        this.deleteAssetLibrary(this._getGroupIdByExternalReferenceCode(externalReferenceCode));
    }

    @Override
    public Page<AssetLibrary> getAssetLibrariesPage(String keywords, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, (Filter)filter, (String)DepotEntry.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
        }, (Sort[])sorts, document -> this._toAssetLibrary(this._depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public AssetLibrary getAssetLibrary(Long assetLibraryId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue()));
    }

    @Override
    public AssetLibrary getAssetLibraryByExternalReferenceCode(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(externalReferenceCode)));
    }

    @Override
    public AssetLibrary patchAssetLibrary(Long assetLibraryId, AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(assetLibraryId.longValue());
        Group group = depotEntry.getGroup();
        String name = (String)this._getValue(() -> group.getName(this.contextAcceptLanguage.getPreferredLocale()), () -> ((AssetLibrary)assetLibrary).getName());
        Map nameMap = (Map)this._getValue(() -> LocalizedMapUtil.getI18nMap((Map)group.getNameMap()), () -> ((AssetLibrary)assetLibrary).getName_i18n());
        String description = (String)this._getValue(() -> group.getDescription(this.contextAcceptLanguage.getPreferredLocale()), () -> ((AssetLibrary)assetLibrary).getDescription());
        Map descriptionMap = (Map)this._getValue(() -> LocalizedMapUtil.getI18nMap((Map)group.getDescriptionMap()), () -> ((AssetLibrary)assetLibrary).getDescription_i18n());
        UnicodeProperties unicodeProperties = (UnicodeProperties)this._getValue(() -> this._getUnicodeProperties(this.contextCompany.getCompanyId(), group.getExternalReferenceCode()), () -> this._toUnicodeProperties(assetLibrary.getSettings()));
        return this._toAssetLibrary(this._depotEntryService.updateDepotEntry(depotEntry.getDepotEntryId(), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)name, (Map)nameMap), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)description, (Map)descriptionMap), this._getDepotAppCustomizationMap(this.contextCompany.getCompanyId(), group.getExternalReferenceCode()), unicodeProperties, this._getServiceContext()));
    }

    @Override
    public AssetLibrary patchAssetLibraryByExternalReferenceCode(String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this.patchAssetLibrary(this._getGroupIdByExternalReferenceCode(externalReferenceCode), assetLibrary);
    }

    @Override
    public AssetLibrary postAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.addDepotEntry(LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getName(), (Map)assetLibrary.getName_i18n()), LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getDescription(), (Map)assetLibrary.getDescription_i18n()), this._getServiceContext()));
    }

    @Override
    public AssetLibrary putAssetLibraryByExternalReferenceCode(String externalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._addOrUpdateDepotEntry(LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getDescription(), (Map)assetLibrary.getDescription_i18n()), externalReferenceCode, LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)assetLibrary.getName(), (Map)assetLibrary.getName_i18n()), this._getServiceContext(), this._toUnicodeProperties(assetLibrary.getSettings())));
    }

    private DepotEntry _addOrUpdateDepotEntry(Map<Locale, String> descriptionMap, String externalReferenceCode, Map<Locale, String> nameMap, ServiceContext serviceContext, UnicodeProperties unicodeProperties) throws Exception {
        DepotEntry depotEntry = null;
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        if (group != null) {
            depotEntry = this._depotEntryService.getGroupDepotEntry(group.getGroupId());
            depotEntry = this._depotEntryService.updateDepotEntry(depotEntry.getDepotEntryId(), nameMap, descriptionMap, this._getDepotAppCustomizationMap(depotEntry.getCompanyId(), externalReferenceCode), unicodeProperties, serviceContext);
        } else {
            depotEntry = this._depotEntryService.addDepotEntry(nameMap, descriptionMap, serviceContext);
        }
        group = depotEntry.getGroup();
        group.setExternalReferenceCode(externalReferenceCode);
        this._groupLocalService.updateGroup(group);
        return depotEntry;
    }

    private Map<String, Boolean> _getDepotAppCustomizationMap(long companyId, String externalReferenceCode) throws Exception {
        HashMap<String, Boolean> depotAppCustomizationMap = new HashMap<String, Boolean>();
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (group == null) {
            return depotAppCustomizationMap;
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(group.getGroupId());
        for (DepotAppCustomization depotAppCustomization : this._depotAppCustomizationLocalService.getDepotAppCustomizations(depotEntry.getDepotEntryId())) {
            depotAppCustomizationMap.put(depotAppCustomization.getPortletId(), depotAppCustomization.isEnabled());
        }
        return depotAppCustomizationMap;
    }

    private long _getGroupIdByExternalReferenceCode(String externalReferenceCode) throws Exception {
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return group.getGroupId();
    }

    private ServiceContext _getServiceContext() throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DepotEntry.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        serviceContext.setModifiedDate(new Date());
        return serviceContext;
    }

    private UnicodeProperties _getUnicodeProperties(long companyId, String externalReferenceCode) {
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (group != null) {
            return group.getTypeSettingsProperties();
        }
        return new UnicodeProperties(true);
    }

    private <T, E extends Exception> T _getValue(UnsafeSupplier<T, E> defaultValueUnsafeSupplier, UnsafeSupplier<T, E> valueUnsafeSupplier) throws Exception {
        Object value = valueUnsafeSupplier.get();
        if (value == null) {
            return (T)defaultValueUnsafeSupplier.get();
        }
        return (T)value;
    }

    private AssetLibrary _toAssetLibrary(DepotEntry depotEntry) throws Exception {
        return (AssetLibrary)this._assetLibraryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"create", this.addAction("ADD_DEPOT_ENTRY", (GroupedModel)depotEntry, "postAssetLibrary")).put((Object)"delete", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibrary")).put((Object)"get", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary")).put((Object)"permissions", this.addAction("PERMISSIONS", (GroupedModel)depotEntry, "patchAssetLibrary")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)depotEntry, "patchAssetLibrary")).build(), this._dtoConverterRegistry, (Object)depotEntry.getGroupId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private UnicodeProperties _toUnicodeProperties(Settings settings) {
        if (settings == null) {
            return null;
        }
        return UnicodePropertiesBuilder.create((boolean)true).put("autoTaggingEnabled", GetterUtil.getString((String)Boolean.toString(settings.getAutoTaggingEnabled()), (String)"false")).put("logoColor", GetterUtil.getString((String)settings.getLogoColor(), (String)"color-0")).put("sharingEnabled", GetterUtil.getString((String)Boolean.toString(settings.getSharingEnabled()), (String)"false")).put("useCustomLanguages", GetterUtil.getString((String)Boolean.toString(settings.getUseCustomLanguages()), (String)"false")).build();
    }
}

