/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.dto.v1_0.converter;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.MimeTypeLimit;
import com.liferay.headless.asset.library.dto.v1_0.Settings;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.depot.model.DepotEntry"}, service={DTOConverter.class})
public class AssetLibraryDTOConverter
implements DTOConverter<DepotEntry, AssetLibrary> {
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return AssetLibrary.class.getSimpleName();
    }

    public String getJaxRsLink(long classPK, UriInfo uriInfo) {
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-asset-library", BaseAssetLibraryResourceImpl.class, (String)"getAssetLibrary", (UriInfo)uriInfo, (Object[])new Object[]{classPK});
    }

    public AssetLibrary toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        return this.toDTO(dtoConverterContext, this._depotEntryLocalService.getGroupDepotEntry(((Long)dtoConverterContext.getId()).longValue()));
    }

    public AssetLibrary toDTO(final DTOConverterContext dtoConverterContext, final DepotEntry depotEntry) throws Exception {
        final Group group = depotEntry.getGroup();
        return new AssetLibrary(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setDateCreated(() -> ((DepotEntry)depotEntry).getCreateDate());
                this.setDateModified(() -> ((DepotEntry)depotEntry).getModifiedDate());
                this.setDescription(() -> group.getDescription(dtoConverterContext.getLocale()));
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getDescriptionMap()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setId(() -> ((Group)group).getGroupId());
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap()));
                this.setNumberOfUserAccounts(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfUserAccounts", nestedField -> AssetLibraryDTOConverter.this._userLocalService.getGroupUsersCount(group.getGroupId())));
                this.setNumberOfUserGroups(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfUserGroups", nestedField -> AssetLibraryDTOConverter.this._userGroupLocalService.getGroupUserGroupsCount(group.getGroupId())));
                this.setSettings(() -> (Settings)NestedFieldsSupplier.supply((String)"settings", nestedField -> AssetLibraryDTOConverter.this._toSettings(group)));
            }
        };
    }

    private MimeTypeLimit[] _toMimeTypeLimits(UnicodeProperties unicodeProperties) {
        ArrayList<2> mimeTypeLimits = new ArrayList<2>();
        for (final Map.Entry entry : unicodeProperties.entrySet()) {
            final String key = (String)entry.getKey();
            if (!key.startsWith("mimeTypeLimit-")) continue;
            mimeTypeLimits.add(new MimeTypeLimit(){
                {
                    this.setMaximumSize(() -> GetterUtil.getInteger((String)((String)entry.getValue())));
                    this.setMimeType(() -> key.substring("mimeTypeLimit-".length()));
                }
            });
        }
        return mimeTypeLimits.toArray(new MimeTypeLimit[0]);
    }

    private Settings _toSettings(final Group group) {
        final UnicodeProperties unicodeProperties = group.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setAutoTaggingEnabled(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"autoTaggingEnabled"))));
                this.setAvailableLanguageIds(() -> ((Group)group).getAvailableLanguageIds());
                this.setDefaultLanguageId(() -> ((Group)group).getDefaultLanguageId());
                this.setLogoColor(() -> GetterUtil.get((String)((String)unicodeProperties.get((Object)"logoColor")), (String)"color-0"));
                this.setMimeTypeLimits(() -> AssetLibraryDTOConverter.this._toMimeTypeLimits(unicodeProperties));
                this.setSharingEnabled(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"sharingEnabled"))));
                this.setUseCustomLanguages(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"useCustomLanguages"))));
            }
        };
    }
}

