/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.depot.model.DepotAppCustomization;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryPin;
import com.liferay.depot.service.DepotAppCustomizationLocalService;
import com.liferay.depot.service.DepotEntryPinLocalService;
import com.liferay.depot.service.DepotEntryPinService;
import com.liferay.depot.service.DepotEntryService;
import com.liferay.document.library.configuration.DLSizeLimitConfigurationProvider;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.MimeTypeLimit;
import com.liferay.headless.asset.library.dto.v1_0.Settings;
import com.liferay.headless.asset.library.internal.odata.entity.v1_0.AssetLibraryEntityModel;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.headless.asset.library.internal.util.AssetLibraryUtil;
import com.liferay.headless.asset.library.resource.v1_0.AssetLibraryResource;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/asset-library.properties"}, scope=ServiceScope.PROTOTYPE, service={AssetLibraryResource.class})
public class AssetLibraryResourceImpl
extends BaseAssetLibraryResourceImpl {
    private static final AssetLibraryEntityModel _assetLibraryEntityModel = new AssetLibraryEntityModel();
    @Reference(target="(component.name=com.liferay.headless.asset.library.internal.dto.v1_0.converter.AssetLibraryDTOConverter)")
    private DTOConverter<DepotEntry, AssetLibrary> _assetLibraryDTOConverter;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DepotAppCustomizationLocalService _depotAppCustomizationLocalService;
    @Reference(target="(model.class.name=com.liferay.depot.model.DepotEntry)")
    private ModelResourcePermission<DepotEntry> _depotEntryModelResourcePermission;
    @Reference
    private DepotEntryPinLocalService _depotEntryPinLocalService;
    @Reference
    private DepotEntryPinService _depotEntryPinService;
    @Reference
    private DepotEntryService _depotEntryService;
    @Reference
    private DLSizeLimitConfigurationProvider _dlSizeLimitConfigurationProvider;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Group)")
    private ModelResourcePermission<Group> _groupModelResourcePermission;

    @Override
    public void deleteAssetLibrary(String assetLibraryExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(assetLibraryExternalReferenceCode));
        this._depotEntryService.deleteDepotEntry(depotEntry.getDepotEntryId());
    }

    @Override
    public void deleteAssetLibraryPin(String assetLibraryExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(assetLibraryExternalReferenceCode));
        this._depotEntryPinService.deleteDepotEntryPin(this.contextUser.getUserId(), depotEntry.getDepotEntryId());
    }

    @Override
    public Page<AssetLibrary> getAssetLibrariesPinnedByMePage(Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        ArrayList<AssetLibrary> assetLibraries = new ArrayList<AssetLibrary>(pagination.getPageSize());
        List depotEntryPins = this._depotEntryPinLocalService.getUserDepotEntryPins(this.contextUser.getUserId(), pagination.getStartPosition(), pagination.getEndPosition());
        for (DepotEntryPin depotEntryPin : depotEntryPins) {
            assetLibraries.add(this._toAssetLibrary(this._depotEntryService.getDepotEntry(depotEntryPin.getDepotEntryId())));
        }
        return Page.of(assetLibraries, (Pagination)pagination, (long)this._depotEntryPinLocalService.getUserDepotEntryPinsCount(this.contextUser.getUserId()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _assetLibraryEntityModel;
    }

    @Override
    public AssetLibrary patchAssetLibrary(String assetLibraryExternalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(assetLibraryExternalReferenceCode));
        Group group = depotEntry.getGroup();
        String name = (String)this._getValue(() -> group.getName(this.contextAcceptLanguage.getPreferredLocale()), () -> ((AssetLibrary)assetLibrary).getName());
        String description = (String)this._getValue(() -> group.getDescription(this.contextAcceptLanguage.getPreferredLocale()), () -> ((AssetLibrary)assetLibrary).getDescription());
        if (assetLibrary.getSettings() == null) {
            assetLibrary.setSettings(Settings::new);
        }
        UnicodeProperties unicodeProperties = this._patchUnicodeProperties(assetLibrary.getSettings(), this._getUnicodeProperties(this.contextCompany.getCompanyId(), group.getExternalReferenceCode()));
        AssetLibrary updatedAssetLibrary = this._toAssetLibrary(this._addOrUpdateDepotEntry(assetLibrary, LocalizedMapUtil.patchLocalizedMap((Map)group.getDescriptionMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)description, (Map)assetLibrary.getDescription_i18n()), group.getExternalReferenceCode(), LocalizedMapUtil.patchLocalizedMap((Map)group.getNameMap(), (Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)name, (Map)assetLibrary.getName_i18n()), this._getServiceContext(), unicodeProperties, this._dlSizeLimitConfigurationProvider.getGroupMimeTypeSizeLimit(group.getGroupId())));
        Permission[] permissions = assetLibrary.getPermissions();
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putAssetLibraryPermissionsPage(updatedAssetLibrary.getExternalReferenceCode(), permissions);
            updatedAssetLibrary.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[0]);
            }));
        }
        return updatedAssetLibrary;
    }

    @Override
    public AssetLibrary putAssetLibraryPin(String assetLibraryExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        DepotEntry depotEntry = this._getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(assetLibraryExternalReferenceCode));
        this._depotEntryPinService.addDepotEntryPin(this.contextUser.getUserId(), depotEntry.getDepotEntryId());
        return this._toAssetLibrary(depotEntry);
    }

    @Override
    protected Page<AssetLibrary> doGetAssetLibrariesPage(String keywords, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, (Filter)filter, (String)DepotEntry.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> {}, searchContext -> {
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            if (Validator.isNotNull((String)search)) {
                searchContext.setKeywords(search);
            }
        }, (Sort[])sorts, document -> this._toAssetLibrary(this._depotEntryService.getDepotEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    protected AssetLibrary doGetAssetLibrary(String assetLibraryExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._depotEntryService.getGroupDepotEntry(this._getGroupIdByExternalReferenceCode(assetLibraryExternalReferenceCode)));
    }

    @Override
    protected AssetLibrary doPostAssetLibrary(AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._addOrUpdateDepotEntry(assetLibrary, this._getLocalizedMap(assetLibrary.getDescription(), assetLibrary.getDescription_i18n()), "", this._getLocalizedMap(assetLibrary.getName(), assetLibrary.getName_i18n()), this._getServiceContext(), this._putUnicodeProperties(assetLibrary.getSettings()), new LinkedHashMap<String, Long>()));
    }

    @Override
    protected AssetLibrary doPutAssetLibrary(String assetLibraryExternalReferenceCode, AssetLibrary assetLibrary) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        return this._toAssetLibrary(this._addOrUpdateDepotEntry(assetLibrary, this._getLocalizedMap(assetLibrary.getDescription(), assetLibrary.getDescription_i18n()), assetLibraryExternalReferenceCode, this._getLocalizedMap(assetLibrary.getName(), assetLibrary.getName_i18n()), this._getServiceContext(), this._putUnicodeProperties(assetLibrary.getSettings()), new LinkedHashMap<String, Long>()));
    }

    @Override
    protected Long getPermissionCheckerGroupId(String groupExternalReferenceCode) throws Exception {
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(groupExternalReferenceCode, this.contextCompany.getCompanyId());
        return group.getGroupId();
    }

    @Override
    protected Long getPermissionCheckerResourceId(String externalReferenceCode) throws Exception {
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(this.getPermissionCheckerGroupId(externalReferenceCode).longValue());
        return depotEntry.getDepotEntryId();
    }

    @Override
    protected String getPermissionCheckerResourceName(String externalReferenceCode) throws Exception {
        return DepotEntry.class.getName();
    }

    private DepotEntry _addOrUpdateDepotEntry(AssetLibrary assetLibrary, Map<Locale, String> descriptionMap, String externalReferenceCode, Map<Locale, String> nameMap, ServiceContext serviceContext, UnicodeProperties unicodeProperties, Map<String, Long> mimeTypeSizeLimits) throws Exception {
        Company company;
        ExpandoBridge expandoBridge;
        Group group = null;
        if (Validator.isNotNull((String)externalReferenceCode)) {
            group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, serviceContext.getCompanyId());
        }
        if (group != null) {
            DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(group.getGroupId());
            if (!externalReferenceCode.equals(assetLibrary.getExternalReferenceCode())) {
                group = depotEntry.getGroup();
                group.setExternalReferenceCode(assetLibrary.getExternalReferenceCode());
                group = this._groupLocalService.updateGroup(group);
            }
            this._updateDLSizeLimitConfiguration(assetLibrary, group.getGroupId(), mimeTypeSizeLimits);
            return this._depotEntryService.updateDepotEntry(depotEntry.getDepotEntryId(), nameMap, descriptionMap, this._getDepotAppCustomizationMap(depotEntry.getCompanyId(), externalReferenceCode), UnicodePropertiesBuilder.create((Map)group.getTypeSettingsProperties(), (boolean)true).putAll((Map)unicodeProperties).build(), serviceContext);
        }
        DepotEntry depotEntry = this._depotEntryService.addDepotEntry(nameMap, descriptionMap, AssetLibraryUtil.getDepotEntryType((AssetLibrary.Type)GetterUtil.getObject((Object)assetLibrary.getType(), () -> AssetLibrary.Type.ASSET_LIBRARY)), serviceContext);
        group = depotEntry.getGroup();
        if (Validator.isNotNull((String)externalReferenceCode) || unicodeProperties != null && !unicodeProperties.isEmpty()) {
            if (Validator.isNotNull((String)externalReferenceCode)) {
                group.setExternalReferenceCode(externalReferenceCode);
            }
            if (unicodeProperties != null && !unicodeProperties.isEmpty()) {
                group.setTypeSettingsProperties(UnicodePropertiesBuilder.create((Map)group.getTypeSettingsProperties(), (boolean)true).putAll((Map)unicodeProperties).build());
            }
            group = this._groupLocalService.updateGroup(group);
        }
        this._updateDLSizeLimitConfiguration(assetLibrary, group.getGroupId(), mimeTypeSizeLimits);
        if (assetLibrary.getType() == AssetLibrary.Type.SPACE && !(expandoBridge = (company = this._companyLocalService.getCompanyById(serviceContext.getCompanyId())).getExpandoBridge()).hasAttribute("cmsFirstTimeAccess")) {
            expandoBridge.addAttribute("cmsFirstTimeAccess", 1, false);
            expandoBridge.setAttribute("cmsFirstTimeAccess", (Serializable)Boolean.FALSE);
        }
        return depotEntry;
    }

    private Boolean _getBooleanValue(Object defaultValue, Boolean value) {
        if (value == null) {
            return GetterUtil.getBoolean((Object)defaultValue);
        }
        return value;
    }

    private Map<String, Boolean> _getDepotAppCustomizationMap(long companyId, String externalReferenceCode) throws Exception {
        HashMap<String, Boolean> depotAppCustomizationMap = new HashMap<String, Boolean>();
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (group == null) {
            return depotAppCustomizationMap;
        }
        DepotEntry depotEntry = this._depotEntryService.getGroupDepotEntry(group.getGroupId());
        for (DepotAppCustomization depotAppCustomization : this._depotAppCustomizationLocalService.getDepotAppCustomizations(depotEntry.getDepotEntryId())) {
            depotAppCustomizationMap.put(depotAppCustomization.getPortletId(), depotAppCustomization.isEnabled());
        }
        return depotAppCustomizationMap;
    }

    private DepotEntry _getGroupDepotEntry(Long assetLibraryId) throws Exception {
        DepotEntry depotEntry = this._depotEntryService.fetchGroupDepotEntry(assetLibraryId.longValue());
        if (depotEntry != null) {
            return depotEntry;
        }
        return this._depotEntryService.getDepotEntry(assetLibraryId.longValue());
    }

    private long _getGroupIdByExternalReferenceCode(String externalReferenceCode) throws Exception {
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return group.getGroupId();
    }

    private Map<Locale, String> _getLocalizedMap(String defaultValue, Map<String, String> i18nMap) {
        Map localizedMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)defaultValue, i18nMap);
        if (!localizedMap.containsKey(LocaleUtil.getDefault())) {
            localizedMap = LocalizedMapUtil.patchLocalizedMap((Map)localizedMap, (Locale)LocaleUtil.getDefault(), (String)defaultValue, i18nMap);
        }
        return localizedMap;
    }

    private ServiceContext _getServiceContext() throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DepotEntry.class.getName(), (HttpServletRequest)this.contextHttpServletRequest);
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setModifiedDate(new Date());
        return serviceContext;
    }

    private UnicodeProperties _getUnicodeProperties(long companyId, String externalReferenceCode) {
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (group != null) {
            return group.getTypeSettingsProperties();
        }
        return new UnicodeProperties(true);
    }

    private <T, E extends Exception> T _getValue(UnsafeSupplier<T, E> defaultValueUnsafeSupplier, UnsafeSupplier<T, E> valueUnsafeSupplier) throws Exception {
        Object value = valueUnsafeSupplier.get();
        if (value == null) {
            return (T)defaultValueUnsafeSupplier.get();
        }
        return (T)value;
    }

    private UnicodeProperties _patchUnicodeProperties(Settings settings, UnicodeProperties unicodeProperties) {
        return UnicodePropertiesBuilder.create((boolean)true).put("autoTaggingEnabled", this._getBooleanValue(unicodeProperties.getProperty("autoTaggingEnabled"), settings.getAutoTaggingEnabled()).booleanValue()).put("inheritLocales", () -> {
            Boolean inheritLocales = this._getBooleanValue(unicodeProperties.getProperty("inheritLocales"), settings.getUseCustomLanguages());
            if (settings.getUseCustomLanguages() == null) {
                return inheritLocales.toString();
            }
            return String.valueOf(inheritLocales == false);
        }).put("languageId", GetterUtil.getString((String)settings.getDefaultLanguageId(), (String)unicodeProperties.getProperty("languageId"))).put("locales", GetterUtil.getString((String)StringUtil.merge((Object[])settings.getAvailableLanguageIds()), (String)unicodeProperties.getProperty("locales"))).put("logoColor", GetterUtil.getString((String)settings.getLogoColor(), (String)unicodeProperties.getProperty("logoColor"))).put("sharingEnabled", this._getBooleanValue(unicodeProperties.getProperty("sharingEnabled"), settings.getSharingEnabled()).booleanValue()).put("trashEnabled", this._getBooleanValue(unicodeProperties.getProperty("trashEnabled"), settings.getTrashEnabled()).booleanValue()).put("trashEntriesMaxAge", GetterUtil.getInteger((Object)settings.getTrashEntriesMaxAge(), (int)GetterUtil.getInteger((String)unicodeProperties.getProperty("trashEntriesMaxAge")))).build();
    }

    private UnicodeProperties _putUnicodeProperties(Settings settings) {
        if (settings == null) {
            return null;
        }
        return UnicodePropertiesBuilder.create((boolean)true).put("autoTaggingEnabled", GetterUtil.getBoolean((Object)settings.getAutoTaggingEnabled())).put("inheritLocales", !GetterUtil.getBoolean((Object)settings.getUseCustomLanguages())).put("languageId", settings.getDefaultLanguageId()).put("locales", StringUtil.merge((Object[])settings.getAvailableLanguageIds())).put("logoColor", GetterUtil.getString((String)settings.getLogoColor(), (String)"outline-0")).put("sharingEnabled", GetterUtil.getBoolean((Object)settings.getSharingEnabled(), (boolean)true)).put("trashEnabled", GetterUtil.getBoolean((Object)settings.getTrashEnabled(), (boolean)true)).put("trashEntriesMaxAge", GetterUtil.getInteger((Object)settings.getTrashEntriesMaxAge())).build();
    }

    private AssetLibrary _toAssetLibrary(DepotEntry depotEntry) throws Exception {
        return (AssetLibrary)this._assetLibraryDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), (Map)HashMapBuilder.put((Object)"assign-members", () -> {
            if (!this._groupModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), depotEntry.getGroupId(), "ASSIGN_MEMBERS")) {
                return null;
            }
            return this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary");
        }).put((Object)"connect-sites", () -> {
            if (!this._depotEntryModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), depotEntry.getDepotEntryId(), "UPDATE")) {
                return null;
            }
            return this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary");
        }).put((Object)"create", this.addAction("ADD_DEPOT_ENTRY", (GroupedModel)depotEntry, "postAssetLibrary")).put((Object)"delete", this.addAction("DELETE", (GroupedModel)depotEntry, "deleteAssetLibrary")).put((Object)"get", this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary")).put((Object)"permissions", this.addAction("PERMISSIONS", (GroupedModel)depotEntry, "patchAssetLibrary")).put((Object)"pin", this.addAction("UPDATE", (GroupedModel)depotEntry, "putAssetLibraryPin")).put((Object)"unpin", this.addAction("UPDATE", (GroupedModel)depotEntry, "deleteAssetLibraryPin")).put((Object)"update", this.addAction("UPDATE", (GroupedModel)depotEntry, "patchAssetLibrary")).put((Object)"view-connected-sites", () -> {
            if (this._depotEntryModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), depotEntry.getDepotEntryId(), "UPDATE")) {
                return null;
            }
            return this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary");
        }).put((Object)"view-members", () -> {
            if (this._groupModelResourcePermission.contains(PermissionThreadLocal.getPermissionChecker(), depotEntry.getGroupId(), "ASSIGN_MEMBERS")) {
                return null;
            }
            return this.addAction("VIEW", (GroupedModel)depotEntry, "getAssetLibrary");
        }).build(), this._dtoConverterRegistry, (Object)depotEntry.getDepotEntryId(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser));
    }

    private void _updateDLSizeLimitConfiguration(AssetLibrary assetLibrary, long groupId, Map<String, Long> mimeTypeSizeLimits) throws Exception {
        Settings settings = assetLibrary.getSettings();
        MimeTypeLimit[] mimeTypeLimits = settings.getMimeTypeLimits();
        if (mimeTypeLimits == null) {
            this._dlSizeLimitConfigurationProvider.updateGroupSizeLimit(groupId, 0L, 0L, mimeTypeSizeLimits);
            return;
        }
        mimeTypeSizeLimits = new LinkedHashMap<String, Long>();
        for (MimeTypeLimit mimeTypeLimit : mimeTypeLimits) {
            String mimeType = mimeTypeLimit.getMimeType();
            if (!Validator.isNotNull((String)mimeType)) continue;
            mimeTypeSizeLimits.put(mimeType, GetterUtil.getLong((Object)mimeTypeLimit.getMaximumSize()));
        }
        this._dlSizeLimitConfigurationProvider.updateGroupSizeLimit(groupId, 0L, 0L, mimeTypeSizeLimits);
    }
}

