/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.dto.v1_0.converter;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.document.library.configuration.DLSizeLimitConfigurationProvider;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.dto.v1_0.ConnectedSite;
import com.liferay.headless.asset.library.dto.v1_0.MimeTypeLimit;
import com.liferay.headless.asset.library.dto.v1_0.Settings;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.headless.asset.library.internal.util.AssetLibraryUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.ws.rs.core.UriInfo;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.depot.model.DepotEntry"}, service={DTOConverter.class})
public class AssetLibraryDTOConverter
implements DTOConverter<DepotEntry, AssetLibrary> {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private DLSizeLimitConfigurationProvider _dlSizeLimitConfigurationProvider;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return AssetLibrary.class.getSimpleName();
    }

    public String getJaxRsLink(long classPK, UriInfo uriInfo) {
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-asset-library", BaseAssetLibraryResourceImpl.class, (String)"getAssetLibrary", (UriInfo)uriInfo, (Object[])new Object[]{classPK});
    }

    public AssetLibrary toDTO(DTOConverterContext dtoConverterContext) throws Exception {
        return this.toDTO(dtoConverterContext, this._depotEntryLocalService.getDepotEntry(((Long)dtoConverterContext.getId()).longValue()));
    }

    public AssetLibrary toDTO(final DTOConverterContext dtoConverterContext, final DepotEntry depotEntry) throws Exception {
        final Group group = depotEntry.getGroup();
        return new AssetLibrary(){
            {
                this.setActions(() -> ((DTOConverterContext)dtoConverterContext).getActions());
                this.setAssetLibraryKey(() -> ((Group)group).getGroupKey());
                this.setConnectedSites(() -> (ConnectedSite[])NestedFieldsSupplier.supply((String)"connectedSites", nestedField -> (ConnectedSite[])TransformUtil.transformToArray((Collection)AssetLibraryDTOConverter.this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry), depotEntryGroupRel -> AssetLibraryDTOConverter.this._toConnectedSite((DepotEntryGroupRel)depotEntryGroupRel, dtoConverterContext), ConnectedSite.class)));
                this.setCreatorUserId(() -> ((Group)group).getCreatorUserId());
                this.setDateCreated(() -> ((DepotEntry)depotEntry).getCreateDate());
                this.setDateModified(() -> (Date)GetterUtil.getObject((Object)depotEntry.getModifiedDate(), () -> ((DepotEntry)depotEntry).getCreateDate()));
                this.setDescription(() -> group.getDescription(dtoConverterContext.getLocale()));
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getDescriptionMap()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setId(() -> ((DepotEntry)depotEntry).getDepotEntryId());
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap()));
                this.setNumberOfConnectedSites(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfConnectedSites", nestedField -> AssetLibraryDTOConverter.this._depotEntryGroupRelLocalService.getDepotEntryGroupRelsCount(depotEntry)));
                this.setNumberOfUserAccounts(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfUserAccounts", nestedField -> AssetLibraryDTOConverter.this._userLocalService.getGroupUsersCount(group.getGroupId())));
                this.setNumberOfUserGroups(() -> (Integer)NestedFieldsSupplier.supply((String)"numberOfUserGroups", nestedField -> AssetLibraryDTOConverter.this._userGroupLocalService.getGroupUserGroupsCount(group.getGroupId())));
                this.setSettings(() -> AssetLibraryDTOConverter.this._toSettings(group));
                this.setSiteId(() -> ((Group)group).getGroupId());
                this.setType(() -> AssetLibraryUtil.getAssetLibraryType(depotEntry.getType()));
            }
        };
    }

    private MimeTypeLimit[] _getMimeTypeLimits(long groupId) {
        Map groupMimeTypeSizeLimit = this._dlSizeLimitConfigurationProvider.getGroupMimeTypeSizeLimit(groupId);
        return (MimeTypeLimit[])TransformUtil.transformToArray(groupMimeTypeSizeLimit.entrySet(), entry -> new MimeTypeLimit((Map.Entry)entry){
            final /* synthetic */ Map.Entry val$entry;
            {
                this.val$entry = entry;
                this.setMaximumSize(() -> GetterUtil.getInteger(this.val$entry.getValue()));
                this.setMimeType(this.val$entry::getKey);
            }
        }, MimeTypeLimit.class);
    }

    private ConnectedSite _toConnectedSite(final DepotEntryGroupRel depotEntryGroupRel, final DTOConverterContext dtoConverterContext) throws Exception {
        final Group group = this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId());
        return new ConnectedSite(){
            {
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setId(() -> ((Group)group).getGroupId());
                this.setLogo(() -> {
                    ThemeDisplay themeDisplay = new ThemeDisplay(){
                        {
                            this.setCompany(AssetLibraryDTOConverter.this._companyLocalService.getCompany(group.getCompanyId()));
                            this.setPathImage(AssetLibraryDTOConverter.this._portal.getPathImage());
                        }
                    };
                    return group.getLogoURL(themeDisplay, true);
                });
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap()));
                this.setSearchable(() -> ((DepotEntryGroupRel)depotEntryGroupRel).isSearchable());
            }
        };
    }

    private Settings _toSettings(final Group group) {
        final UnicodeProperties unicodeProperties = group.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setAutoTaggingEnabled(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"autoTaggingEnabled"))));
                this.setAvailableLanguageIds(() -> GetterUtil.getStringValues((String[])StringUtil.split((String)((String)unicodeProperties.get((Object)"locales")))));
                this.setDefaultLanguageId(() -> GetterUtil.getString((String)((String)unicodeProperties.get((Object)"languageId"))));
                this.setLogoColor(() -> GetterUtil.get((String)((String)unicodeProperties.get((Object)"logoColor")), (String)"outline-0"));
                this.setMimeTypeLimits(() -> AssetLibraryDTOConverter.this._getMimeTypeLimits(group.getGroupId()));
                this.setSharingEnabled(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"sharingEnabled")), (boolean)true));
                this.setTrashEnabled(() -> GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"trashEnabled")), (boolean)true));
                this.setTrashEntriesMaxAge(() -> GetterUtil.getInteger((String)unicodeProperties.getProperty("trashEntriesMaxAge")));
                this.setUseCustomLanguages(() -> !GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"inheritLocales"))));
            }
        };
    }
}

