/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.resource.v1_0;

import com.liferay.headless.asset.library.dto.v1_0.Role;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseRoleResourceImpl;
import com.liferay.headless.asset.library.resource.v1_0.RoleResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.NoSuchUserGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupGroupRoleModel;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.RoleService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserGroupGroupRoleService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleService;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/role.properties"}, scope=ServiceScope.PROTOTYPE, service={RoleResource.class})
public class RoleResourceImpl
extends BaseRoleResourceImpl {
    @Reference
    private GroupService _groupService;
    @Reference
    private RoleService _roleService;
    @Reference
    private UserGroupGroupRoleLocalService _userGroupGroupRoleLocalService;
    @Reference
    private UserGroupGroupRoleService _userGroupGroupRoleService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserGroupRoleService _userGroupRoleService;
    @Reference
    private UserGroupService _userGroupService;
    @Reference
    private UserService _userService;

    @Override
    public Page<Role> getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserAccountByExternalReferenceCodeUserAccountExternalReferenceCodeRolesPage(String assetLibraryExternalReferenceCode, String userAccountExternalReferenceCode) throws Exception {
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibraryUserAccountRolesPage(group.getGroupId(), user.getUserId());
    }

    @Override
    public Page<Role> getAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserGroupByExternalReferenceCodeUserGroupExternalReferenceCodeRolesPage(String assetLibraryExternalReferenceCode, String userGroupExternalReferenceCode) throws Exception {
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        UserGroup userGroup = this._userGroupService.getUserGroupByExternalReferenceCode(userGroupExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.getAssetLibraryUserGroupRolesPage(group.getGroupId(), userGroup.getUserGroupId());
    }

    @Override
    public Page<Role> getAssetLibraryUserAccountRolesPage(Long assetLibraryId, Long userAccountId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (!this._groupService.hasUserGroup(userAccountId.longValue(), assetLibraryId.longValue())) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"User ", userAccountId, " is not associated to group ", assetLibraryId}));
        }
        return Page.of(this.transform(this._roleService.getUserGroupRoles(userAccountId.longValue(), assetLibraryId.longValue()), this::_toRole));
    }

    @Override
    public Page<Role> getAssetLibraryUserGroupRolesPage(Long assetLibraryId, Long userGroupId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (!this._userGroupLocalService.hasGroupUserGroup(assetLibraryId.longValue(), userGroupId.longValue())) {
            throw new NoSuchUserGroupException("No user group exists with user group ID " + userGroupId);
        }
        return Page.of(this.transform(this._userGroupGroupRoleLocalService.getUserGroupGroupRoles(userGroupId.longValue(), assetLibraryId.longValue()), userGroupGroupRole -> this._toRole(userGroupGroupRole.getRole())));
    }

    @Override
    public Page<Role> putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserAccountByExternalReferenceCodeUserAccountExternalReferenceCodeRolesPage(String assetLibraryExternalReferenceCode, String userAccountExternalReferenceCode, Role[] roles) throws Exception {
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        User user = this._userService.getUserByExternalReferenceCode(userAccountExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibraryUserAccountRolesPage(group.getGroupId(), user.getUserId(), roles);
    }

    @Override
    public Page<Role> putAssetLibraryByExternalReferenceCodeAssetLibraryExternalReferenceCodeUserGroupByExternalReferenceCodeUserGroupExternalReferenceCodeRolesPage(String assetLibraryExternalReferenceCode, String userGroupExternalReferenceCode, Role[] roles) throws Exception {
        Group group = this._getGroup(assetLibraryExternalReferenceCode);
        UserGroup userGroup = this._userGroupService.getUserGroupByExternalReferenceCode(userGroupExternalReferenceCode, this.contextCompany.getCompanyId());
        return this.putAssetLibraryUserGroupRolesPage(group.getGroupId(), userGroup.getUserGroupId(), roles);
    }

    @Override
    public Page<Role> putAssetLibraryUserAccountRolesPage(Long assetLibraryId, Long userAccountId, Role[] roles) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (!this._groupService.hasUserGroup(userAccountId.longValue(), assetLibraryId.longValue())) {
            throw new NoSuchUserException(StringBundler.concat((Object[])new Object[]{"User ", userAccountId, " is not associated to group ", assetLibraryId}));
        }
        this._userGroupRoleService.deleteUserGroupRoles(userAccountId.longValue(), assetLibraryId.longValue(), ListUtil.toLongArray((List)this._roleService.getUserGroupRoles(userAccountId.longValue(), assetLibraryId.longValue()), (Accessor)com.liferay.portal.kernel.model.Role.ROLE_ID_ACCESSOR));
        this._userGroupRoleService.addUserGroupRoles(userAccountId.longValue(), assetLibraryId.longValue(), this._getRoleIds(roles));
        return Page.of(this.transform(this._roleService.getUserGroupRoles(userAccountId.longValue(), assetLibraryId.longValue()), this::_toRole));
    }

    @Override
    public Page<Role> putAssetLibraryUserGroupRolesPage(Long assetLibraryId, Long userGroupId, Role[] roles) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            throw new UnsupportedOperationException();
        }
        if (!this._userGroupLocalService.hasGroupUserGroup(assetLibraryId.longValue(), userGroupId.longValue())) {
            throw new NoSuchUserGroupException("No user group exists with user group ID " + userGroupId);
        }
        this._userGroupGroupRoleService.deleteUserGroupGroupRoles(userGroupId.longValue(), assetLibraryId.longValue(), ListUtil.toLongArray((List)this._userGroupGroupRoleLocalService.getUserGroupGroupRoles(userGroupId.longValue(), assetLibraryId.longValue()), UserGroupGroupRoleModel::getRoleId));
        this._userGroupGroupRoleService.addUserGroupGroupRoles(userGroupId.longValue(), assetLibraryId.longValue(), this._getRoleIds(roles));
        return Page.of(this.transform(this._userGroupGroupRoleLocalService.getUserGroupGroupRoles(userGroupId.longValue(), assetLibraryId.longValue()), userGroupGroupRole -> this._toRole(userGroupGroupRole.getRole())));
    }

    private Group _getGroup(String externalReferenceCode) throws Exception {
        Group group = this._groupService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No group exists with external reference code " + externalReferenceCode);
        }
        return group;
    }

    private long[] _getRoleIds(Role[] roles) throws Exception {
        return RoleResourceImpl.transformToLongArray(roles, role -> {
            com.liferay.portal.kernel.model.Role serviceBuilderRole = this._roleService.getRole(this.contextCompany.getCompanyId(), role.getName());
            return serviceBuilderRole.getRoleId();
        });
    }

    private Role _toRole(final com.liferay.portal.kernel.model.Role role) throws PortalException {
        return new Role(){
            {
                this.setExternalReferenceCode(() -> ((com.liferay.portal.kernel.model.Role)role).getExternalReferenceCode());
                this.setId(() -> ((com.liferay.portal.kernel.model.Role)role).getRoleId());
                this.setName(() -> ((com.liferay.portal.kernel.model.Role)role).getName());
                this.setRoleType(() -> ((com.liferay.portal.kernel.model.Role)role).getType());
            }
        };
    }
}

