/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.internal.dto.v1_0.converter;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.headless.asset.library.dto.v1_0.AssetLibrary;
import com.liferay.headless.asset.library.internal.resource.v1_0.BaseAssetLibraryResourceImpl;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.GroupUtil;
import com.liferay.portal.vulcan.util.JaxRsLinkUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.depot.model.DepotEntry"}, service={DTOConverter.class})
public class AssetLibraryDTOConverter
implements DTOConverter<DepotEntry, AssetLibrary> {
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public String getContentType() {
        return AssetLibrary.class.getSimpleName();
    }

    public String getJaxRsLink(long classPK, UriInfo uriInfo) {
        return JaxRsLinkUtil.getJaxRsLink((String)"headless-delivery", BaseAssetLibraryResourceImpl.class, (String)"getAssetLibrary", (UriInfo)uriInfo, (Object[])new Object[]{classPK});
    }

    public AssetLibrary toDTO(final DTOConverterContext dtoConverterContext) throws Exception {
        final DepotEntry depotEntry = this._depotEntryLocalService.getGroupDepotEntry(((Long)dtoConverterContext.getId()).longValue());
        final Group group = depotEntry.getGroup();
        return new AssetLibrary(){
            {
                this.setAssetLibraryKey(() -> GroupUtil.getAssetLibraryKey((Group)group));
                this.setDateCreated(() -> ((DepotEntry)depotEntry).getCreateDate());
                this.setDateModified(() -> ((DepotEntry)depotEntry).getModifiedDate());
                this.setDescription(() -> group.getDescription(dtoConverterContext.getLocale()));
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getDescriptionMap()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setId(() -> ((DepotEntry)depotEntry).getDepotEntryId());
                this.setLinkedSiteIds(() -> {
                    List depotEntryGroupRels = AssetLibraryDTOConverter.this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
                    ArrayList<Long> toGroupIds = new ArrayList<Long>(depotEntryGroupRels.size());
                    for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                        toGroupIds.add(depotEntryGroupRel.getToGroupId());
                    }
                    return toGroupIds.toArray(new Long[0]);
                });
                this.setLinkedSitesExternalReferenceCodes(() -> {
                    List depotEntryGroupRels = AssetLibraryDTOConverter.this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(depotEntry);
                    ArrayList<String> toGroupExternalReferenceCodes = new ArrayList<String>(depotEntryGroupRels.size());
                    for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
                        Group toGroup = AssetLibraryDTOConverter.this._groupLocalService.getGroup(depotEntryGroupRel.getToGroupId());
                        toGroupExternalReferenceCodes.add(toGroup.getExternalReferenceCode());
                    }
                    return toGroupExternalReferenceCodes.toArray(new String[0]);
                });
                this.setName(() -> group.getName(dtoConverterContext.getLocale()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)group.getNameMap()));
                this.setSiteId(() -> ((Group)group).getGroupId());
            }
        };
    }
}

