/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.asset.library.dto.v1_0;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLField;
import com.liferay.portal.vulcan.graphql.annotation.GraphQLName;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

@GraphQLName(description="Represents a site.", value="Site")
@JsonFilter(value="Liferay.Vulcan")
@XmlRootElement(name="Site")
public class Site
implements Serializable {
    @GraphQLField(description="The site's external reference code.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The site's external reference code.") String externalReferenceCode;
    @JsonIgnore
    private Supplier<String> _externalReferenceCodeSupplier;
    @GraphQLField(description="The site's ID.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The site's ID.") Long id;
    @JsonIgnore
    private Supplier<Long> _idSupplier;
    @GraphQLField(description="The site's logo.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The site's logo.") String logo;
    @JsonIgnore
    private Supplier<String> _logoSupplier;
    @GraphQLField(description="The site's name.")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected @GraphQLField(description="The site's name.") String name;
    @JsonIgnore
    private Supplier<String> _nameSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Map<String, String> name_i18n;
    @JsonIgnore
    private Supplier<Map<String, String>> _name_i18nSupplier;
    @GraphQLField
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    protected Boolean searchable;
    @JsonIgnore
    private Supplier<Boolean> _searchableSupplier;
    @Schema(accessMode=Schema.AccessMode.READ_ONLY, defaultValue="com.liferay.headless.asset.library.dto.v1_0.Site", name="x-class-name")
    public String xClassName;
    private static final String[][] _JSON_ESCAPE_STRINGS = new String[][]{{"\\", "\"", "\b", "\f", "\n", "\r", "\t"}, {"\\\\", "\\\"", "\\b", "\\f", "\\n", "\\r", "\\t"}};
    private Map<String, Serializable> _extendedProperties;

    public static Site toDTO(String json) {
        return (Site)ObjectMapperUtil.readValue(Site.class, (String)json);
    }

    public static Site unsafeToDTO(String json) {
        return (Site)ObjectMapperUtil.unsafeReadValue(Site.class, (String)json);
    }

    @Schema(description="The site's external reference code.")
    public String getExternalReferenceCode() {
        if (this._externalReferenceCodeSupplier != null) {
            this.externalReferenceCode = this._externalReferenceCodeSupplier.get();
            this._externalReferenceCodeSupplier = null;
        }
        return this.externalReferenceCode;
    }

    public void setExternalReferenceCode(String externalReferenceCode) {
        this.externalReferenceCode = externalReferenceCode;
        this._externalReferenceCodeSupplier = null;
    }

    @JsonIgnore
    public void setExternalReferenceCode(UnsafeSupplier<String, Exception> externalReferenceCodeUnsafeSupplier) {
        this._externalReferenceCodeSupplier = () -> {
            try {
                return (String)externalReferenceCodeUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The site's ID.")
    public Long getId() {
        if (this._idSupplier != null) {
            this.id = this._idSupplier.get();
            this._idSupplier = null;
        }
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this._idSupplier = null;
    }

    @JsonIgnore
    public void setId(UnsafeSupplier<Long, Exception> idUnsafeSupplier) {
        this._idSupplier = () -> {
            try {
                return (Long)idUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The site's logo.")
    public String getLogo() {
        if (this._logoSupplier != null) {
            this.logo = this._logoSupplier.get();
            this._logoSupplier = null;
        }
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
        this._logoSupplier = null;
    }

    @JsonIgnore
    public void setLogo(UnsafeSupplier<String, Exception> logoUnsafeSupplier) {
        this._logoSupplier = () -> {
            try {
                return (String)logoUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema(description="The site's name.")
    public String getName() {
        if (this._nameSupplier != null) {
            this.name = this._nameSupplier.get();
            this._nameSupplier = null;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this._nameSupplier = null;
    }

    @JsonIgnore
    public void setName(UnsafeSupplier<String, Exception> nameUnsafeSupplier) {
        this._nameSupplier = () -> {
            try {
                return (String)nameUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    @Valid
    public Map<String, String> getName_i18n() {
        if (this._name_i18nSupplier != null) {
            this.name_i18n = this._name_i18nSupplier.get();
            this._name_i18nSupplier = null;
        }
        return this.name_i18n;
    }

    public void setName_i18n(Map<String, String> name_i18n) {
        this.name_i18n = name_i18n;
        this._name_i18nSupplier = null;
    }

    @JsonIgnore
    public void setName_i18n(UnsafeSupplier<Map<String, String>, Exception> name_i18nUnsafeSupplier) {
        this._name_i18nSupplier = () -> {
            try {
                return (Map)name_i18nUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @Schema
    public Boolean getSearchable() {
        if (this._searchableSupplier != null) {
            this.searchable = this._searchableSupplier.get();
            this._searchableSupplier = null;
        }
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
        this._searchableSupplier = null;
    }

    @JsonIgnore
    public void setSearchable(UnsafeSupplier<Boolean, Exception> searchableUnsafeSupplier) {
        this._searchableSupplier = () -> {
            try {
                return (Boolean)searchableUnsafeSupplier.get();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Site)) {
            return false;
        }
        Site site = (Site)object;
        return Objects.equals(this.toString(), site.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        Boolean searchable;
        Map<String, String> name_i18n;
        String name;
        String logo;
        Long id;
        StringBundler sb = new StringBundler();
        sb.append("{");
        String externalReferenceCode = this.getExternalReferenceCode();
        if (externalReferenceCode != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"externalReferenceCode\": ");
            sb.append("\"");
            sb.append(Site._escape(externalReferenceCode));
            sb.append("\"");
        }
        if ((id = this.getId()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"id\": ");
            sb.append((Object)id);
        }
        if ((logo = this.getLogo()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"logo\": ");
            sb.append("\"");
            sb.append(Site._escape(logo));
            sb.append("\"");
        }
        if ((name = this.getName()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name\": ");
            sb.append("\"");
            sb.append(Site._escape(name));
            sb.append("\"");
        }
        if ((name_i18n = this.getName_i18n()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"name_i18n\": ");
            sb.append(Site._toJSON(name_i18n));
        }
        if ((searchable = this.getSearchable()) != null) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append("\"searchable\": ");
            sb.append((Object)searchable);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String _escape(Object object) {
        return StringUtil.replace((String)String.valueOf(object), (String[])_JSON_ESCAPE_STRINGS[0], (String[])_JSON_ESCAPE_STRINGS[1]);
    }

    private static boolean _isArray(Object value) {
        if (value == null) {
            return false;
        }
        Class<?> clazz = value.getClass();
        return clazz.isArray();
    }

    private static String _toJSON(Map<String, ?> map) {
        StringBuilder sb = new StringBuilder("{");
        Set<Map.Entry<String, ?>> set = map.entrySet();
        Iterator<Map.Entry<String, ?>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ?> entry = iterator.next();
            sb.append("\"");
            sb.append(Site._escape(entry.getKey()));
            sb.append("\": ");
            Object value = entry.getValue();
            if (Site._isArray(value)) {
                sb.append("[");
                Object[] valueArray = (Object[])value;
                for (int i = 0; i < valueArray.length; ++i) {
                    if (valueArray[i] instanceof Map) {
                        sb.append(Site._toJSON((Map)valueArray[i]));
                    } else if (valueArray[i] instanceof String) {
                        sb.append("\"");
                        sb.append(valueArray[i]);
                        sb.append("\"");
                    } else {
                        sb.append(valueArray[i]);
                    }
                    if (i + 1 >= valueArray.length) continue;
                    sb.append(", ");
                }
                sb.append("]");
            } else if (value instanceof Map) {
                sb.append(Site._toJSON((Map)value));
            } else if (value instanceof String) {
                sb.append("\"");
                sb.append(Site._escape(value));
                sb.append("\"");
            } else {
                sb.append(value);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

