/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class MasterPageDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, MasterPage> {
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getContentType() {
        return MasterPage.class.getSimpleName();
    }

    public MasterPage toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new MasterPage(){
            {
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setKeywordItemExternalReferences(() -> MasterPageDTOConverter.this._getKeywordItemExternalReferences(Layout.class.getName(), layoutPageTemplateEntry.getPlid(), layoutPageTemplateEntry.getGroupId()));
                this.setMarkedAsDefault(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).isDefaultTemplate());
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setThumbnail(() -> {
                    if (layoutPageTemplateEntry.getPreviewFileEntryId() <= 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = MasterPageDTOConverter.this._portletFileRepository.getPortletFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId());
                    if (fileEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(() -> FileEntry.class.getName());
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }

    private ItemExternalReference[] _getKeywordItemExternalReferences(String className, long classPK, long groupId) {
        List assetTags = this._assetTagLocalService.getTags(className, classPK);
        if (ListUtil.isEmpty((List)assetTags)) {
            return new ItemExternalReference[0];
        }
        return (ItemExternalReference[])TransformUtil.unsafeTransformToArray((Collection)assetTags, assetTag -> {
            ItemExternalReference itemExternalReference = new ItemExternalReference();
            itemExternalReference.setExternalReferenceCode(() -> ((AssetTag)assetTag).getExternalReferenceCode());
            itemExternalReference.setScope(() -> this._getScope(groupId, assetTag.getGroupId()));
            return itemExternalReference;
        }, ItemExternalReference.class);
    }

    private Scope _getScope(long groupId, long scopeGroupId) throws Exception {
        if (groupId == scopeGroupId) {
            return null;
        }
        final Group group = this._groupLocalService.getGroup(scopeGroupId);
        return new Scope(){
            {
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setType(() -> {
                    if (group.getType() == 5) {
                        return Scope.Type.ASSET_LIBRARY;
                    }
                    return Scope.Type.SITE;
                });
            }
        };
    }
}

