/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class MasterPageDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, MasterPage> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public String getContentType() {
        return MasterPage.class.getSimpleName();
    }

    public MasterPage toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new MasterPage(){
            {
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setMarkedAsDefault(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).isDefaultTemplate());
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setThumbnail(() -> {
                    if (layoutPageTemplateEntry.getPreviewFileEntryId() <= 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = MasterPageDTOConverter.this._portletFileRepository.getPortletFileEntry(layoutPageTemplateEntry.getPreviewFileEntryId());
                    if (fileEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(() -> FileEntry.class.getName());
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }
}

