/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplateSet;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageTemplate;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageTemplateResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.PageTemplateResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-template.properties"}, scope=ServiceScope.PROTOTYPE, service={PageTemplateResource.class})
public class PageTemplateResourceImpl
extends BasePageTemplateResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionService _layoutPageTemplateCollectionService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private LayoutPrototypeService _layoutPrototypeService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageTemplateDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, PageTemplate> _pageTemplateDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodePageTemplate(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public PageTemplate getSiteSiteByExternalReferenceCodePageTemplate(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(0, layoutPageTemplateEntry.getType()) && !Objects.equals(2, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (PageTemplate)this._pageTemplateDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    public Page<PageTemplate> getSiteSiteByExternalReferenceCodePageTemplateSetPageTemplatesPage(String siteExternalReferenceCode, String pageTemplateSetExternalReferenceCode, Boolean flatten) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(pageTemplateSetExternalReferenceCode, groupId);
        if (!Objects.equals(0, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), -1, -1, null), layoutPageTemplateEntry -> (PageTemplate)this._pageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)));
    }

    @Override
    public Page<PageTemplate> getSiteSiteByExternalReferenceCodePageTemplatesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), new int[]{0, 2}, -1, -1, null), layoutPageTemplateEntry -> (PageTemplate)this._pageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)));
    }

    @Override
    public PageTemplate postSiteSiteByExternalReferenceCodePageTemplate(String siteExternalReferenceCode, PageTemplate pageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addPageTemplate(GroupUtil.getGroupId(this._isTypeWidgetPageTemplate(pageTemplate), false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageTemplate);
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodePageTemplatePageSpecification(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(0, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToPublishedLayout(contentPageSpecification, this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutPageTemplateEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public PageTemplate postSiteSiteByExternalReferenceCodePageTemplateSetPageTemplate(String siteExternalReferenceCode, String pageTemplateSetExternalReferenceCode, PageTemplate pageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(pageTemplateSetExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(0, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return this._addPageTemplate(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), pageTemplate);
    }

    @Override
    public PageTemplate putSiteSiteByExternalReferenceCodePageTemplate(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, PageTemplate pageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(this._isTypeWidgetPageTemplate(pageTemplate), false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addPageTemplate(groupId, pageTemplate);
        }
        if (Objects.equals(layoutPageTemplateEntry.getType(), 0) && !(pageTemplate instanceof ContentPageTemplate) || Objects.equals(layoutPageTemplateEntry.getType(), 2) && !(pageTemplate instanceof WidgetPageTemplate)) {
            throw new UnsupportedOperationException();
        }
        long layoutPageTemplateCollectionId = this._getLayoutPageTemplateCollectionId(groupId, pageTemplate);
        if (Validator.isNotNull((Object)pageTemplate.getPageTemplateSet()) && !Objects.equals(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), layoutPageTemplateCollectionId)) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.moveLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), layoutPageTemplateCollectionId);
        }
        if (Objects.equals(layoutPageTemplateEntry.getType(), 0)) {
            return this._updatePageTemplate((ContentPageTemplate)pageTemplate, layoutPageTemplateEntry);
        }
        return this._updatePageTemplate(layoutPageTemplateEntry, (WidgetPageTemplate)pageTemplate);
    }

    @Override
    protected void preparePatch(PageTemplate pageTemplate, PageTemplate existingPageTemplate) {
        if (pageTemplate.getPageTemplateSet() != null) {
            existingPageTemplate.setPageTemplateSet(() -> ((PageTemplate)pageTemplate).getPageTemplateSet());
        }
        if (Objects.equals(existingPageTemplate.getType(), PageTemplate.Type.CONTENT_PAGE_TEMPLATE)) {
            return;
        }
        if (!(existingPageTemplate instanceof WidgetPageTemplate) || !(pageTemplate instanceof WidgetPageTemplate)) {
            throw new UnsupportedOperationException();
        }
        this._preparePatch((WidgetPageTemplate)existingPageTemplate, (WidgetPageTemplate)pageTemplate);
    }

    private PageTemplate _addPageTemplate(ContentPageTemplate contentPageTemplate, long groupId, long layoutPageTemplateCollectionId) throws Exception {
        return (PageTemplate)this._pageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(contentPageTemplate.getExternalReferenceCode(), groupId, layoutPageTemplateCollectionId, contentPageTemplate.getName(), 0, 0L, 2, this._getServiceContext(groupId, (PageTemplate)contentPageTemplate)));
    }

    private PageTemplate _addPageTemplate(long groupId, long layoutPageTemplateCollectionId, PageTemplate pageTemplate) throws Exception {
        if (Objects.equals(pageTemplate.getType(), PageTemplate.Type.CONTENT_PAGE_TEMPLATE)) {
            return this._addPageTemplate((ContentPageTemplate)pageTemplate, groupId, layoutPageTemplateCollectionId);
        }
        return this._addPageTemplate(groupId, layoutPageTemplateCollectionId, (WidgetPageTemplate)pageTemplate);
    }

    private PageTemplate _addPageTemplate(long groupId, long layoutPageTemplateCollectionId, WidgetPageTemplate widgetPageTemplate) throws Exception {
        ServiceContext serviceContext = this._getServiceContext(groupId, (PageTemplate)widgetPageTemplate);
        Map nameMap = HashMapBuilder.put((Object)serviceContext.getLocale(), (Object)widgetPageTemplate.getName()).build();
        if (widgetPageTemplate.getName_i18n() != null) {
            nameMap = LocalizedMapUtil.getLocalizedMap((Map)widgetPageTemplate.getName_i18n());
        }
        Map descriptionMap = Collections.emptyMap();
        if (widgetPageTemplate.getDescription_i18n() != null) {
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)widgetPageTemplate.getDescription_i18n());
        }
        LayoutPrototype layoutPrototype = this._layoutPrototypeService.addLayoutPrototype(nameMap, descriptionMap, GetterUtil.getBoolean((Object)widgetPageTemplate.getActive()), serviceContext);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.getFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
        if (widgetPageTemplate.getExternalReferenceCode() != null) {
            layoutPageTemplateEntry.setExternalReferenceCode(widgetPageTemplate.getExternalReferenceCode());
        }
        layoutPageTemplateEntry.setGroupId(groupId);
        layoutPageTemplateEntry.setLayoutPageTemplateCollectionId(layoutPageTemplateCollectionId);
        if (widgetPageTemplate.getUuid() != null) {
            layoutPageTemplateEntry.setUuid(widgetPageTemplate.getUuid());
        }
        return (PageTemplate)this._pageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry));
    }

    private PageTemplate _addPageTemplate(long groupId, PageTemplate pageTemplate) throws Exception {
        return this._addPageTemplate(groupId, this._getLayoutPageTemplateCollectionId(groupId, pageTemplate), pageTemplate);
    }

    private long _getLayoutPageTemplateCollectionId(long groupId, PageTemplate pageTemplate) throws Exception {
        PageTemplateSet pageTemplateSet = pageTemplate.getPageTemplateSet();
        if (pageTemplateSet == null) {
            return 0L;
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.fetchLayoutPageTemplateCollection(pageTemplateSet.getExternalReferenceCode(), groupId);
        if (layoutPageTemplateCollection == null) {
            return 0L;
        }
        if (!Objects.equals(0, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
    }

    private ServiceContext _getServiceContext(long groupId, PageTemplate pageTemplate) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCreateDate(pageTemplate.getDateCreated());
        serviceContext.setModifiedDate(pageTemplate.getDateModified());
        if (Objects.equals(pageTemplate.getType(), PageTemplate.Type.CONTENT_PAGE_TEMPLATE)) {
            serviceContext.setUuid(pageTemplate.getUuid());
        }
        return serviceContext;
    }

    private boolean _isTypeWidgetPageTemplate(PageTemplate pageTemplate) {
        return Objects.equals(pageTemplate.getType(), PageTemplate.Type.WIDGET_PAGE_TEMPLATE);
    }

    private void _preparePatch(WidgetPageTemplate existingWidgetPageTemplate, WidgetPageTemplate widgetPageTemplate) {
        if (widgetPageTemplate.getActive() != null) {
            existingWidgetPageTemplate.setActive(() -> ((WidgetPageTemplate)widgetPageTemplate).getActive());
        }
        if (widgetPageTemplate.getDescription_i18n() != null) {
            existingWidgetPageTemplate.setDescription_i18n(() -> ((WidgetPageTemplate)widgetPageTemplate).getDescription_i18n());
        }
        if (widgetPageTemplate.getName_i18n() != null) {
            existingWidgetPageTemplate.setName_i18n(() -> ((WidgetPageTemplate)widgetPageTemplate).getName_i18n());
        }
    }

    private PageTemplate _updatePageTemplate(ContentPageTemplate contentPageTemplate, LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        return (PageTemplate)this._pageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), contentPageTemplate.getName()));
    }

    private PageTemplate _updatePageTemplate(LayoutPageTemplateEntry layoutPageTemplateEntry, WidgetPageTemplate widgetPageTemplate) throws Exception {
        LayoutPrototype layoutPrototype = this._layoutPrototypeService.getLayoutPrototype(layoutPageTemplateEntry.getLayoutPrototypeId());
        Map nameMap = layoutPrototype.getNameMap();
        if (widgetPageTemplate.getName_i18n() != null) {
            nameMap = LocalizedMapUtil.getLocalizedMap((Map)widgetPageTemplate.getName_i18n());
        }
        Map descriptionMap = layoutPrototype.getDescriptionMap();
        if (widgetPageTemplate.getDescription_i18n() != null) {
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)widgetPageTemplate.getDescription_i18n());
        }
        boolean active = layoutPrototype.isActive();
        if (widgetPageTemplate.getActive() != null) {
            active = widgetPageTemplate.getActive();
        }
        this._layoutPrototypeService.updateLayoutPrototype(layoutPrototype.getLayoutPrototypeId(), nameMap, descriptionMap, active, this._getServiceContext(layoutPageTemplateEntry.getGroupId(), (PageTemplate)widgetPageTemplate));
        return (PageTemplate)this._pageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
    }
}

