/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.headless.admin.site.dto.v1_0.ClassNameReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.Layout"}, service={DTOConverter.class})
public class SitePageDTOConverter
implements DTOConverter<Layout, SitePage> {
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;

    public String getContentType() {
        return SitePage.class.getSimpleName();
    }

    public SitePage toDTO(DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        return new SitePage(){
            {
                this.setAvailableLanguages(() -> LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds()));
                this.setDateCreated(() -> ((Layout)layout).getCreateDate());
                this.setDateModified(() -> ((Layout)layout).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getNameMap()));
                this.setPageSettings(() -> SitePageDTOConverter.this._toPageSettings(layout));
                this.setParentSitePageExternalReferenceCode(() -> {
                    if (layout.getParentLayoutId() == 0L) {
                        return null;
                    }
                    Layout parentLayout = SitePageDTOConverter.this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
                    return parentLayout.getExternalReferenceCode();
                });
                this.setType(() -> SitePageTypeUtil.toExternalType(layout.getType()));
                this.setUuid(() -> ((Layout)layout).getUuid());
            }
        };
    }

    private CollectionReference _getCollectionReference(final Layout layout) {
        String collectionType = layout.getTypeSettingsProperty("collectionType");
        if (Objects.equals(collectionType, InfoListItemSelectorReturnType.class.getName())) {
            final AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(GetterUtil.getLong((String)layout.getTypeSettingsProperty("collectionPK")));
            if (assetListEntry == null) {
                return null;
            }
            return new ItemExternalReference(){
                {
                    this.setClassName(() -> AssetListEntry.class.getName());
                    this.setCollectionType(() -> CollectionReference.CollectionType.COLLECTION);
                    this.setExternalReferenceCode(() -> ((AssetListEntry)assetListEntry).getExternalReferenceCode());
                    this.setScope(() -> {
                        if (assetListEntry.getGroupId() == layout.getGroupId()) {
                            return null;
                        }
                        Scope scope = new Scope();
                        Group group = SitePageDTOConverter.this._groupLocalService.getGroup(assetListEntry.getGroupId());
                        scope.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                        scope.setType(() -> {
                            if (group.isDepot()) {
                                return Scope.Type.ASSET_LIBRARY;
                            }
                            return Scope.Type.SITE;
                        });
                        return scope;
                    });
                }
            };
        }
        if (Objects.equals(collectionType, InfoListProviderItemSelectorReturnType.class.getName())) {
            return new ClassNameReference(){
                {
                    this.setClassName(() -> layout.getTypeSettingsProperty("collectionPK"));
                    this.setCollectionType(() -> CollectionReference.CollectionType.COLLECTION_PROVIDER);
                }
            };
        }
        return null;
    }

    private PageSettings _getPageSettings(Layout layout) {
        SitePage.Type type = SitePageTypeUtil.toExternalType(layout.getType());
        if (type == SitePage.Type.COLLECTION_PAGE) {
            return this._toCollectionPageSettings(layout);
        }
        if (type == SitePage.Type.CONTENT_PAGE) {
            return new ContentPageSettings();
        }
        return this._toWidgetPageSettings(layout);
    }

    private CollectionPageSettings _toCollectionPageSettings(Layout layout) {
        CollectionPageSettings collectionPageSettings = new CollectionPageSettings();
        collectionPageSettings.setCollectionReference(() -> this._getCollectionReference(layout));
        return collectionPageSettings;
    }

    private PageSettings _toPageSettings(Layout layout) {
        PageSettings pageSettings = this._getPageSettings(layout);
        pageSettings.setHiddenFromNavigation(() -> ((Layout)layout).isHidden());
        return pageSettings;
    }

    private WidgetPageSettings _toWidgetPageSettings(Layout layout) {
        WidgetPageSettings widgetPageSettings = new WidgetPageSettings();
        widgetPageSettings.setLayoutTemplateId(() -> layout.getTypeSettingsProperty("layout-template-id"));
        return widgetPageSettings;
    }
}

