/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateFolder;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.internal.resource.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseDisplayPageTemplateResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.DisplayPageTemplateResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/display-page-template.properties"}, scope=ServiceScope.PROTOTYPE, service={DisplayPageTemplateResource.class})
public class DisplayPageTemplateResourceImpl
extends BaseDisplayPageTemplateResourceImpl {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.DisplayPageTemplateDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, DisplayPageTemplate> _displayPageTemplateDTOConverter;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutPageTemplateCollectionService _layoutPageTemplateCollectionService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private Portal _portal;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public DisplayPageTemplate getSiteSiteByExternalReferenceCodeDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    public Page<DisplayPageTemplate> getSiteSiteByExternalReferenceCodeDisplayPageTemplateFolderDisplayPageTemplatesPage(String siteExternalReferenceCode, String displayPageTemplateFolderExternalReferenceCode, Boolean flatten) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(displayPageTemplateFolderExternalReferenceCode, groupId);
        if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), -1, -1, null), layoutPageTemplateEntry -> (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)));
    }

    @Override
    public Page<DisplayPageTemplate> getSiteSiteByExternalReferenceCodeDisplayPageTemplatesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), 1, -1, -1, null), layoutPageTemplateEntry -> (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)));
    }

    @Override
    public DisplayPageTemplate postSiteSiteByExternalReferenceCodeDisplayPageTemplate(String siteExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return this._addDisplayPageTemplate(displayPageTemplate, groupId, this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId));
    }

    @Override
    public DisplayPageTemplate postSiteSiteByExternalReferenceCodeDisplayPageTemplateFolderDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateFolderExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(displayPageTemplateFolderExternalReferenceCode, groupId);
        if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return this._addDisplayPageTemplate(displayPageTemplate, groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
    }

    @Override
    public DisplayPageTemplate putSiteSiteByExternalReferenceCodeDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addDisplayPageTemplate(displayPageTemplate, groupId, this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId));
        }
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        long layoutPageTemplateCollectionId = this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId);
        if (Validator.isNotNull((Object)displayPageTemplate.getParentFolder()) && !Objects.equals(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), layoutPageTemplateCollectionId)) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.moveLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), layoutPageTemplateCollectionId);
        }
        if (Validator.isNotNull((Object)displayPageTemplate.getMarkedAsDefault()) && !Objects.equals(GetterUtil.getBoolean((Object)displayPageTemplate.getMarkedAsDefault()), layoutPageTemplateEntry.isDefaultTemplate())) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), GetterUtil.getBoolean((Object)displayPageTemplate.getMarkedAsDefault()));
        }
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), displayPageTemplate.getName()));
    }

    @Override
    protected void preparePatch(DisplayPageTemplate displayPageTemplate, DisplayPageTemplate existingDisplayPageTemplate) {
        if (displayPageTemplate.getParentFolder() != null) {
            existingDisplayPageTemplate.setParentFolder(() -> ((DisplayPageTemplate)displayPageTemplate).getParentFolder());
        }
    }

    private DisplayPageTemplate _addDisplayPageTemplate(DisplayPageTemplate displayPageTemplate, long groupId, long layoutPageTemplateCollectionId) throws Exception {
        ClassSubtypeReference contentTypeReference = displayPageTemplate.getContentTypeReference();
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(displayPageTemplate.getExternalReferenceCode(), groupId, layoutPageTemplateCollectionId, this._portal.getClassNameId(contentTypeReference.getClassName()), this._getClassTypeId(contentTypeReference, groupId), displayPageTemplate.getName(), 0L, 2, this._getServiceContext(displayPageTemplate, groupId)));
    }

    private long _getClassTypeId(ClassSubtypeReference contentTypeReference, long groupId) {
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, contentTypeReference.getClassName());
        if (infoItemFormVariationsProvider == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = contentTypeReference.getSubTypeExternalReference();
        if (itemExternalReference == null) {
            return -1L;
        }
        InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariationByExternalReferenceCode(itemExternalReference.getExternalReferenceCode(), groupId);
        if (infoItemFormVariation != null) {
            return GetterUtil.getLong((String)infoItemFormVariation.getKey());
        }
        return -1L;
    }

    private long _getLayoutPageTemplateCollectionId(DisplayPageTemplate displayPageTemplate, long groupId) throws Exception {
        DisplayPageTemplateFolder displayPageTemplateFolder = displayPageTemplate.getParentFolder();
        if (displayPageTemplateFolder == null) {
            return 0L;
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.fetchLayoutPageTemplateCollection(displayPageTemplateFolder.getExternalReferenceCode(), groupId);
        if (layoutPageTemplateCollection == null) {
            return 0L;
        }
        if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
    }

    private ServiceContext _getServiceContext(DisplayPageTemplate displayPageTemplate, long groupId) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCreateDate(displayPageTemplate.getDateCreated());
        serviceContext.setModifiedDate(displayPageTemplate.getDateModified());
        serviceContext.setUuid(displayPageTemplate.getUuid());
        return serviceContext;
    }
}

