/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.admin.site.dto.v1_0.ClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSpecification;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.segments.service.SegmentsExperienceService;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.portal.kernel.model.Layout"}, service={DTOConverter.class})
public class PageSpecificationDTOConverter
implements DTOConverter<Layout, PageSpecification> {
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageExperienceDTOConverter)")
    private DTOConverter<LayoutPageTemplateStructureRel, PageExperience> _pageExperienceDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;
    @Reference
    private ThemeLocalService _themeLocalService;

    public String getContentType() {
        return PageSpecification.class.getSimpleName();
    }

    public PageSpecification toDTO(DTOConverterContext dtoConverterContext, Layout layout) throws Exception {
        if (layout.isTypeAssetDisplay() || layout.isTypeContent()) {
            return this._toContentPageSpecification(dtoConverterContext, layout);
        }
        return this._toWidgetPageSpecification(layout);
    }

    private ClientExtension _getClientExtension(final ClientExtensionEntryRel clientExtensionEntryRel) {
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return new ClientExtension(){
            {
                this.setClientExtensionConfig(() -> PageSpecificationDTOConverter.this._getClientExtensionConfig(clientExtensionEntryRel));
                this.setExternalReferenceCode(() -> ((ClientExtensionEntryRel)clientExtensionEntryRel).getCETExternalReferenceCode());
            }
        };
    }

    private ClientExtension _getClientExtension(long classNameId, long classPK, String type) {
        return this._getClientExtension(this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, type));
    }

    private Map<String, String> _getClientExtensionConfig(ClientExtensionEntryRel clientExtensionEntryRel) {
        if (clientExtensionEntryRel == null) {
            return null;
        }
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)clientExtensionEntryRel.getTypeSettings()).build();
        if (unicodeProperties.isEmpty()) {
            return null;
        }
        HashMap<String, String> clientExtensionConfig = new HashMap<String, String>();
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            clientExtensionConfig.put((String)entry.getKey(), (String)entry.getValue());
        }
        return clientExtensionConfig;
    }

    private ClientExtension[] _getClientExtensions(long classNameId, long classPK, String type) {
        Object[] clientExtensions = (ClientExtension[])TransformUtil.transformToArray((Collection)this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, classPK, type), clientExtensionEntryRel -> this._getClientExtension((ClientExtensionEntryRel)clientExtensionEntryRel), ClientExtension.class);
        if (ArrayUtil.isEmpty((Object[])clientExtensions)) {
            return null;
        }
        return clientExtensions;
    }

    private PageExperience[] _getPageExperiences(DTOConverterContext dtoConverterContext, Layout layout) throws Exception {
        return (PageExperience[])TransformUtil.transformToArray((Collection)this._segmentsExperienceService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true), segmentsExperience -> {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(segmentsExperience.getGroupId(), layout.getPlid());
            LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperience.getSegmentsExperienceId());
            if (layoutPageTemplateStructureRel == null) {
                throw new UnsupportedOperationException();
            }
            return (PageExperience)this._pageExperienceDTOConverter.toDTO(dtoConverterContext, (Object)layoutPageTemplateStructureRel);
        }, PageExperience.class);
    }

    private Settings _setSettings(final Layout layout) throws Exception {
        final long classNameId = this._portal.getClassNameId(Layout.class.getName());
        final UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setColorSchemeName(() -> {
                    if (Validator.isNull((String)layout.getColorSchemeId()) || Validator.isNull((String)layout.getThemeId())) {
                        return null;
                    }
                    ColorScheme colorScheme = PageSpecificationDTOConverter.this._themeLocalService.getColorScheme(layout.getCompanyId(), layout.getThemeId(), layout.getColorSchemeId());
                    if (colorScheme == null) {
                        return null;
                    }
                    return colorScheme.getName();
                });
                this.setCss(() -> {
                    if (Validator.isNull((String)layout.getCss())) {
                        return null;
                    }
                    return layout.getCss();
                });
                this.setFavIcon(() -> {
                    ClientExtension clientExtension = PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeFavicon");
                    if (clientExtension != null) {
                        return clientExtension;
                    }
                    long faviconFileEntryId = layout.getFaviconFileEntryId();
                    if (faviconFileEntryId == 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = PageSpecificationDTOConverter.this._dlAppService.getFileEntry(faviconFileEntryId);
                    if (fileEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setClassName(() -> FileEntry.class.getName());
                            this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setGlobalCSSClientExtensions(() -> PageSpecificationDTOConverter.this._getClientExtensions(classNameId, layout.getPlid(), "globalCSS"));
                this.setGlobalJSClientExtensions(() -> PageSpecificationDTOConverter.this._getClientExtensions(classNameId, layout.getPlid(), "globalJS"));
                this.setJavascript(() -> unicodeProperties.getProperty("javascript", null));
                this.setMasterPageItemExternalReference(() -> {
                    if (layout.getMasterLayoutPlid() == 0L) {
                        return null;
                    }
                    final LayoutPageTemplateEntry layoutPageTemplateEntry = PageSpecificationDTOConverter.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getMasterLayoutPlid());
                    if (layoutPageTemplateEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                            this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setStyleBookItemExternalReference(() -> {
                    final StyleBookEntry styleBookEntry = PageSpecificationDTOConverter.this._styleBookEntryLocalService.fetchStyleBookEntry(layout.getStyleBookEntryId());
                    if (styleBookEntry == null) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                            this.setExternalReferenceCode(() -> ((StyleBookEntry)styleBookEntry).getExternalReferenceCode());
                        }
                    };
                });
                this.setThemeCSSClientExtension(() -> PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeCSS"));
                this.setThemeName(() -> {
                    if (Validator.isNull((String)layout.getThemeId())) {
                        return null;
                    }
                    Theme theme = PageSpecificationDTOConverter.this._themeLocalService.fetchTheme(layout.getCompanyId(), layout.getThemeId());
                    if (theme == null) {
                        return null;
                    }
                    return theme.getName();
                });
                this.setThemeSettings(() -> {
                    HashMap<String, String> themeSettings = new HashMap<String, String>();
                    for (String key : unicodeProperties.keySet()) {
                        if (!key.startsWith("lfr-theme:")) continue;
                        themeSettings.put(key, unicodeProperties.getProperty(key, null));
                    }
                    if (MapUtil.isEmpty(themeSettings)) {
                        return null;
                    }
                    return themeSettings;
                });
                this.setThemeSpritemapClientExtension(() -> PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeSpritemap"));
            }
        };
    }

    private PageSpecification _toContentPageSpecification(final DTOConverterContext dtoConverterContext, final Layout layout) {
        return new ContentPageSpecification(){
            {
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setPageExperiences(() -> PageSpecificationDTOConverter.this._getPageExperiences(dtoConverterContext, layout));
                this.setSettings(() -> PageSpecificationDTOConverter.this._setSettings(layout));
                this.setStatus(() -> {
                    if (!layout.isDraftLayout()) {
                        return PageSpecification.Status.APPROVED;
                    }
                    return PageSpecification.Status.DRAFT;
                });
                this.setType(() -> PageSpecification.Type.CONTENT_PAGE_SPECIFICATION);
            }
        };
    }

    private PageSpecification _toWidgetPageSpecification(final Layout layout) {
        return new WidgetPageSpecification(){
            {
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setSettings(() -> PageSpecificationDTOConverter.this._setSettings(layout));
                this.setStatus(() -> PageSpecification.Status.APPROVED);
                this.setType(() -> PageSpecification.Type.WIDGET_PAGE_SPECIFICATION);
            }
        };
    }
}

