/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel"}, service={DTOConverter.class})
public class PageExperienceDTOConverter
implements DTOConverter<LayoutPageTemplateStructureRel, PageExperience> {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageElementDTOConverter)")
    private DTOConverter<LayoutStructureItem, PageElement> _pageElementDTOConverter;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public String getContentType() {
        return PageExperience.class.getSimpleName();
    }

    public PageExperience toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateStructureRel layoutPageTemplateStructureRel) throws Exception {
        final SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(layoutPageTemplateStructureRel.getSegmentsExperienceId());
        final Layout layout = this._layoutLocalService.getLayout(segmentsExperience.getPlid());
        return new PageExperience(){
            {
                this.setExternalReferenceCode(() -> ((SegmentsExperience)segmentsExperience).getExternalReferenceCode());
                this.setKey(() -> ((SegmentsExperience)segmentsExperience).getSegmentsExperienceKey());
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)segmentsExperience.getNameMap()));
                this.setPageElements(() -> PageExperienceDTOConverter.this._getPageElements(layoutPageTemplateStructureRel));
                this.setPriority(() -> ((SegmentsExperience)segmentsExperience).getPriority());
                this.setSegmentExternalReferenceCode(() -> {
                    SegmentsEntry segmentsEntry = PageExperienceDTOConverter.this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsExperience.getSegmentsEntryId());
                    if (segmentsEntry == null) {
                        return null;
                    }
                    return segmentsEntry.getSegmentsEntryKey();
                });
                this.setSitePageExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
            }
        };
    }

    private PageElement[] _getChildPageElements(LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem) throws Exception {
        List childrenItemIds = layoutStructureItem.getChildrenItemIds();
        if (ListUtil.isEmpty((List)childrenItemIds)) {
            return null;
        }
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        for (int i = 0; i < childrenItemIds.size(); ++i) {
            pageElements.add(this._getPageElement((String)childrenItemIds.get(i), layoutStructure, i));
        }
        return pageElements.toArray(new PageElement[0]);
    }

    private PageElement _getPageElement(String itemId, LayoutStructure layoutStructure, int position) throws Exception {
        LayoutStructureItem layoutStructureItem = layoutStructure.getLayoutStructureItem(itemId);
        PageElement pageElement = (PageElement)this._pageElementDTOConverter.toDTO((Object)layoutStructureItem);
        pageElement.setPageElements(() -> this._getChildPageElements(layoutStructure, layoutStructureItem));
        pageElement.setPosition(() -> position);
        return pageElement;
    }

    private PageElement[] _getPageElements(LayoutPageTemplateStructureRel layoutPageTemplateStructureRel) throws Exception {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructureRel.getData());
        LayoutStructureItem rootLayoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        List childrenItemIds = rootLayoutStructureItem.getChildrenItemIds();
        for (int i = 0; i < childrenItemIds.size(); ++i) {
            PageElement pageElement = this._getPageElement((String)childrenItemIds.get(i), layoutStructure, i);
            pageElement.setParentExternalReferenceCode(() -> null);
            pageElements.add(pageElement);
        }
        return pageElements.toArray(new PageElement[0]);
    }
}

