/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.PageCollectionDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageCollectionItemDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageColumnDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageContainerDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageDropZoneDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageFormDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFragmentDropZoneDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageFragmentInstanceDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageRowDefinition;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructureItem"}, service={DTOConverter.class})
public class PageElementDTOConverter
implements DTOConverter<LayoutStructureItem, PageElement> {
    private static final Map<String, PageElement.Type> _internalToExternalValuesMap = HashMapBuilder.put((Object)"collection", (Object)PageElement.Type.COLLECTION).put((Object)"collection-item", (Object)PageElement.Type.COLLECTION_ITEM).put((Object)"column", (Object)PageElement.Type.COLUMN).put((Object)"container", (Object)PageElement.Type.CONTAINER).put((Object)"drop-zone", (Object)PageElement.Type.DROP_ZONE).put((Object)"form", (Object)PageElement.Type.FORM).put((Object)"fragment", (Object)PageElement.Type.FRAGMENT).put((Object)"fragment-drop-zone", (Object)PageElement.Type.FRAGMENT_DROP_ZONE).put((Object)"row", (Object)PageElement.Type.ROW).build();

    public String getContentType() {
        return PageElement.class.getSimpleName();
    }

    public PageElement toDTO(DTOConverterContext dtoConverterContext, final LayoutStructureItem layoutStructureItem) throws Exception {
        return new PageElement(){
            {
                this.setDefinition(() -> PageElementDTOConverter.this._getDefinition(layoutStructureItem));
                this.setExternalReferenceCode(() -> ((LayoutStructureItem)layoutStructureItem).getItemId());
                this.setPageElements(() -> new PageElement[0]);
                this.setParentExternalReferenceCode(() -> ((LayoutStructureItem)layoutStructureItem).getParentItemId());
                this.setPosition(() -> 0);
                this.setType(() -> PageElementDTOConverter.this._getType(layoutStructureItem.getItemType()));
            }
        };
    }

    private Object _getDefinition(LayoutStructureItem layoutStructureItem) {
        if (Objects.equals(layoutStructureItem.getItemType(), "collection")) {
            return new PageCollectionDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "collection-item")) {
            return new PageCollectionItemDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "column")) {
            return new PageColumnDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "container")) {
            return new PageContainerDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "drop-zone")) {
            return new PageDropZoneDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form")) {
            return new PageFormDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form-step") || Objects.equals(layoutStructureItem.getItemType(), "form-step-container")) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment")) {
            return new PageFragmentInstanceDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment-drop-zone")) {
            return new PageFragmentDropZoneDefinition();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "root")) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "row")) {
            return new PageRowDefinition();
        }
        throw new UnsupportedOperationException();
    }

    private PageElement.Type _getType(String type) {
        if (_internalToExternalValuesMap.containsKey(type)) {
            return _internalToExternalValuesMap.get(type);
        }
        throw new UnsupportedOperationException();
    }
}

