/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.SitePageResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.SitePageDTOConverter)")
    private DTOConverter<Layout, SitePage> _sitePageDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        this._layoutService.deleteLayout(sitePageExternalReferenceCode, group.getGroupId());
    }

    @Override
    public SitePage getSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, group.getGroupId());
        return this._toSitePage(layout);
    }

    @Override
    public SitePage postByExternalReferenceCodeSitePage(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(siteExternalReferenceCode, this.contextCompany.getCompanyId());
        WidgetPageSettings widgetPageSettings = (WidgetPageSettings)sitePage.getPageSettings();
        ServiceContext serviceContext = ServiceContextBuilder.create((long)group.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, (String)sitePage.getViewableByAsString()).build();
        serviceContext.setUuid(sitePage.getUuid());
        return this._toSitePage(this._layoutService.addLayout(sitePage.getExternalReferenceCode(), group.getGroupId(), false, 0L, 0L, 0L, LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n()), LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n()), null, null, null, this._toType(sitePage.getType()), UnicodePropertiesBuilder.create((boolean)true).setProperty("layout-template-id", widgetPageSettings.getLayoutTemplateId()).buildString(), GetterUtil.getBoolean((Object)widgetPageSettings.getHiddenFromNavigation()), false, LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), 0L, serviceContext));
    }

    private SitePage _toSitePage(Layout layout) throws Exception {
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)layout);
    }

    private String _toType(SitePage.Type type) {
        if (Objects.equals(type, SitePage.Type.COLLECTION_PAGE)) {
            return "collection";
        }
        if (Objects.equals(type, SitePage.Type.CONTENT_PAGE)) {
            return "content";
        }
        if (Objects.equals(type, SitePage.Type.WIDGET_PAGE)) {
            return "portlet";
        }
        throw new UnsupportedOperationException();
    }
}

