/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer;

import com.liferay.fragment.contributor.util.FragmentCollectionContributorRegistryUtil;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.processor.PortletRegistry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.util.FragmentRendererRegistryUtil;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.DefaultFragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentEditableElementUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.util.FragmentConfigurationFieldValuesUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PortletUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class FragmentLayoutStructureItemImporter
implements LayoutStructureItemImporter {
    private static final ServiceTracker<PortletRegistry, PortletRegistry> _portletRegistryServiceTracker = ServiceTrackerFactory.open((Bundle)FrameworkUtil.getBundle(FragmentLayoutStructureItemImporter.class), PortletRegistry.class);

    @Override
    public LayoutStructureItem addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition = (FragmentInstancePageElementDefinition)pageElement.getPageElementDefinition();
        if (fragmentInstancePageElementDefinition == null) {
            return null;
        }
        List fragmentEntryLinkPortletIds = null;
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstancePageElementDefinition.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            fragmentEntryLink = this._addFragmentEntryLink(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext);
        } else {
            PortletRegistry portletRegistry = (PortletRegistry)_portletRegistryServiceTracker.getService();
            if (portletRegistry != null) {
                fragmentEntryLinkPortletIds = portletRegistry.getFragmentEntryLinkPortletIds(fragmentEntryLink);
            }
            fragmentEntryLink = this._updateFragmentEntryLink(fragmentEntryLink, fragmentInstancePageElementDefinition, layoutStructureItemImporterContext);
        }
        if (fragmentEntryLink == null) {
            return null;
        }
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (ArrayUtil.isNotEmpty((Object[])fragmentInstancePageElementDefinition.getWidgetInstances())) {
            for (WidgetInstance widgetInstance : fragmentInstancePageElementDefinition.getWidgetInstances()) {
                if (Validator.isNull((String)widgetInstance.getWidgetName())) continue;
                String portletId = PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId());
                PortletUtil.importPortletPermissions(layout, portletId, widgetInstance.getWidgetName(), widgetInstance.getWidgetPermissions());
                PortletUtil.importPortletPreferences(layout, portletId, widgetInstance.getWidgetConfig());
            }
        }
        if (ListUtil.isNotEmpty((List)fragmentEntryLinkPortletIds)) {
            for (String fragmentEntryLinkPortletId : SetUtil.asymmetricDifference((Collection)fragmentEntryLinkPortletIds, this._getPortletIds(fragmentInstancePageElementDefinition.getWidgetInstances()))) {
                PortletPreferencesLocalServiceUtil.deletePortletPreferences((long)0L, (int)3, (long)layout.getPlid(), (String)fragmentEntryLinkPortletId);
                ResourcePermissionLocalServiceUtil.deleteResourcePermissions((long)layout.getCompanyId(), (String)fragmentEntryLinkPortletId, (int)4, (String)PortletPermissionUtil.getPrimaryKey((long)layout.getPlid(), (String)fragmentEntryLinkPortletId));
            }
        }
        FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem = (FragmentStyledLayoutStructureItem)layoutStructure.addFragmentStyledLayoutStructureItem(fragmentEntryLink.getFragmentEntryLinkId(), pageElement.getExternalReferenceCode(), LayoutStructureUtil.getParentExternalReferenceCode(pageElement, layoutStructure), pageElement.getPosition().intValue());
        fragmentStyledLayoutStructureItem.setCssClasses(SetUtil.fromArray((Object[])fragmentInstancePageElementDefinition.getCssClasses()));
        fragmentStyledLayoutStructureItem.setCustomCSS(fragmentInstancePageElementDefinition.getCustomCSS());
        fragmentStyledLayoutStructureItem.setIndexed(GetterUtil.getBoolean((Object)fragmentInstancePageElementDefinition.getIndexed(), (boolean)true));
        fragmentStyledLayoutStructureItem.setName(fragmentInstancePageElementDefinition.getName());
        return fragmentStyledLayoutStructureItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FragmentEntryLink _addFragmentEntryLink(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        FragmentEntryReference fragmentEntryReference = this._getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstancePageElementDefinition.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date createDate = serviceContext.getCreateDate();
        String uuid = serviceContext.getUuid();
        try {
            serviceContext.setCreateDate(fragmentInstancePageElementDefinition.getDatePropagated());
            serviceContext.setUuid(fragmentInstancePageElementDefinition.getUuid());
            FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.addFragmentEntryLink((String)fragmentInstancePageElementDefinition.getFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getUserId(), (long)layout.getGroupId(), (String)this._getOriginalFragmentEntryLinkERC(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext), (String)fragmentEntryReference.getFragmentEntryERC(), (String)fragmentEntryReference.getFragmentEntryScopeERC(), (long)layoutStructureItemImporterContext.getSegmentsExperienceId(), (long)layout.getPlid(), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getCss()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getHtml()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getJs()), (String)GetterUtil.getString((String)fragmentInstancePageElementDefinition.getConfiguration()), (String)this._getEditableValues(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext), (String)fragmentInstancePageElementDefinition.getNamespace(), (int)0, (String)fragmentEntryReference.getRendererKey(), (int)this._getType(fragmentInstancePageElementDefinition), (ServiceContext)serviceContext);
            return fragmentEntryLink;
        }
        finally {
            serviceContext.setCreateDate(createDate);
            serviceContext.setUuid(uuid);
        }
    }

    private String _getEditableValues(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        return JSONUtil.merge((JSONObject)FragmentConfigurationFieldValuesUtil.getFragmentConfigurationFieldValuesEditableValuesJSONObject(fragmentInstancePageElementDefinition.getConfiguration(), fragmentInstancePageElementDefinition.getFragmentConfigurationFieldValues(), layoutStructureItemImporterContext), (JSONObject)FragmentEditableElementUtil.getFragmentEditableElementsEditableValuesJSONObject(layoutStructureItemImporterContext.getCompanyId(), fragmentInstancePageElementDefinition.getFragmentEditableElements(), layoutStructureItemImporterContext.getInfoItemServiceRegistry(), layoutStructureItemImporterContext.getGroupId())).toString();
    }

    private FragmentEntryReference _getFragmentEntryReference(long companyId, FragmentReference fragmentReference, long scopeGroupId) throws Exception {
        if (fragmentReference == null) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(fragmentReference.getFragmentReferenceType(), FragmentReference.FragmentReferenceType.FRAGMENT_ITEM_EXTERNAL_REFERENCE)) {
            FragmentItemExternalReference fragmentItemExternalReference = (FragmentItemExternalReference)fragmentReference;
            if (Validator.isNull((String)fragmentItemExternalReference.getExternalReferenceCode())) {
                throw new UnsupportedOperationException();
            }
            FragmentEntry fragmentEntry = null;
            Long groupId = ItemScopeUtil.getGroupId(companyId, fragmentItemExternalReference.getScope(), scopeGroupId);
            if (groupId != null) {
                fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntryByExternalReferenceCode((String)GetterUtil.getString((String)fragmentItemExternalReference.getExternalReferenceCode()), (long)groupId);
            }
            if (fragmentEntry == null) {
                LogUtil.logOptionalReference(fragmentItemExternalReference.getClassName(), fragmentItemExternalReference.getExternalReferenceCode(), fragmentItemExternalReference.getScope(), scopeGroupId);
            }
            return new FragmentEntryReference(fragmentItemExternalReference.getExternalReferenceCode(), ItemScopeUtil.getItemScopeExternalReferenceCode(fragmentItemExternalReference.getScope(), scopeGroupId), null);
        }
        DefaultFragmentReference defaultFragmentReference = (DefaultFragmentReference)fragmentReference;
        if (Validator.isNull((String)defaultFragmentReference.getDefaultFragmentKey())) {
            throw new UnsupportedOperationException();
        }
        FragmentEntry fragmentEntry = FragmentCollectionContributorRegistryUtil.getFragmentEntry((String)defaultFragmentReference.getDefaultFragmentKey());
        FragmentRenderer fragmentRenderer = null;
        if (fragmentEntry == null) {
            fragmentRenderer = FragmentRendererRegistryUtil.getFragmentRenderer((String)defaultFragmentReference.getDefaultFragmentKey());
        }
        if (fragmentEntry == null && fragmentRenderer == null) {
            LogUtil.logOptionalReference(DefaultFragmentReference.class, defaultFragmentReference.getDefaultFragmentKey(), scopeGroupId);
        }
        return new FragmentEntryReference(null, null, defaultFragmentReference.getDefaultFragmentKey());
    }

    private String _getOriginalFragmentEntryLinkERC(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) {
        if (Validator.isNull((String)fragmentInstancePageElementDefinition.getDraftFragmentInstanceExternalReferenceCode())) {
            return null;
        }
        FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLinkByExternalReferenceCode((String)fragmentInstancePageElementDefinition.getDraftFragmentInstanceExternalReferenceCode(), (long)layoutStructureItemImporterContext.getGroupId());
        if (fragmentEntryLink == null) {
            return null;
        }
        return fragmentEntryLink.getExternalReferenceCode();
    }

    private List<String> _getPortletIds(WidgetInstance[] widgetInstances) {
        ArrayList<String> portletIds = new ArrayList<String>();
        if (ArrayUtil.isEmpty((Object[])widgetInstances)) {
            return portletIds;
        }
        for (WidgetInstance widgetInstance : widgetInstances) {
            portletIds.add(PortletIdCodec.encode((String)widgetInstance.getWidgetName(), (String)widgetInstance.getWidgetInstanceId()));
        }
        return portletIds;
    }

    private int _getType(FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition) {
        int type = 1;
        if (Objects.equals(FragmentInstancePageElementDefinition.FragmentType.FORM, fragmentInstancePageElementDefinition.getFragmentType())) {
            type = 3;
        }
        return type;
    }

    private FragmentEntryLink _updateFragmentEntryLink(FragmentEntryLink fragmentEntryLink, FragmentInstancePageElementDefinition fragmentInstancePageElementDefinition, LayoutStructureItemImporterContext layoutStructureItemImporterContext) throws Exception {
        Layout layout = layoutStructureItemImporterContext.getLayout();
        if (fragmentEntryLink.getPlid() != layout.getPlid() || fragmentEntryLink.getSegmentsExperienceId() != layoutStructureItemImporterContext.getSegmentsExperienceId()) {
            throw new UnsupportedOperationException();
        }
        FragmentEntryReference fragmentEntryReference = this._getFragmentEntryReference(layoutStructureItemImporterContext.getCompanyId(), fragmentInstancePageElementDefinition.getFragmentReference(), layoutStructureItemImporterContext.getGroupId());
        fragmentEntryLink.setOriginalFragmentEntryLinkERC(this._getOriginalFragmentEntryLinkERC(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext));
        fragmentEntryLink.setFragmentEntryERC(fragmentEntryReference.getFragmentEntryERC());
        fragmentEntryLink.setFragmentEntryScopeERC(fragmentEntryReference.getFragmentEntryScopeERC());
        fragmentEntryLink.setCss(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getCss()));
        fragmentEntryLink.setHtml(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getHtml()));
        fragmentEntryLink.setJs(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getJs()));
        fragmentEntryLink.setConfiguration(GetterUtil.getString((String)fragmentInstancePageElementDefinition.getConfiguration()));
        fragmentEntryLink.setEditableValues(this._getEditableValues(fragmentInstancePageElementDefinition, layoutStructureItemImporterContext));
        fragmentEntryLink.setNamespace(fragmentInstancePageElementDefinition.getNamespace());
        fragmentEntryLink.setRendererKey(fragmentEntryReference.getRendererKey());
        fragmentEntryLink.setType(this._getType(fragmentInstancePageElementDefinition));
        fragmentEntryLink.setLastPropagationDate(fragmentInstancePageElementDefinition.getDatePropagated());
        return FragmentEntryLinkLocalServiceUtil.updateFragmentEntryLink((FragmentEntryLink)fragmentEntryLink);
    }

    private static class FragmentEntryReference {
        private final String _fragmentEntryERC;
        private final String _fragmentEntryScopeERC;
        private final String _rendererKey;

        public FragmentEntryReference(String fragmentEntryERC, String fragmentEntryScopeERC, String rendererKey) {
            this._fragmentEntryERC = fragmentEntryERC;
            this._fragmentEntryScopeERC = fragmentEntryScopeERC;
            this._rendererKey = rendererKey;
        }

        public String getFragmentEntryERC() {
            return this._fragmentEntryERC;
        }

        public String getFragmentEntryScopeERC() {
            return this._fragmentEntryScopeERC;
        }

        public String getRendererKey() {
            return this._rendererKey;
        }
    }
}

