/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.Site;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSiteResourceImpl;
import com.liferay.headless.admin.site.resource.v1_0.SiteResource;
import com.liferay.layout.util.LayoutServiceContextHelper;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.events.ServicePreAction;
import com.liferay.portal.events.ThemeServicePreAction;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.lazy.referencing.LazyReferencingThreadLocal;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.servlet.DummyHttpServletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.GroupNameComparator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.SiteInitializerFactory;
import com.liferay.site.initializer.SiteInitializerRegistry;
import com.liferay.site.initializer.SiteInitializerSerializer;
import com.liferay.sites.kernel.util.Sites;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v1_0/site.properties"}, scope=ServiceScope.PROTOTYPE, service={SiteResource.class})
public class SiteResourceImpl
extends BaseSiteResourceImpl {
    private static final String[] _EXCLUDED_TYPE_SETTINGS = new String[]{"GOOGLE_PLACES_API_KEY", "defaultSiteRoleIds", "defaultTeamIds", "googleMapsAPIKey"};
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupService _groupService;
    @Reference
    private LayoutServiceContextHelper _layoutServiceContextHelper;
    @Reference
    private LayoutSetPrototypeLocalService _layoutSetPrototypeLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SiteInitializerFactory _siteInitializerFactory;
    @Reference
    private SiteInitializerRegistry _siteInitializerRegistry;
    @Reference
    private SiteInitializerSerializer _siteInitializerSerializer;
    @Reference
    private Sites _sites;

    @Override
    public void deleteSite(Long siteId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        this._groupService.deleteGroup(siteId.longValue());
    }

    @Override
    public void deleteSiteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group == null) {
            throw new NoSuchGroupException("No site exists with external reference code " + externalReferenceCode);
        }
        this._groupService.deleteGroup(group.getGroupId());
    }

    @Override
    public Site getSite(Long siteId) {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroup(siteId.longValue());
        return this._toSite(group);
    }

    @Override
    public Site getSiteByExternalReferenceCode(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        return this._toSite(group);
    }

    @Override
    public Response getSiteByExternalReferenceCodeSiteInitializer(String externalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306") || !FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-19870")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.getGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        File file = this._siteInitializerSerializer.serialize(group.getGroupId());
        return Response.ok((Object)file).header("Content-Disposition", (Object)("attachment; filename=\"" + file.getName() + "\"")).build();
    }

    @Override
    public Page<Site> getSitesPage(Boolean active, String search, Pagination pagination) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        long[] classNameIds = new long[]{this._portal.getClassNameId(Company.class.getName()), this._portal.getClassNameId(Group.class.getName())};
        LinkedHashMap params = LinkedHashMapBuilder.put((Object)"active", () -> {
            if (active != null) {
                return GetterUtil.getBoolean((Object)active);
            }
            return null;
        }).put((Object)"site", (Object)true).build();
        return Page.of((Map)HashMapBuilder.put((Object)"create", this.addAction("UPDATE", "postSite", Group.class.getName(), null)).put((Object)"createBatch", this.addAction("UPDATE", "postSiteBatch", Group.class.getName(), null)).put((Object)"deleteBatch", this.addAction("DELETE", "deleteSiteBatch", Group.class.getName(), null)).build(), this.transform(this._groupService.search(this.contextCompany.getCompanyId(), classNameIds, search, null, params, true, pagination.getStartPosition(), pagination.getEndPosition(), (OrderByComparator)new GroupNameComparator()), this::_toSite), (Pagination)pagination, (long)this._groupService.searchCount(this.contextCompany.getCompanyId(), classNameIds, search, params));
    }

    @Override
    public Site postSite(Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._addGroup(site.getExternalReferenceCode(), site);
        return this._toSite(group);
    }

    @Override
    public Site postSiteSiteInitializer(MultipartBody multipartBody) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Site site = (Site)multipartBody.getValueAsInstance("site", Site.class);
        return this.putSiteByExternalReferenceCode(site.getExternalReferenceCode(), multipartBody);
    }

    @Override
    public Site putSite(Site site) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        String externalReferenceCode = site.getExternalReferenceCode();
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        group = group == null ? this._addGroup(externalReferenceCode, site) : this._updateGroup(group, site);
        return this._toSite(group);
    }

    @Override
    public Site putSiteByExternalReferenceCode(String externalReferenceCode, MultipartBody multipartBody) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)this.contextCompany.getCompanyId(), (String)"LPD-41306")) {
            throw new UnsupportedOperationException();
        }
        Group group = this._groupLocalService.fetchGroupByExternalReferenceCode(externalReferenceCode, this.contextCompany.getCompanyId());
        if (group != null) {
            if (!group.isSite()) {
                throw new IllegalArgumentException("No site exists with external reference code " + externalReferenceCode);
            }
            GroupPermissionUtil.check((PermissionChecker)PermissionThreadLocal.getPermissionChecker(), (Group)group, (String)"UPDATE");
            group = this._updateGroup(group, (Site)multipartBody.getValueAsInstance("site", Site.class));
            return this._toSite(group);
        }
        group = this._addGroup(externalReferenceCode, (Site)multipartBody.getValueAsInstance("site", Site.class));
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        String name = PrincipalThreadLocal.getName();
        File tempFile = FileUtil.createTempFile((byte[])multipartBody.getBinaryFileAsBytes("file"));
        File tempFolder = FileUtil.createTempFolder();
        FileUtil.unzip((File)tempFile, (File)tempFolder);
        tempFile.delete();
        try (SafeCloseable safeCloseable = CompanyThreadLocal.setCompanyIdWithSafeCloseable((Long)this.contextCompany.getCompanyId());){
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)PermissionCheckerFactoryUtil.create((User)this.contextUser));
            PrincipalThreadLocal.setName((long)this.contextUser.getUserId());
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._getServiceContext(group));
            SiteInitializer siteInitializer = this._siteInitializerFactory.create(new File(tempFolder, "site-initializer"), group.getName(LocaleUtil.getDefault()));
            siteInitializer.initialize(group.getGroupId());
        }
        catch (Exception exception) {
            PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
            throw exception;
        }
        finally {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            PrincipalThreadLocal.setName((String)name);
            ServiceContextThreadLocal.popServiceContext();
            tempFolder.delete();
        }
        Group finalGroup = group;
        return this._toSite(finalGroup);
    }

    private Group _addGroup(String externalReferenceCode, Site site) throws Exception {
        if (Validator.isNull((String)site.getTemplateKey()) && Validator.isNotNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template key cannot be empty if template type is specified");
        }
        if (Validator.isNotNull((String)site.getTemplateKey()) && Validator.isNull((Object)site.getTemplateType())) {
            throw new IllegalArgumentException("Template type cannot be empty if template key is specified");
        }
        if (Objects.equals(Site.TemplateType.SITE_INITIALIZER, site.getTemplateType())) {
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(site.getTemplateKey());
            if (siteInitializer == null) {
                throw new IllegalArgumentException("No site initializer was found for site template key " + site.getTemplateKey());
            }
            if (!siteInitializer.isActive(this.contextCompany.getCompanyId())) {
                throw new IllegalArgumentException("Site initializer with site template key " + site.getTemplateKey() + " is inactive");
            }
        } else if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            LayoutSetPrototype layoutSetPrototype = this._layoutSetPrototypeLocalService.fetchLayoutSetPrototype(GetterUtil.getLongStrict((String)site.getTemplateKey()));
            if (layoutSetPrototype == null) {
                throw new IllegalArgumentException("No site template was found for site template key " + site.getTemplateKey());
            }
            if (!layoutSetPrototype.isActive()) {
                throw new IllegalArgumentException("Site template with site template key " + site.getTemplateKey() + " is inactive");
            }
        }
        this._initThemeDisplay();
        try {
            Group group;
            block20: {
                AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(this.contextCompany, this.contextUser);
                try {
                    group = this._addGroup(externalReferenceCode, site, this._getServiceContext());
                    if (autoCloseable == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return group;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    private Group _addGroup(String externalReferenceCode, Site site, ServiceContext serviceContext) throws Exception {
        Group group = this._groupService.addGroup(externalReferenceCode, this._getParentGroupId(null, site.getParentSiteExternalReferenceCode(), site.getParentSiteKey()), 0L, this._getNameMap(site), this._getDescriptionMap(site), this._getType(site.getMembershipType()), this._getTypeSettings(site.getTypeSettings(), null), this._isManualMembership(site.getManualMembership()), this._getMembershipRestriction(site.getMembershipRestriction()), site.getFriendlyUrlPath(), true, false, this._isActive(site.getActive()), serviceContext);
        LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)group.getGroupId(), (long)this.contextUser.getUserId());
        if (Objects.equals(Site.TemplateType.SITE_TEMPLATE, site.getTemplateType())) {
            this._sites.updateLayoutSetPrototypesLinks(group, GetterUtil.getLongStrict((String)site.getTemplateKey()), 0L, true, false);
        } else {
            String siteInitializerKey = "blank-site-initializer";
            if (Validator.isNotNull((String)site.getTemplateKey())) {
                siteInitializerKey = site.getTemplateKey();
            }
            SiteInitializer siteInitializer = this._siteInitializerRegistry.getSiteInitializer(siteInitializerKey);
            siteInitializer.initialize(group.getGroupId());
        }
        return group;
    }

    private Map<Locale, String> _getDescriptionMap(Site site) {
        if (Validator.isNotNull((Object)site.getDescription_i18n())) {
            return LocalizedMapUtil.getLocalizedMap((Map)site.getDescription_i18n());
        }
        if (site.getDescription() == null) {
            return null;
        }
        return HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)site.getDescription()).build();
    }

    private int _getMembershipRestriction(Integer membershipRestriction) {
        if (membershipRestriction == null) {
            return 0;
        }
        return membershipRestriction;
    }

    private Map<Locale, String> _getNameMap(Site site) {
        if (Validator.isNotNull((Object)site.getName_i18n())) {
            return LocalizedMapUtil.getLocalizedMap((Map)site.getName_i18n());
        }
        return HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)site.getName()).build();
    }

    private long _getParentGroupId(Group group, String parentSiteExternalReferenceCode, String parentSiteKey) {
        if (Validator.isNull((String)parentSiteExternalReferenceCode) && Validator.isNull((String)parentSiteKey)) {
            return 0L;
        }
        Group parentGroup = this._groupLocalService.loadFetchGroup(this.contextCompany.getCompanyId(), parentSiteKey);
        if (parentGroup == null && (parentGroup = this._groupLocalService.fetchGroupByExternalReferenceCode(parentSiteExternalReferenceCode, this.contextCompany.getCompanyId())) == null) {
            return 0L;
        }
        if (!LazyReferencingThreadLocal.isEnabled()) {
            return parentGroup.getGroupId();
        }
        if (group != null) {
            Group currentParentGroup = group.getParentGroup();
            if (currentParentGroup != null && Objects.equals(currentParentGroup.getExternalReferenceCode(), parentSiteExternalReferenceCode)) {
                return currentParentGroup.getGroupId();
            }
            return 0L;
        }
        return parentGroup.getGroupId();
    }

    private ServiceContext _getServiceContext() throws PortalException {
        ServiceContext serviceContext = null;
        if (this.contextHttpServletRequest != null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)this.contextHttpServletRequest);
        } else {
            serviceContext = new ServiceContext();
            serviceContext.setCompanyId(this.contextCompany.getCompanyId());
            serviceContext.setRequest(this.contextHttpServletRequest);
            serviceContext.setUserId(this.contextUser.getUserId());
        }
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        return serviceContext;
    }

    private ServiceContext _getServiceContext(Group group) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setRequest(this.contextHttpServletRequest);
        serviceContext.setScopeGroupId(group.getGroupId());
        serviceContext.setUserId(this.contextUser.getUserId());
        this._initThemeDisplay();
        return serviceContext;
    }

    private int _getType(Site.MembershipType membershipType) {
        if (membershipType == null || membershipType.equals((Object)Site.MembershipType.OPEN)) {
            return 1;
        }
        if (membershipType.equals((Object)Site.MembershipType.PRIVATE)) {
            return 3;
        }
        return 2;
    }

    private String _getTypeSettings(Map<String, String> typeSettings, UnicodeProperties oldUnicodeProperties) throws Exception {
        UnicodeProperties unicodeProperties;
        if (typeSettings == null) {
            return null;
        }
        unicodeProperties.putIfAbsent((Object)"inheritLocales", (Object)String.valueOf(!(unicodeProperties = UnicodePropertiesBuilder.putAll(typeSettings).build()).containsKey((Object)"locales")));
        if (oldUnicodeProperties == null) {
            return unicodeProperties.toString();
        }
        for (String excludedTypeSetting : _EXCLUDED_TYPE_SETTINGS) {
            if (!oldUnicodeProperties.containsKey((Object)excludedTypeSetting)) continue;
            unicodeProperties.put(excludedTypeSetting, (String)oldUnicodeProperties.get((Object)excludedTypeSetting));
        }
        return unicodeProperties.toString();
    }

    private void _initThemeDisplay() throws Exception {
        if (this.contextHttpServletRequest == null) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            return;
        }
        ServicePreAction servicePreAction = new ServicePreAction();
        servicePreAction.servicePre(this.contextHttpServletRequest, this.contextHttpServletResponse, false);
        ThemeServicePreAction themeServicePreAction = new ThemeServicePreAction();
        themeServicePreAction.run(this.contextHttpServletRequest, this.contextHttpServletResponse);
        themeDisplay = (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setResponse((HttpServletResponse)new DummyHttpServletResponse());
    }

    private boolean _isActive(Boolean active) {
        if (active == null) {
            return true;
        }
        return active;
    }

    private boolean _isManualMembership(Boolean manualMembership) {
        if (manualMembership == null) {
            return true;
        }
        return manualMembership;
    }

    private Site _toSite(final Group group) {
        return new Site(){
            {
                this.setActive(() -> ((Group)group).getActive());
                this.setDescription(() -> group.getDescription(LocaleUtil.getDefault()));
                this.setDescription_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getDescriptionMap()));
                this.setDescriptiveName(() -> group.getDescriptiveName(LocaleUtil.getDefault()));
                this.setDescriptiveName_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getDescriptiveNameMap()));
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setFriendlyUrlPath(() -> ((Group)group).getFriendlyURL());
                this.setId(() -> ((Group)group).getGroupId());
                this.setKey(() -> ((Group)group).getGroupKey());
                this.setManualMembership(() -> ((Group)group).getManualMembership());
                this.setMembershipRestriction(() -> ((Group)group).getMembershipRestriction());
                this.setMembershipType(() -> Site.MembershipType.create((String)GroupConstants.getTypeLabel((int)group.getType())));
                this.setName(() -> group.getName(LocaleUtil.getDefault()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((Map)group.getNameMap()));
                this.setParentSiteExternalReferenceCode(() -> {
                    Group parentGroup = SiteResourceImpl.this._groupLocalService.fetchGroup(group.getParentGroupId());
                    if (parentGroup != null) {
                        return parentGroup.getExternalReferenceCode();
                    }
                    return "";
                });
                this.setTypeSettings(() -> {
                    UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)group.getTypeSettings()).build();
                    for (String excludedTypeSetting : _EXCLUDED_TYPE_SETTINGS) {
                        unicodeProperties.remove((Object)excludedTypeSetting);
                    }
                    return unicodeProperties;
                });
            }
        };
    }

    private Group _updateGroup(Group group, Site site) throws Exception {
        try {
            Group group2;
            block11: {
                AutoCloseable autoCloseable = this._layoutServiceContextHelper.getServiceContextAutoCloseable(this.contextCompany, this.contextUser);
                try {
                    Group updatedGroup = this._groupLocalService.updateGroup(group.getGroupId(), this._getParentGroupId(group, site.getParentSiteExternalReferenceCode(), site.getParentSiteKey()), this._getNameMap(site), this._getDescriptionMap(site), this._getType(site.getMembershipType()), this._getTypeSettings(site.getTypeSettings(), group.getTypeSettingsProperties()), this._isManualMembership(site.getManualMembership()), this._getMembershipRestriction(site.getMembershipRestriction()), site.getFriendlyUrlPath(), false, this._isActive(site.getActive()), this._getServiceContext());
                    LiveUsers.joinGroup((long)this.contextCompany.getCompanyId(), (long)updatedGroup.getGroupId(), (long)this.contextUser.getUserId());
                    group2 = updatedGroup;
                    if (autoCloseable == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (autoCloseable != null) {
                            try {
                                autoCloseable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        PermissionCacheUtil.clearCache((long[])new long[]{this.contextUser.getUserId()});
                        throw exception;
                    }
                }
                autoCloseable.close();
            }
            return group2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }
}

