/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageSpecificationResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.resource.v1_0.PageSpecificationResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.portal.kernel.exception.LockedLayoutException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-specification.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={PageSpecificationResource.class})
public class PageSpecificationResourceImpl
extends BasePageSpecificationResourceImpl {
    @Reference
    private CETManager _cetManager;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;

    @Override
    public void deleteSitePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._getLayout(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageSpecificationExternalReferenceCode);
        if (!layout.isDraftLayout() || layout.isApproved() && GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"))) {
            throw new UnsupportedOperationException();
        }
        this._discardDraftLayout(layout);
    }

    @Override
    @NestedField(parentClass=DisplayPageTemplate.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteDisplayPageTemplatePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    @NestedField(parentClass=MasterPage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteMasterPagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    public PageSpecification getSitePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._getLayout(GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageSpecificationExternalReferenceCode);
        if (!(layout.isTypeAssetDisplay() || layout.isTypeContent() || layout.isTypePortlet())) {
            throw new UnsupportedOperationException();
        }
        return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout);
    }

    @Override
    @NestedField(parentClass=PageTemplate.class, value="pageSpecifications")
    public Page<PageSpecification> getSitePageTemplatePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String pageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(0, layoutPageTemplateEntry.getType()) && !Objects.equals(2, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    @NestedField(parentClass=SitePage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSitePagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(layout));
    }

    @Override
    @NestedField(parentClass=UtilityPage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteUtilityPagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid())));
    }

    @Override
    public PageSpecification putSitePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, PageSpecification pageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._getLayout(groupId, pageSpecificationExternalReferenceCode);
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setUserId(this.contextUser.getUserId());
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            if (!Objects.equals(pageSpecification.getStatus(), PageSpecification.Status.APPROVED) || !Objects.equals(PageSpecification.Type.WIDGET_PAGE_SPECIFICATION, pageSpecification.getType())) {
                throw new UnsupportedOperationException();
            }
            return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.updateLayout(this._cetManager, this._fragmentEntryProcessorRegistry, this._infoItemServiceRegistry, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), pageSpecification, layout.getStatus(), serviceContext));
        }
        if (!(Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, pageSpecification.getType()) && layout.isDraftLayout() && Objects.equals(pageSpecification.getStatus(), PageSpecification.Status.DRAFT))) {
            throw new UnsupportedOperationException();
        }
        return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.updateLayout(this._cetManager, this._fragmentEntryProcessorRegistry, this._infoItemServiceRegistry, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), pageSpecification, 2, serviceContext));
    }

    @Override
    protected void preparePatch(PageSpecification pageSpecification, PageSpecification existingPageSpecification) {
        if (pageSpecification.getSettings() != null) {
            existingPageSpecification.setSettings(() -> ((PageSpecification)pageSpecification).getSettings());
        }
        if (!Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, existingPageSpecification.getType())) {
            return;
        }
        this._preparePatch((ContentPageSpecification)pageSpecification, (ContentPageSpecification)existingPageSpecification);
    }

    private void _discardDraftLayout(Layout draftLayout) throws Exception {
        block2: {
            Layout layout = this._layoutLocalService.getLayout(draftLayout.getClassPK());
            try {
                boolean published = LayoutUtil.isPublished(layout);
                draftLayout = this._layoutLocalService.copyLayoutContent(layout, draftLayout);
                ServiceContext serviceContext = ServiceContextBuilder.create((long)layout.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build();
                serviceContext.setAttribute("published", (Serializable)Boolean.valueOf(published));
                serviceContext.setUserId(this.contextUser.getUserId());
                this._layoutLocalService.updateStatus(this.contextUser.getUserId(), draftLayout.getPlid(), 0, serviceContext);
            }
            catch (Exception exception) {
                if (exception instanceof LockedLayoutException || exception.getCause() instanceof LockedLayoutException) break block2;
                throw new UnsupportedOperationException();
            }
        }
    }

    private Layout _getLayout(long groupId, String pageSpecificationExternalReferenceCode) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry != null && layoutPageTemplateEntry.getType() == 2) {
            return this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        }
        return this._layoutService.getLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
    }

    private void _preparePatch(ContentPageSpecification contentPageSpecification, ContentPageSpecification existingContentPageSpecification) {
        if (contentPageSpecification.getPageExperiences() != null) {
            existingContentPageSpecification.setPageExperiences(() -> ((ContentPageSpecification)contentPageSpecification).getPageExperiences());
        }
    }

    private List<PageSpecification> _toPageSpecifications(Layout layout) throws Exception {
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            if (!layout.isTypePortlet()) {
                throw new UnsupportedOperationException();
            }
            return ListUtil.fromArray((Object[])new PageSpecification[]{(PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout)});
        }
        return ListUtil.fromArray((Object[])new PageSpecification[]{(PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout), (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)draftLayout)});
    }
}

