/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.fragment.processor.FragmentEntryProcessorRegistry;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.internal.odata.entity.v1_0.MasterPageEntityModel;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseMasterPageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.FileEntryUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PageSpecificationUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.MasterPageResource;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/master-page.properties"}, property={"export.import.vulcan.batch.engine.task.item.delegate=true"}, scope=ServiceScope.PROTOTYPE, service={MasterPageResource.class})
public class MasterPageResourceImpl
extends BaseMasterPageResourceImpl
implements ExportImportVulcanBatchEngineTaskItemDelegate<MasterPage> {
    private static final EntityModel _entityModel = new MasterPageEntityModel();
    @Reference
    private CETManager _cetManager;
    @Reference
    private FragmentEntryProcessorRegistry _fragmentEntryProcessorRegistry;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.MasterPageDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, MasterPage> _masterPageDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference
    private Portal _portal;

    @Override
    public void deleteSiteMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(masterPageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    public ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor getExportImportDescriptor() {
        return new ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor(){

            public String getLabelLanguageKey() {
                return "master-pages";
            }

            public String getModelClassName() {
                return LayoutPageTemplateEntry.class.getName();
            }

            public List<String> getNestedFields() {
                return List.of("friendlyUrlHistory", "pageSpecifications");
            }

            public String getPortletId() {
                return "com_liferay_layout_admin_web_portlet_GroupPagesPortlet";
            }

            public String getResourceClassName() {
                return MasterPageResourceImpl.class.getName();
            }

            public ExportImportVulcanBatchEngineTaskItemDelegate.Scope getScope() {
                return ExportImportVulcanBatchEngineTaskItemDelegate.Scope.SITE;
            }

            public boolean isActive(PortletDataContext portletDataContext) {
                return FeatureFlagManagerUtil.isEnabled((String)"LPD-35443");
            }
        };
    }

    @Override
    public ContentPageSpecification postSiteMasterPagePageSpecification(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(this._cetManager, contentPageSpecification, this._fragmentEntryProcessorRegistry, this._infoItemServiceRegistry, this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutPageTemplateEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    protected MasterPage doGetSiteMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    protected Page<MasterPage> doGetSiteMasterPagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, (Filter)filter, (String)LayoutPageTemplateEntry.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.setAttribute("types", (Serializable)new String[]{String.valueOf(3)});
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
        }, (Sort[])sorts, document -> (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntry(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    protected MasterPage doPostSiteMasterPage(String siteExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._addMasterPage(GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), masterPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MasterPage doPutSiteMasterPage(String siteExternalReferenceCode, String masterPageExternalReferenceCode, MasterPage masterPage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addMasterPage(groupId, masterPage);
        }
        long previewFileEntryId = FileEntryUtil.getPreviewFileEntryId(groupId, masterPage.getThumbnail());
        if (previewFileEntryId != layoutPageTemplateEntry.getPreviewFileEntryId()) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
        }
        Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        ServiceContext serviceContext = this._getServiceContext(groupId, masterPage);
        layout = LayoutUtil.updateContentLayout(this._cetManager, this._fragmentEntryProcessorRegistry, this._infoItemServiceRegistry, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), layout.getTypeSettingsProperties(), masterPage.getPageSpecifications(), serviceContext);
        if (!layoutPageTemplateEntry.isApproved() && layout.isPublished()) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateStatus(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), 0);
        }
        if (!Objects.equals(GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()), layoutPageTemplateEntry.isDefaultTemplate())) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault()));
        }
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        try {
            MasterPage masterPage2 = (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), masterPage.getName()));
            return masterPage2;
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
    }

    @Override
    protected Long getPermissionCheckerResourceId(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(externalReferenceCode, this.getPermissionCheckerGroupId(groupExternalReferenceCode).longValue());
        return layoutPageTemplateEntry.getPrimaryKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        return LayoutPageTemplateEntry.class.getName();
    }

    @Override
    protected void preparePatch(MasterPage masterPage, MasterPage existingMasterPage) {
        if (masterPage.getKeywords() != null) {
            existingMasterPage.setKeywords(() -> ((MasterPage)masterPage).getKeywords());
        }
        if (masterPage.getPageSpecifications() != null) {
            existingMasterPage.setPageSpecifications(() -> ((MasterPage)masterPage).getPageSpecifications());
        }
        if (masterPage.getTaxonomyCategoryItemExternalReferences() != null) {
            existingMasterPage.setTaxonomyCategoryItemExternalReferences(() -> ((MasterPage)masterPage).getTaxonomyCategoryItemExternalReferences());
        }
        if (masterPage.getThumbnail() != null) {
            existingMasterPage.setThumbnail(() -> ((MasterPage)masterPage).getThumbnail());
        }
    }

    private MasterPage _addMasterPage(long groupId, MasterPage masterPage) throws Exception {
        boolean defaultTemplate = false;
        if (GetterUtil.getBoolean((Object)masterPage.getMarkedAsDefault())) {
            defaultTemplate = true;
        }
        ServiceContext serviceContext = this._getServiceContext(groupId, masterPage);
        return (MasterPage)this._masterPageDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(masterPage.getExternalReferenceCode(), groupId, 0L, masterPage.getKey(), 0L, 0L, masterPage.getName(), 3, FileEntryUtil.getPreviewFileEntryId(groupId, masterPage.getThumbnail()), defaultTemplate, 0L, this._getLayoutPlid(groupId, masterPage, serviceContext), 0L, PageSpecificationUtil.getPublishedStatus(masterPage.getPageSpecifications()), serviceContext));
    }

    private long _getLayoutPlid(long groupId, MasterPage masterPage, ServiceContext serviceContext) throws Exception {
        Map<Locale, String> nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), masterPage.getName());
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layout.page.template.entry.type", (Serializable)Integer.valueOf(3));
        Layout layout = LayoutUtil.addContentLayout(this._cetManager, this._fragmentEntryProcessorRegistry, groupId, this._infoItemServiceRegistry, masterPage.getPageSpecifications(), 0L, true, nameMap, null, null, null, null, "content", null, true, true, Collections.emptyMap(), 0, serviceContext);
        return layout.getPlid();
    }

    private ServiceContext _getServiceContext(long groupId, MasterPage masterPage) throws Exception {
        return ServiceContextUtil.createServiceContext(masterPage.getTaxonomyCategoryItemExternalReferences(), this.contextCompany.getCompanyId(), masterPage.getDateCreated(), groupId, this.contextHttpServletRequest, masterPage.getKeywords(), masterPage.getDateModified(), this.contextUser.getUserId(), masterPage.getUuid(), null);
    }
}

