/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ClassNameReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.info.collection.provider.InfoCollectionProvider;
import com.liferay.info.collection.provider.SingleFormVariationInfoCollectionProvider;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Objects;

public class CollectionUtil {
    public static JSONObject getCollectionJSONObject(CollectionReference collectionReference, long companyId, InfoItemServiceRegistry infoItemServiceRegistry, long scopeGroupId) throws Exception {
        if (collectionReference == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        if (collectionReference instanceof ClassNameReference) {
            return CollectionUtil._getClassNameReferenceJSONObject(collectionReference, companyId, infoItemServiceRegistry);
        }
        return CollectionUtil._getCollectionItemExternalReferenceJSONObject(collectionReference, companyId, scopeGroupId);
    }

    public static CollectionReference getCollectionReference(long companyId, JSONObject jsonObject, long scopeGroupId) {
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            return CollectionUtil._toCollectionItemExternalReference(AssetListEntryLocalServiceUtil.fetchAssetListEntry((long)jsonObject.getLong("classPK")), companyId, jsonObject, scopeGroupId);
        }
        String key = jsonObject.getString("key", null);
        if (Validator.isNull((String)key)) {
            return null;
        }
        ClassNameReference classNameReference = new ClassNameReference();
        classNameReference.setClassName(() -> key);
        return classNameReference;
    }

    private static JSONObject _getClassNameReferenceJSONObject(CollectionReference collectionReference, long companyId, InfoItemServiceRegistry infoItemServiceRegistry) {
        if (infoItemServiceRegistry == null) {
            return JSONFactoryUtil.createJSONObject();
        }
        ClassNameReference classNameReference = (ClassNameReference)collectionReference;
        if (Validator.isNull((String)classNameReference.getClassName())) {
            return JSONFactoryUtil.createJSONObject();
        }
        InfoCollectionProvider infoCollectionProvider = (InfoCollectionProvider)infoItemServiceRegistry.getInfoItemService(InfoCollectionProvider.class, classNameReference.getClassName());
        if (infoCollectionProvider == null) {
            LogUtil.logOptionalReference(InfoCollectionProvider.class, classNameReference.getClassName(), companyId);
            return JSONUtil.put((String)"key", (Object)classNameReference.getClassName()).put("type", InfoListProviderItemSelectorReturnType.class.getName());
        }
        return JSONUtil.put((String)"itemSubtype", () -> {
            if (!(infoCollectionProvider instanceof SingleFormVariationInfoCollectionProvider)) {
                return null;
            }
            SingleFormVariationInfoCollectionProvider singleFormVariationInfoCollectionProvider = (SingleFormVariationInfoCollectionProvider)infoCollectionProvider;
            return singleFormVariationInfoCollectionProvider.getFormVariationKey();
        }).put("itemType", infoCollectionProvider.getCollectionItemClassName()).put("key", infoCollectionProvider.getKey()).put("title", () -> infoCollectionProvider.getLabel(LocaleUtil.getDefault())).put("type", InfoListProviderItemSelectorReturnType.class.getName());
    }

    private static JSONObject _getCollectionItemExternalReferenceJSONObject(CollectionReference collectionReference, long companyId, long scopeGroupId) throws Exception {
        CollectionItemExternalReference collectionItemExternalReference = (CollectionItemExternalReference)collectionReference;
        if (Validator.isNull((String)collectionItemExternalReference.getExternalReferenceCode())) {
            return JSONFactoryUtil.createJSONObject();
        }
        Long groupId = ItemScopeUtil.getItemGroupId(companyId, collectionItemExternalReference.getScope(), scopeGroupId);
        if (groupId == null) {
            return CollectionUtil._getCollectionItemExternalReferenceMissingReferenceJSONObject(collectionItemExternalReference, scopeGroupId);
        }
        AssetListEntry assetListEntry = AssetListEntryLocalServiceUtil.fetchAssetListEntryByExternalReferenceCode((String)collectionItemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (assetListEntry == null) {
            return CollectionUtil._getCollectionItemExternalReferenceMissingReferenceJSONObject(collectionItemExternalReference, scopeGroupId);
        }
        return JSONUtil.put((String)"classNameId", (Object)String.valueOf(PortalUtil.getClassNameId(AssetListEntry.class))).put("classPK", assetListEntry.getAssetListEntryId()).put("externalReferenceCode", collectionItemExternalReference.getExternalReferenceCode()).put("itemSubtype", assetListEntry.getAssetEntrySubtype()).put("itemType", assetListEntry.getAssetEntryType()).put("scopeExternalReferenceCode", ItemScopeUtil.getItemScopeExternalReferenceCode(collectionItemExternalReference.getScope(), groupId)).put("title", assetListEntry.getTitle()).put("type", InfoListItemSelectorReturnType.class.getName());
    }

    private static JSONObject _getCollectionItemExternalReferenceMissingReferenceJSONObject(CollectionItemExternalReference collectionItemExternalReference, long groupId) throws Exception {
        LogUtil.logOptionalReference(collectionItemExternalReference.getClassName(), collectionItemExternalReference.getExternalReferenceCode(), collectionItemExternalReference.getScope(), groupId);
        return JSONUtil.put((String)"externalReferenceCode", (Object)collectionItemExternalReference.getExternalReferenceCode()).put("scopeExternalReferenceCode", ItemScopeUtil.getItemScopeExternalReferenceCode(collectionItemExternalReference.getScope(), groupId)).put("type", InfoListItemSelectorReturnType.class.getName());
    }

    private static CollectionItemExternalReference _toCollectionItemExternalReference(AssetListEntry assetListEntry, long companyId, JSONObject jsonObject, long scopeGroupId) {
        CollectionItemExternalReference collectionItemExternalReference = new CollectionItemExternalReference();
        if (assetListEntry != null) {
            collectionItemExternalReference.setExternalReferenceCode(() -> ((AssetListEntry)assetListEntry).getExternalReferenceCode());
            collectionItemExternalReference.setScope(() -> ItemScopeUtil.getItemScope(assetListEntry.getGroupId(), scopeGroupId));
            return collectionItemExternalReference;
        }
        String externalReferenceCode = jsonObject.getString("externalReferenceCode");
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        collectionItemExternalReference.setExternalReferenceCode(() -> externalReferenceCode);
        collectionItemExternalReference.setScope(() -> ItemScopeUtil.getItemScope(companyId, jsonObject.getString("scopeExternalReferenceCode"), scopeGroupId));
        return collectionItemExternalReference;
    }
}

