/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.admin.site.dto.v1_0.ClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.FavIcon;
import com.liferay.headless.admin.site.dto.v1_0.FavIconClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.FavIconItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSection;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageWidgetInstance;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.segments.service.SegmentsExperienceService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class PageSpecificationDTOConverter
implements DTOConverter<Layout, PageSpecification> {
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageExperienceDTOConverter)")
    private DTOConverter<LayoutPageTemplateStructureRel, PageExperience> _pageExperienceDTOConverter;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.WidgetPageWidgetInstanceDTOConverter)")
    private DTOConverter<Layout, WidgetPageWidgetInstance> _widgetPageWidgetInstanceDTOConverter;

    public String getContentType() {
        return PageSpecification.class.getSimpleName();
    }

    public PageSpecification toDTO(DTOConverterContext dtoConverterContext, Layout layout) throws Exception {
        if (layout.isTypeAssetDisplay() || layout.isTypeContent()) {
            return this._toContentPageSpecification(dtoConverterContext, layout);
        }
        if (dtoConverterContext == null) {
            dtoConverterContext = new DefaultDTOConverterContext(null, null, null, null, null);
        }
        return this._toWidgetPageSpecification(dtoConverterContext, layout);
    }

    private ClientExtension _getClientExtension(final ClientExtensionEntryRel clientExtensionEntryRel) {
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return new ClientExtension(){
            {
                this.setClientExtensionConfig(() -> PageSpecificationDTOConverter.this._getClientExtensionConfig(clientExtensionEntryRel));
                this.setExternalReferenceCode(() -> ((ClientExtensionEntryRel)clientExtensionEntryRel).getCETExternalReferenceCode());
            }
        };
    }

    private ClientExtension _getClientExtension(long classNameId, long classPK, String type) {
        return this._getClientExtension(this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, type));
    }

    private Map<String, String> _getClientExtensionConfig(ClientExtensionEntryRel clientExtensionEntryRel) {
        if (clientExtensionEntryRel == null) {
            return null;
        }
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.fastLoad((String)clientExtensionEntryRel.getTypeSettings()).build();
        if (unicodeProperties.isEmpty()) {
            return null;
        }
        HashMap<String, String> clientExtensionConfig = new HashMap<String, String>();
        for (Map.Entry entry : unicodeProperties.entrySet()) {
            clientExtensionConfig.put((String)entry.getKey(), (String)entry.getValue());
        }
        return clientExtensionConfig;
    }

    private ClientExtension[] _getClientExtensions(long classNameId, long classPK, String type) {
        Object[] clientExtensions = (ClientExtension[])TransformUtil.transformToArray((Collection)this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(classNameId, classPK, type), clientExtensionEntryRel -> this._getClientExtension((ClientExtensionEntryRel)clientExtensionEntryRel), ClientExtension.class);
        if (ArrayUtil.isEmpty((Object[])clientExtensions)) {
            return null;
        }
        return clientExtensions;
    }

    private PageExperience[] _getPageExperiences(DTOConverterContext dtoConverterContext, Layout layout) throws Exception {
        return (PageExperience[])TransformUtil.transformToArray((Collection)this._segmentsExperienceService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true), segmentsExperience -> {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(segmentsExperience.getGroupId(), layout.getPlid());
            LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperience.getSegmentsExperienceId());
            if (layoutPageTemplateStructureRel == null) {
                throw new UnsupportedOperationException();
            }
            return (PageExperience)this._pageExperienceDTOConverter.toDTO(dtoConverterContext, (Object)layoutPageTemplateStructureRel);
        }, PageExperience.class);
    }

    private Settings _getSettings(final Layout layout) throws Exception {
        final long classNameId = this._portal.getClassNameId(Layout.class.getName());
        final UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setColorSchemeName(() -> {
                    if (Validator.isNull((String)layout.getColorSchemeId())) {
                        return null;
                    }
                    return layout.getColorSchemeId();
                });
                this.setCss(() -> {
                    if (Validator.isNull((String)layout.getCss())) {
                        return null;
                    }
                    return layout.getCss();
                });
                this.setFavIcon(() -> {
                    final ClientExtension clientExtension = PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeFavicon");
                    if (clientExtension != null) {
                        return new FavIconClientExtension(){
                            {
                                this.setClientExtensionConfig(() -> ((ClientExtension)clientExtension).getClientExtensionConfig());
                                this.setExternalReferenceCode(() -> ((ClientExtension)clientExtension).getExternalReferenceCode());
                                this.setFavIconType(() -> FavIcon.FavIconType.CLIENT_EXTENSION);
                            }
                        };
                    }
                    long faviconFileEntryId = layout.getFaviconFileEntryId();
                    if (faviconFileEntryId == 0L) {
                        return null;
                    }
                    final FileEntry fileEntry = PageSpecificationDTOConverter.this._dlAppService.getFileEntry(faviconFileEntryId);
                    if (fileEntry == null) {
                        return null;
                    }
                    return new FavIconItemExternalReference(){
                        {
                            this.setClassName(FileEntry.class::getName);
                            this.setExternalReferenceCode(() -> ((FileEntry)fileEntry).getExternalReferenceCode());
                            this.setFavIconType(() -> FavIcon.FavIconType.ITEM_EXTERNAL_REFERENCE);
                            this.setScope(() -> ItemScopeUtil.getItemScope(fileEntry.getGroupId(), layout.getGroupId()));
                        }
                    };
                });
                this.setGlobalCSSClientExtensions(() -> PageSpecificationDTOConverter.this._getClientExtensions(classNameId, layout.getPlid(), "globalCSS"));
                this.setGlobalJSClientExtensions(() -> PageSpecificationDTOConverter.this._getClientExtensions(classNameId, layout.getPlid(), "globalJS"));
                this.setJavascript(() -> unicodeProperties.getProperty("javascript", null));
                this.setMasterPageItemExternalReference(() -> {
                    if (Validator.isNull((String)layout.getMasterLayoutPageTemplateEntryERC())) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setExternalReferenceCode(() -> ((Layout)layout).getMasterLayoutPageTemplateEntryERC());
                        }
                    };
                });
                this.setStyleBookItemExternalReference(() -> {
                    if (Validator.isNull((String)layout.getStyleBookEntryERC())) {
                        return null;
                    }
                    return new ItemExternalReference(){
                        {
                            this.setExternalReferenceCode(() -> ((Layout)layout).getStyleBookEntryERC());
                        }
                    };
                });
                this.setThemeCSSClientExtension(() -> PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeCSS"));
                this.setThemeName(() -> {
                    if (Validator.isNull((String)layout.getThemeId())) {
                        return null;
                    }
                    return layout.getThemeId();
                });
                this.setThemeSettings(() -> {
                    HashMap<String, String> themeSettings = new HashMap<String, String>();
                    for (String key : unicodeProperties.keySet()) {
                        if (!key.startsWith("lfr-theme:")) continue;
                        themeSettings.put(key, unicodeProperties.getProperty(key, null));
                    }
                    if (MapUtil.isEmpty(themeSettings)) {
                        return null;
                    }
                    return themeSettings;
                });
                this.setThemeSpritemapClientExtension(() -> PageSpecificationDTOConverter.this._getClientExtension(classNameId, layout.getPlid(), "themeSpritemap"));
            }
        };
    }

    private WidgetPageSection[] _getWidgetPageSections(DTOConverterContext dtoConverterContext, Layout layout) {
        final LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return (WidgetPageSection[])TransformUtil.transformToArray((Collection)layoutTypePortlet.getColumns(), column -> new WidgetPageSection((String)column, dtoConverterContext, layout){
            final /* synthetic */ String val$column;
            final /* synthetic */ DTOConverterContext val$dtoConverterContext;
            final /* synthetic */ Layout val$layout;
            {
                this.val$column = string;
                this.val$dtoConverterContext = dTOConverterContext;
                this.val$layout = layout;
                this.setCustomizable(() -> layoutTypePortlet.isColumnCustomizable(this.val$column));
                this.setId(() -> this.val$column);
                this.setWidgetPageWidgetInstances(() -> PageSpecificationDTOConverter.this._getWidgetPageWidgetInstances(this.val$column, this.val$dtoConverterContext, this.val$layout));
            }
        }, WidgetPageSection.class);
    }

    private WidgetPageWidgetInstance[] _getWidgetPageWidgetInstances(String column, DTOConverterContext dtoConverterContext, Layout layout) {
        return (WidgetPageWidgetInstance[])TransformUtil.transformToArray((Collection)StringUtil.split((String)layout.getTypeSettingsProperty(column)), portletId -> {
            dtoConverterContext.setAttribute("portletId", portletId);
            return (WidgetPageWidgetInstance)this._widgetPageWidgetInstanceDTOConverter.toDTO(dtoConverterContext, (Object)layout);
        }, WidgetPageWidgetInstance.class);
    }

    private PageSpecification _toContentPageSpecification(final DTOConverterContext dtoConverterContext, final Layout layout) {
        return new ContentPageSpecification(){
            {
                this.setCustomFields(() -> {
                    if (layout.isTypeUtility()) {
                        return null;
                    }
                    return CustomFieldsUtil.toCustomFields((boolean)true, (String)Layout.class.getName(), (long)layout.getPlid(), (long)layout.getCompanyId(), null);
                });
                this.setDraftContentPageSpecificationExternalReferenceCode(() -> {
                    Layout draftLayout = layout.fetchDraftLayout();
                    if (draftLayout == null) {
                        return null;
                    }
                    return draftLayout.getExternalReferenceCode();
                });
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setPageExperiences(() -> PageSpecificationDTOConverter.this._getPageExperiences(dtoConverterContext, layout));
                this.setSettings(() -> PageSpecificationDTOConverter.this._getSettings(layout));
                this.setSiteTemplatePageSpecificationExternalReferenceCode(() -> {
                    Layout layoutSetPrototypeLayout = layout.getLayoutSetPrototypeLayout();
                    if (layoutSetPrototypeLayout == null) {
                        return null;
                    }
                    return layoutSetPrototypeLayout.getExternalReferenceCode();
                });
                this.setStatus(() -> {
                    if (layout.isDraftLayout()) {
                        if (layout.isApproved()) {
                            return PageSpecification.Status.APPROVED;
                        }
                        return PageSpecification.Status.DRAFT;
                    }
                    if (LayoutUtil.isPublished(layout)) {
                        return PageSpecification.Status.APPROVED;
                    }
                    return PageSpecification.Status.DRAFT;
                });
                this.setType(() -> PageSpecification.Type.CONTENT_PAGE_SPECIFICATION);
            }
        };
    }

    private PageSpecification _toWidgetPageSpecification(final DTOConverterContext dtoConverterContext, final Layout layout) {
        return new WidgetPageSpecification(){
            {
                this.setCustomFields(() -> CustomFieldsUtil.toCustomFields((boolean)true, (String)Layout.class.getName(), (long)layout.getPlid(), (long)layout.getCompanyId(), null));
                this.setExternalReferenceCode(() -> {
                    LayoutPageTemplateEntry layoutPageTemplateEntry = PageSpecificationDTOConverter.this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
                    if (layoutPageTemplateEntry == null || layoutPageTemplateEntry.getType() != 2) {
                        return layout.getExternalReferenceCode();
                    }
                    return layoutPageTemplateEntry.getExternalReferenceCode();
                });
                this.setSettings(() -> PageSpecificationDTOConverter.this._getSettings(layout));
                this.setSiteTemplatePageSpecificationExternalReferenceCode(() -> {
                    Layout layoutSetPrototypeLayout = layout.getLayoutSetPrototypeLayout();
                    if (layoutSetPrototypeLayout == null) {
                        return null;
                    }
                    return layoutSetPrototypeLayout.getExternalReferenceCode();
                });
                this.setStatus(() -> PageSpecification.Status.APPROVED);
                this.setType(() -> PageSpecification.Type.WIDGET_PAGE_SPECIFICATION);
                this.setWidgetPageSections(() -> PageSpecificationDTOConverter.this._getWidgetPageSections(dtoConverterContext, layout));
            }
        };
    }
}

