/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.GridPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.GridViewport;
import com.liferay.headless.admin.site.dto.v1_0.GridViewportDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ViewportIdUtil;
import com.liferay.layout.converter.VerticalAlignmentConverter;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.RowStyledLayoutStructureItem"}, service={DTOConverter.class})
public class GridPageElementDefinitionDTOConverter
implements DTOConverter<RowStyledLayoutStructureItem, GridPageElementDefinition> {
    public String getContentType() {
        return GridPageElementDefinition.class.getSimpleName();
    }

    public GridPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final RowStyledLayoutStructureItem rowStyledLayoutStructureItem) throws Exception {
        Long scopeGroupId = (Long)dtoConverterContext.getAttribute("scopeGroupId");
        if (scopeGroupId == null) {
            throw new UnsupportedOperationException();
        }
        return new GridPageElementDefinition(){
            {
                this.setCssClasses(() -> {
                    Set cssClasses = rowStyledLayoutStructureItem.getCssClasses();
                    if (SetUtil.isEmpty((Set)cssClasses)) {
                        return null;
                    }
                    return ArrayUtil.toStringArray((Collection)cssClasses);
                });
                this.setCustomCSS(() -> {
                    String customCSS = rowStyledLayoutStructureItem.getCustomCSS();
                    if (Validator.isNotNull((String)customCSS)) {
                        return customCSS;
                    }
                    return null;
                });
                this.setGridViewports(() -> GridPageElementDefinitionDTOConverter.this._toGridViewports(rowStyledLayoutStructureItem));
                this.setGutters(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).isGutters());
                this.setIndexed(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).isIndexed());
                this.setModulesPerRow(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).getModulesPerRow());
                this.setName(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).getName());
                this.setNumberOfModules(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).getNumberOfColumns());
                this.setReverseOrder(() -> ((RowStyledLayoutStructureItem)rowStyledLayoutStructureItem).isReverseOrder());
                this.setType(PageElementDefinition.Type.GRID);
                this.setVerticalAlignment(() -> {
                    String itemVerticalAlignment = rowStyledLayoutStructureItem.getVerticalAlignment();
                    if (Validator.isNull((String)itemVerticalAlignment)) {
                        return null;
                    }
                    return GridPageElementDefinition.VerticalAlignment.create((String)VerticalAlignmentConverter.convertToExternalValue((String)itemVerticalAlignment));
                });
            }
        };
    }

    private GridViewport _toGridViewport(final GridViewport.Id gridViewportId, JSONObject jsonObject) {
        String viewportId = ViewportIdUtil.toInternalValue(gridViewportId.getValue());
        if (!jsonObject.has(viewportId)) {
            return null;
        }
        final JSONObject viewportJSONObject = jsonObject.getJSONObject(viewportId);
        if (JSONUtil.isEmpty((JSONObject)viewportJSONObject)) {
            return null;
        }
        return new GridViewport(){
            {
                this.setCustomCSS(() -> viewportJSONObject.getString("customCSS"));
                this.setGridViewportDefinition(() -> GridPageElementDefinitionDTOConverter.this._toGridViewportDefinition(viewportJSONObject));
                this.setId(() -> gridViewportId);
            }
        };
    }

    private GridViewportDefinition _toGridViewportDefinition(final JSONObject rowViewportConfigurationJSONObject) {
        return new GridViewportDefinition(){
            {
                this.setModulesPerRow(() -> {
                    if (!rowViewportConfigurationJSONObject.has("modulesPerRow")) {
                        return null;
                    }
                    return rowViewportConfigurationJSONObject.getInt("modulesPerRow");
                });
                this.setVerticalAlignment(() -> {
                    String itemVerticalAlignment = rowViewportConfigurationJSONObject.getString("verticalAlignment");
                    if (Validator.isNull((String)itemVerticalAlignment)) {
                        return null;
                    }
                    return GridViewportDefinition.VerticalAlignment.create((String)VerticalAlignmentConverter.convertToExternalValue((String)itemVerticalAlignment));
                });
            }
        };
    }

    private GridViewport[] _toGridViewports(final RowStyledLayoutStructureItem rowStyledLayoutStructureItem) {
        ArrayList<GridViewport> gridViewports = new ArrayList<GridViewport>(){
            {
                GridViewport gridViewport = GridPageElementDefinitionDTOConverter.this._toGridViewport(GridViewport.Id.LANDSCAPE_MOBILE, rowStyledLayoutStructureItem.getItemConfigJSONObject());
                if (gridViewport != null) {
                    this.add(gridViewport);
                }
                if ((gridViewport = GridPageElementDefinitionDTOConverter.this._toGridViewport(GridViewport.Id.PORTRAIT_MOBILE, rowStyledLayoutStructureItem.getItemConfigJSONObject())) != null) {
                    this.add(gridViewport);
                }
                if ((gridViewport = GridPageElementDefinitionDTOConverter.this._toGridViewport(GridViewport.Id.TABLET, rowStyledLayoutStructureItem.getItemConfigJSONObject())) != null) {
                    this.add(gridViewport);
                }
            }
        };
        return gridViewports.toArray(new GridViewport[0]);
    }
}

