/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateFolder;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateOpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.SitemapSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ThumbnailUtil;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.page.template.model.LayoutPageTemplateEntry"}, service={DTOConverter.class})
public class DisplayPageTemplateDTOConverter
implements DTOConverter<LayoutPageTemplateEntry, DisplayPageTemplate> {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.DisplayPageTemplateFolderDTOConverter)")
    private DTOConverter<LayoutPageTemplateCollection, DisplayPageTemplateFolder> _displayPageTemplateFolderDTOConverter;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return DisplayPageTemplate.class.getSimpleName();
    }

    public DisplayPageTemplate toDTO(DTOConverterContext dtoConverterContext, final LayoutPageTemplateEntry layoutPageTemplateEntry) throws Exception {
        final Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        return new DisplayPageTemplate(){
            {
                this.setContentTypeReference(() -> new ClassSubtypeReference(){
                    {
                        this.setClassName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getClassName());
                        this.setSubTypeExternalReference(() -> DisplayPageTemplateDTOConverter.this._getSubtypeItemExternalReference(layoutPageTemplateEntry));
                    }
                });
                this.setCreator(() -> {
                    final User user = DisplayPageTemplateDTOConverter.this._userLocalService.fetchUser(layoutPageTemplateEntry.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setDateCreated(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getCreateDate());
                this.setDateModified(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setDisplayPageTemplateSettings(() -> new DisplayPageTemplateSettings(){
                    {
                        this.setOpenGraphSettings(() -> DisplayPageTemplateDTOConverter.this._getDisplayPageTemplateOpenGraphSettings(layout));
                        this.setSeoSettings(() -> DisplayPageTemplateDTOConverter.this._getDisplayPageTemplateSEOSettings(layout));
                    }
                });
                this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setKey(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getLayoutPageTemplateEntryKey());
                this.setMarkedAsDefault(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).isDefaultTemplate());
                this.setName(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getName());
                this.setParentFolder(() -> {
                    LayoutPageTemplateCollection layoutPageTemplateCollection = DisplayPageTemplateDTOConverter.this._layoutPageTemplateCollectionLocalService.fetchLayoutPageTemplateCollection(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId());
                    if (layoutPageTemplateCollection == null) {
                        return null;
                    }
                    return (DisplayPageTemplateFolder)DisplayPageTemplateDTOConverter.this._displayPageTemplateFolderDTOConverter.toDTO((Object)layoutPageTemplateCollection);
                });
                this.setThumbnail(() -> ThumbnailUtil.getPortletFileEntryItemExternalReference(layoutPageTemplateEntry.getPreviewFileEntryId()));
                this.setUuid(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getUuid());
            }
        };
    }

    private DisplayPageTemplateOpenGraphSettings _getDisplayPageTemplateOpenGraphSettings(final Layout layout) {
        return new DisplayPageTemplateOpenGraphSettings(){
            {
                this.setDescriptionTemplate(() -> layout.getTypeSettingsProperty("mapped-openGraphDescription"));
                this.setImageAltTemplate(() -> layout.getTypeSettingsProperty("mapped-openGraphImageAlt"));
                this.setImageTemplate(() -> layout.getTypeSettingsProperty("mapped-openGraphImage"));
                this.setTitleTemplate(() -> layout.getTypeSettingsProperty("mapped-openGraphTitle"));
            }
        };
    }

    private DisplayPageTemplateSEOSettings _getDisplayPageTemplateSEOSettings(final Layout layout) {
        return new DisplayPageTemplateSEOSettings(){
            {
                this.setDescriptionTemplate(() -> layout.getTypeSettingsProperty("mapped-description"));
                this.setHtmlTitleTemplate(() -> layout.getTypeSettingsProperty("mapped-title"));
                this.setRobots_i18n(() -> {
                    Map robotsMap = layout.getRobotsMap();
                    if (robotsMap.isEmpty()) {
                        return null;
                    }
                    return LocalizedMapUtil.getI18nMap((boolean)true, (Map)robotsMap);
                });
                this.setSitemapSettings(() -> DisplayPageTemplateDTOConverter.this._getSitemapSettings(layout));
            }
        };
    }

    private SitemapSettings _getSitemapSettings(final Layout layout) {
        return new SitemapSettings(){
            {
                this.setChangeFrequency(() -> SitemapSettings.ChangeFrequency.create((String)StringUtil.upperCaseFirstLetter((String)layout.getTypeSettingsProperty("sitemap-changefreq"))));
                this.setInclude(() -> {
                    String include = GetterUtil.getString((String)layout.getTypeSettingsProperty("sitemap-include"));
                    if (Validator.isNull((String)include)) {
                        return null;
                    }
                    return Objects.equals(include, "1");
                });
                this.setPagePriority(() -> {
                    double pagePriority = GetterUtil.getDouble((String)layout.getTypeSettingsProperty("sitemap-priority"), (double)-1.0);
                    if (pagePriority == -1.0) {
                        return null;
                    }
                    return pagePriority;
                });
            }
        };
    }

    private ItemExternalReference _getSubtypeItemExternalReference(LayoutPageTemplateEntry layoutPageTemplateEntry) {
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, layoutPageTemplateEntry.getClassName());
        if (infoItemFormVariationsProvider == null) {
            return null;
        }
        final InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariation(layoutPageTemplateEntry.getGroupId(), String.valueOf(layoutPageTemplateEntry.getClassTypeId()));
        if (infoItemFormVariation == null) {
            return null;
        }
        return new ItemExternalReference(){
            {
                this.setExternalReferenceCode(() -> ((InfoItemFormVariation)infoItemFormVariation).getExternalReferenceCode());
            }
        };
    }
}

