/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.CustomMetaTag;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.AssetUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.NavigationSettingsUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.OpenGraphSettingsUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.SEOSettingsUtil;
import com.liferay.headless.admin.user.dto.v1_0.Creator;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntry;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTag;
import com.liferay.layout.seo.service.LayoutSEOEntryLocalService;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class SitePageDTOConverter
implements DTOConverter<Layout, SitePage> {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPrototypeLocalService _layoutPrototypeLocalService;
    @Reference
    private LayoutSEOEntryLocalService _layoutSEOEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return SitePage.class.getSimpleName();
    }

    public SitePage toDTO(DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        return new SitePage(){
            {
                this.setAvailableLanguages(() -> LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds()));
                this.setCreator(() -> {
                    final User user = SitePageDTOConverter.this._userLocalService.fetchUser(layout.getUserId());
                    if (user == null) {
                        return null;
                    }
                    return new Creator(){
                        {
                            this.setExternalReferenceCode(() -> ((User)user).getExternalReferenceCode());
                        }
                    };
                });
                this.setDateCreated(() -> ((Layout)layout).getCreateDate());
                this.setDateModified(() -> ((Layout)layout).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setKeywords(() -> AssetUtil.getKeywords(Layout.class.getName(), layout.getPlid()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getNameMap()));
                this.setPageSettings(() -> SitePageDTOConverter.this._toPageSettings(layout));
                this.setParentSitePageExternalReferenceCode(() -> {
                    if (layout.getParentLayoutId() == 0L) {
                        return null;
                    }
                    Layout parentLayout = SitePageDTOConverter.this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
                    return parentLayout.getExternalReferenceCode();
                });
                this.setTaxonomyCategoryItemExternalReferences(() -> AssetUtil.getTaxonomyCategoryItemExternalReferences(Layout.class.getName(), layout.getPlid(), layout.getGroupId()));
                this.setType(() -> SitePageTypeUtil.toExternalType(layout.getType()));
                this.setUuid(() -> ((Layout)layout).getUuid());
            }
        };
    }

    private CustomMetaTag[] _getCustomMetaTags(Layout layout, LayoutSEOEntryLocalService layoutSEOEntryLocalService) {
        LayoutSEOEntry layoutSEOEntry = layoutSEOEntryLocalService.fetchLayoutSEOEntry(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId());
        if (layoutSEOEntry == null) {
            return null;
        }
        List layoutSEOEntryCustomMetaTags = layoutSEOEntryLocalService.getLayoutSEOEntryCustomMetaTags(layoutSEOEntry.getGroupId(), layoutSEOEntry.getLayoutSEOEntryId());
        ArrayList<2> customMetaTags = new ArrayList<2>();
        for (final LayoutSEOEntryCustomMetaTag layoutSEOEntryCustomMetaTag : layoutSEOEntryCustomMetaTags) {
            customMetaTags.add(new CustomMetaTag(){
                {
                    this.setKey(() -> ((LayoutSEOEntryCustomMetaTag)layoutSEOEntryCustomMetaTag).getProperty());
                    this.setValue_i18n(() -> LocalizedMapUtil.getI18nMap((Map)layoutSEOEntryCustomMetaTag.getContentMap()));
                }
            });
        }
        return customMetaTags.toArray(new CustomMetaTag[0]);
    }

    private PageSettings _getPageSettings(Layout layout) {
        SitePage.Type type = SitePageTypeUtil.toExternalType(layout.getType());
        if (type == SitePage.Type.CONTENT_PAGE) {
            return new ContentPageSettings();
        }
        return this._toWidgetPageSettings(layout);
    }

    private PageSettings _toPageSettings(Layout layout) {
        PageSettings pageSettings = this._getPageSettings(layout);
        pageSettings.setCustomMetaTags(() -> this._getCustomMetaTags(layout, this._layoutSEOEntryLocalService));
        pageSettings.setHiddenFromNavigation(() -> ((Layout)layout).isHidden());
        pageSettings.setNavigationSettings(() -> NavigationSettingsUtil.toSitePageNavigationSettings(layout.getTypeSettingsProperties()));
        pageSettings.setOpenGraphSettings(() -> OpenGraphSettingsUtil.getOpenGraphSettings(this._dlAppService, this._layoutSEOEntryLocalService, layout));
        pageSettings.setPriority(() -> ((Layout)layout).getPriority());
        pageSettings.setSeoSettings(() -> SEOSettingsUtil.getSeoSettings(this._layoutSEOEntryLocalService, layout));
        return pageSettings;
    }

    private WidgetPageSettings _toWidgetPageSettings(final Layout layout) {
        WidgetPageSettings widgetPageSettings = new WidgetPageSettings();
        widgetPageSettings.setCustomizable(() -> ((Layout)layout).isCustomizable());
        widgetPageSettings.setCustomizableSectionIds(() -> {
            ArrayList customizableSectionIds = new ArrayList();
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)layout.getTypeSettings()).build();
            typeSettingsUnicodeProperties.forEach((key, value) -> {
                if (key.contains("-customizable") && Objects.equals(value, "true")) {
                    customizableSectionIds.add(key.substring(0, key.indexOf("-customizable")));
                }
            });
            List sortedCustomizableSectionIds = ListUtil.sort(customizableSectionIds);
            return sortedCustomizableSectionIds.toArray(new String[0]);
        });
        widgetPageSettings.setLayoutTemplateId(() -> layout.getTypeSettingsProperty("layout-template-id"));
        widgetPageSettings.setWidgetPageTemplateReference(() -> {
            if (layout.getLayoutPrototypeUuid() == null) {
                return null;
            }
            LayoutPrototype layoutPrototype = this._layoutPrototypeLocalService.fetchLayoutPrototypeByUuidAndCompanyId(layout.getLayoutPrototypeUuid(), layout.getCompanyId());
            if (layoutPrototype == null) {
                return null;
            }
            final LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchFirstLayoutPageTemplateEntry(layoutPrototype.getLayoutPrototypeId());
            if (layoutPageTemplateEntry == null) {
                return null;
            }
            widgetPageSettings.setInheritChanges(() -> ((Layout)layout).isLayoutPrototypeLinkEnabled());
            return new ItemExternalReference(){
                {
                    this.setExternalReferenceCode(() -> ((LayoutPageTemplateEntry)layoutPageTemplateEntry).getExternalReferenceCode());
                    this.setScope(() -> ItemScopeUtil.getItemScope(layoutPageTemplateEntry.getGroupId(), layout.getGroupId()));
                }
            };
        });
        return widgetPageSettings;
    }
}

