/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.fragment.contributor.FragmentCollectionContributorRegistry;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.fragment.service.FragmentEntryLocalService;
import com.liferay.headless.admin.site.dto.v1_0.DefaultFragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.FragmentReference;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem"}, service={DTOConverter.class})
public class FragmentInstancePageElementDefinitionDTOConverter
implements DTOConverter<FragmentStyledLayoutStructureItem, FragmentInstancePageElementDefinition> {
    @Reference
    private FragmentCollectionContributorRegistry _fragmentCollectionContributorRegistry;
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private FragmentEntryLocalService _fragmentEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public String getContentType() {
        return FragmentInstancePageElementDefinition.class.getSimpleName();
    }

    public FragmentInstancePageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem) throws Exception {
        final FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            throw new UnsupportedOperationException();
        }
        return new FragmentInstancePageElementDefinition(){
            {
                this.setConfiguration(() -> ((FragmentEntryLink)fragmentEntryLink).getConfiguration());
                this.setCss(() -> ((FragmentEntryLink)fragmentEntryLink).getCss());
                this.setCssClasses(() -> {
                    if (SetUtil.isEmpty((Set)fragmentStyledLayoutStructureItem.getCssClasses())) {
                        return null;
                    }
                    return ArrayUtil.toStringArray((Collection)fragmentStyledLayoutStructureItem.getCssClasses());
                });
                this.setCustomCSS(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getCustomCSS());
                this.setDatePropagated(() -> ((FragmentEntryLink)fragmentEntryLink).getLastPropagationDate());
                this.setDraftFragmentInstanceExternalReferenceCode(() -> FragmentInstancePageElementDefinitionDTOConverter.this._getDraftFragmentInstanceExternalReferenceCode(fragmentEntryLink));
                this.setFragmentInstanceExternalReferenceCode(() -> ((FragmentEntryLink)fragmentEntryLink).getExternalReferenceCode());
                this.setFragmentReference(() -> {
                    final FragmentEntry fragmentEntry = FragmentInstancePageElementDefinitionDTOConverter.this._fragmentEntryLocalService.fetchFragmentEntryByExternalReferenceCode(fragmentEntryLink.getFragmentEntryERC(), fragmentEntryLink.getFragmentEntryGroupId());
                    if (fragmentEntry != null) {
                        return new FragmentItemExternalReference(){
                            {
                                this.setExternalReferenceCode(() -> ((FragmentEntry)fragmentEntry).getExternalReferenceCode());
                                this.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.FRAGMENT_ITEM_EXTERNAL_REFERENCE);
                                this.setScope(() -> {
                                    if (fragmentEntry.getGroupId() == fragmentEntryLink.getGroupId()) {
                                        return null;
                                    }
                                    final Group group = FragmentInstancePageElementDefinitionDTOConverter.this._groupLocalService.getGroup(fragmentEntry.getGroupId());
                                    return new Scope(){
                                        {
                                            this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                                            this.setType(() -> Scope.Type.SITE);
                                        }
                                    };
                                });
                            }
                        };
                    }
                    Map fragmentEntries = FragmentInstancePageElementDefinitionDTOConverter.this._fragmentCollectionContributorRegistry.getFragmentEntries();
                    if (!fragmentEntries.containsKey(fragmentEntryLink.getRendererKey())) {
                        return null;
                    }
                    return new DefaultFragmentReference(){
                        {
                            this.setDefaultFragmentKey(() -> ((FragmentEntryLink)fragmentEntryLink).getRendererKey());
                            this.setFragmentReferenceType(() -> FragmentReference.FragmentReferenceType.DEFAULT_FRAGMENT_REFERENCE);
                        }
                    };
                });
                this.setFragmentType(() -> {
                    if (fragmentEntryLink.isTypeComponent()) {
                        return FragmentInstancePageElementDefinition.FragmentType.BASIC;
                    }
                    return FragmentInstancePageElementDefinition.FragmentType.FORM;
                });
                this.setHtml(() -> ((FragmentEntryLink)fragmentEntryLink).getHtml());
                this.setIndexed(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).isIndexed());
                this.setJs(() -> ((FragmentEntryLink)fragmentEntryLink).getJs());
                this.setName(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getName());
                this.setNamespace(() -> ((FragmentEntryLink)fragmentEntryLink).getNamespace());
                this.setType(PageElementDefinition.Type.FRAGMENT);
                this.setUuid(() -> ((FragmentEntryLink)fragmentEntryLink).getUuid());
            }
        };
    }

    private String _getDraftFragmentInstanceExternalReferenceCode(FragmentEntryLink fragmentEntryLink) {
        String originalFragmentEntryLinkERC = fragmentEntryLink.getOriginalFragmentEntryLinkERC();
        if (Validator.isNull((String)originalFragmentEntryLinkERC)) {
            return null;
        }
        FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLinkByExternalReferenceCode(originalFragmentEntryLinkERC, fragmentEntryLink.getGroupId());
        if (originalFragmentEntryLink == null) {
            return null;
        }
        return originalFragmentEntryLink.getExternalReferenceCode();
    }
}

