/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.FormConfig;
import com.liferay.headless.admin.site.dto.v1_0.FormPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.delivery.dto.v1_0.ClassTypeReference;
import com.liferay.headless.delivery.dto.v1_0.ContextReference;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FormStyledLayoutStructureItem"}, service={DTOConverter.class})
public class FormPageElementDefinitionDTOConverter
implements DTOConverter<FormStyledLayoutStructureItem, FormPageElementDefinition> {
    public String getContentType() {
        return FormPageElementDefinition.class.getSimpleName();
    }

    public FormPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final FormStyledLayoutStructureItem formStyledLayoutStructureItem) throws Exception {
        return new FormPageElementDefinition(){
            {
                this.setCssClasses(() -> {
                    if (SetUtil.isEmpty((Set)formStyledLayoutStructureItem.getCssClasses())) {
                        return null;
                    }
                    return ArrayUtil.toStringArray((Collection)formStyledLayoutStructureItem.getCssClasses());
                });
                this.setCustomCSS(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getCustomCSS());
                this.setFormConfig(() -> FormPageElementDefinitionDTOConverter.this._toFormConfig(formStyledLayoutStructureItem));
                this.setIndexed(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).isIndexed());
                this.setName(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getName());
                this.setType(PageElementDefinition.Type.FORM);
            }
        };
    }

    private FormConfig _toFormConfig(final FormStyledLayoutStructureItem formStyledLayoutStructureItem) {
        if (formStyledLayoutStructureItem.getFormConfig() != 1 && formStyledLayoutStructureItem.getFormConfig() != 2) {
            return null;
        }
        return new FormConfig(){
            {
                this.setFormReference(() -> {
                    if (formStyledLayoutStructureItem.getFormConfig() == 2) {
                        return new ClassTypeReference(){
                            {
                                this.setClassName(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getClassName());
                                this.setClassType(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getClassTypeId());
                            }
                        };
                    }
                    return new ContextReference(){
                        {
                            this.setContextSource(() -> ContextReference.ContextSource.DISPLAY_PAGE_ITEM);
                        }
                    };
                });
                this.setFormType(() -> {
                    if (Objects.equals(formStyledLayoutStructureItem.getFormType(), "simple")) {
                        return FormConfig.FormType.SIMPLE;
                    }
                    return FormConfig.FormType.MULTISTEP;
                });
                this.setNumberOfSteps(() -> ((FormStyledLayoutStructureItem)formStyledLayoutStructureItem).getNumberOfSteps());
            }
        };
    }
}

