/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0.util;

import com.liferay.client.extension.service.ClientExtensionEntryRelLocalServiceUtil;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.headless.admin.site.dto.v1_0.ClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.FavIcon;
import com.liferay.headless.admin.site.dto.v1_0.FavIconClientExtension;
import com.liferay.headless.admin.site.dto.v1_0.FavIconItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.GeneralConfig;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetLookAndFeelConfig;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSection;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageWidgetInstance;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.SegmentsExperienceUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.importer.util.PortletPermissionsImporterUtil;
import com.liferay.layout.importer.util.PortletPreferencesPortletConfigurationImporterUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryServiceUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.custom.field.CustomField;
import com.liferay.portal.vulcan.custom.field.CustomFieldsUtil;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceServiceUtil;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalServiceUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LayoutUtil {
    private static final Log _log = LogFactoryUtil.getLog(LayoutUtil.class);
    private static final Collection<String> _excludePreferencesNames = ListUtil.fromArray((Object[])new String[]{"portletSetupUseCustomTitle", "portletSetupPortletDecoratorId", "portletSetupCss"});

    public static Layout addContentLayout(CETManager cetManager, long groupId, InfoItemServiceRegistry infoItemServiceRegistry, PageSpecification[] pageSpecifications, long parentLayoutId, boolean privateLayout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, UnicodeProperties typeSettingsUnicodeProperties, boolean hidden, boolean system, Map<Locale, String> friendlyURLMap, int status, ServiceContext serviceContext) throws Exception {
        if (typeSettingsUnicodeProperties == null) {
            typeSettingsUnicodeProperties = new UnicodeProperties();
        }
        if (pageSpecifications == null) {
            Layout layout = LayoutLocalServiceUtil.addLayout((String)GetterUtil.getString((Object)serviceContext.getAttribute("layoutExternalReferenceCode"), null), (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, (String)type, (String)typeSettingsUnicodeProperties.toString(), (boolean)hidden, (boolean)system, friendlyURLMap, (long)0L, (ServiceContext)serviceContext);
            return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode()) || !Objects.equals(draftContentPageSpecification.getExternalReferenceCode(), publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        Settings settings = publishedContentPageSpecification.getSettings();
        if (settings == null || Validator.isNull((Object)settings.getMasterPageItemExternalReference())) {
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-footer", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:show-header-search", Boolean.FALSE.toString());
            typeSettingsUnicodeProperties.setProperty("lfr-theme:regular:wrap-widget-page-content", Boolean.FALSE.toString());
        }
        long masterLayoutPlid = 0L;
        if (settings != null && settings.getMasterPageItemExternalReference() != null) {
            if (Objects.equals(3, serviceContext.getAttribute("layout.page.template.entry.type"))) {
                throw new UnsupportedOperationException();
            }
            ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
            if (Validator.isNotNull((String)itemExternalReference.getExternalReferenceCode())) {
                if (itemExternalReference.getScope() != null) {
                    throw new UnsupportedOperationException();
                }
                LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
                if (layoutPageTemplateEntry == null) {
                    throw new UnsupportedOperationException();
                }
                masterLayoutPlid = layoutPageTemplateEntry.getPlid();
            }
        }
        serviceContext.setAttribute("defaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(publishedContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutDefaultSegmentsExperienceExternalReferenceCode", (Serializable)((Object)SegmentsExperienceUtil.getDefaultSegmentsExperienceExternalReferenceCode(draftContentPageSpecification.getPageExperiences())));
        serviceContext.setAttribute("draftLayoutExternalReferenceCode", (Serializable)((Object)draftContentPageSpecification.getExternalReferenceCode()));
        ServiceContextUtil.setLayoutSetPrototypeLayoutERC(groupId, (PageSpecification)publishedContentPageSpecification, serviceContext);
        ServiceContextUtil.setLayoutSetPrototypeLayoutERC(groupId, (PageSpecification)draftContentPageSpecification, serviceContext);
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            typeSettingsUnicodeProperties.setProperty("published", Boolean.TRUE.toString());
        } else {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.FALSE.toString()));
        }
        Layout layout = LayoutLocalServiceUtil.addLayout((String)publishedContentPageSpecification.getExternalReferenceCode(), (long)serviceContext.getUserId(), (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (long)0L, (long)0L, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, (String)type, (String)typeSettingsUnicodeProperties.toString(), (boolean)hidden, (boolean)system, friendlyURLMap, (long)masterLayoutPlid, (ServiceContext)serviceContext);
        Layout draftLayout = layout.fetchDraftLayout();
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, draftLayout, draftLayout.getNameMap(), draftLayout.getTitleMap(), draftLayout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getFriendlyURLMap(), (PageSpecification)draftContentPageSpecification, draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, (PageSpecification)publishedContentPageSpecification, status, serviceContext);
    }

    public static Layout addDraftToLayout(CETManager cetManager, ContentPageSpecification contentPageSpecification, InfoItemServiceRegistry infoItemServiceRegistry, Layout layout, ServiceContext serviceContext) throws Exception {
        if (Validator.isNotNull((Object)contentPageSpecification.getStatus()) && !Objects.equals(contentPageSpecification.getStatus(), PageSpecification.Status.DRAFT) || layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (Validator.isNotNull((String)contentPageSpecification.getExternalReferenceCode()) && !Objects.equals(contentPageSpecification.getExternalReferenceCode(), draftLayout.getExternalReferenceCode()) || !Objects.equals(draftLayout.getStatus(), 0)) {
            throw new UnsupportedOperationException();
        }
        return LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, draftLayout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), draftLayout.getKeywordsMap(), draftLayout.getRobotsMap(), draftLayout.getFriendlyURLMap(), (PageSpecification)contentPageSpecification, 2, serviceContext);
    }

    public static Layout addPortletLayout(CETManager cetManager, String externalReferenceCode, InfoItemServiceRegistry infoItemServiceRegistry, long groupId, long parentLayoutId, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, UnicodeProperties typeSettingsUnicodeProperties, boolean hiddenFromNavigation, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext, WidgetPageSpecification widgetPageSpecification) throws Exception {
        String typeSettings = null;
        if (typeSettingsUnicodeProperties != null) {
            typeSettings = typeSettingsUnicodeProperties.toString();
        }
        LayoutUtil._setExpandoBridgeAttributes((PageSpecification)widgetPageSpecification, serviceContext);
        Layout layout = LayoutServiceUtil.addLayout((String)externalReferenceCode, (long)groupId, (boolean)false, (long)parentLayoutId, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, (String)"portlet", (String)typeSettings, (boolean)hiddenFromNavigation, friendlyURLMap, (long)0L, (ServiceContext)serviceContext);
        layout = LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), (PageSpecification)widgetPageSpecification, layout.getStatus(), serviceContext);
        return LayoutUtil.updatePortletLayout(cetManager, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), typeSettingsUnicodeProperties, serviceContext, widgetPageSpecification);
    }

    public static String getParentSectionId(Layout layout, String portletId) {
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        return layoutTypePortlet.getColumn(portletId);
    }

    public static Integer getPosition(Layout layout, String portletId) {
        UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        for (String columnId : layoutTypePortlet.getColumns()) {
            String columnValue = typeSettingsUnicodeProperties.getProperty(columnId, "");
            List portletIds = ListUtil.fromString((String)columnValue, (String)",");
            int position = portletIds.indexOf(portletId);
            if (position < 0) continue;
            return position;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Position for portlet cannot be obtained since portlet ", portletId, " cannot be found in layout ", layout.getPlid()}));
        }
        return null;
    }

    public static boolean isPublished(Layout layout) {
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            return true;
        }
        if (layout.isDraftLayout()) {
            return GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"));
        }
        Layout draftLayout = layout.fetchDraftLayout();
        return GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
    }

    public static Layout updateContentLayout(CETManager cetManager, InfoItemServiceRegistry infoItemServiceRegistry, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, UnicodeProperties typeSettingsUnicodeProperties, PageSpecification[] pageSpecifications, ServiceContext serviceContext) throws Exception {
        if (!Objects.equals(typeSettingsUnicodeProperties, layout.getTypeSettingsProperties())) {
            layout = LayoutServiceUtil.updateTypeSettings((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)typeSettingsUnicodeProperties.toString());
        }
        if (pageSpecifications == null) {
            return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, layout.getStyleBookEntryERC(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), friendlyURLMap, serviceContext);
        }
        if (pageSpecifications.length != 2) {
            throw new UnsupportedOperationException();
        }
        ContentPageSpecification draftContentPageSpecification = null;
        ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
        if (Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode())) {
            draftContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        } else {
            draftContentPageSpecification = publishedContentPageSpecification;
            publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
        }
        Layout draftLayout = layout.fetchDraftLayout();
        if (!(Objects.equals(draftLayout.getExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()) && Objects.equals(layout.getExternalReferenceCode(), publishedContentPageSpecification.getExternalReferenceCode()) && Objects.equals(publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode(), draftContentPageSpecification.getExternalReferenceCode()))) {
            throw new UnsupportedOperationException();
        }
        int draftLayoutStatus = 0;
        if (Objects.equals(draftContentPageSpecification.getStatus(), PageSpecification.Status.DRAFT)) {
            draftLayoutStatus = 2;
        }
        int status = layout.getStatus();
        if (Objects.equals(publishedContentPageSpecification.getStatus(), PageSpecification.Status.APPROVED)) {
            serviceContext.setAttribute("published", (Serializable)((Object)Boolean.TRUE.toString()));
            status = 0;
        }
        LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, draftLayout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, draftLayout.getFriendlyURLMap(), (PageSpecification)draftContentPageSpecification, draftLayoutStatus, serviceContext);
        return LayoutUtil.updateLayout(cetManager, infoItemServiceRegistry, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, (PageSpecification)publishedContentPageSpecification, status, serviceContext);
    }

    public static Layout updateLayout(CETManager cetManager, InfoItemServiceRegistry infoItemServiceRegistry, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, PageSpecification pageSpecification, int status, ServiceContext serviceContext) throws Exception {
        layout = LayoutUtil._updateLayout(cetManager, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, pageSpecification, serviceContext);
        if (pageSpecification instanceof ContentPageSpecification) {
            ContentPageSpecification contentPageSpecification = (ContentPageSpecification)pageSpecification;
            LayoutUtil._updatePageExperiences(infoItemServiceRegistry, layout, contentPageSpecification.getPageExperiences(), serviceContext);
        }
        if (status == layout.getStatus()) {
            return layout;
        }
        return LayoutLocalServiceUtil.updateStatus((long)serviceContext.getUserId(), (long)layout.getPlid(), (int)status, (ServiceContext)serviceContext);
    }

    public static Layout updatePortletLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext, WidgetPageSpecification widgetPageSpecification) throws Exception {
        layout = LayoutUtil._updateLayout(cetManager, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, (PageSpecification)widgetPageSpecification, serviceContext);
        UnicodeProperties unicodeProperties = UnicodePropertiesBuilder.create((boolean)true).fastLoad(layout.getTypeSettings()).build();
        if (typeSettingsUnicodeProperties != null) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.removeCustomization(unicodeProperties);
            typeSettingsUnicodeProperties.setProperty("CUSTOMIZABLE_LAYOUT", String.valueOf(GetterUtil.getBoolean((String)((String)typeSettingsUnicodeProperties.get((Object)"CUSTOMIZABLE_LAYOUT")))));
            String layoutTemplateId = typeSettingsUnicodeProperties.getProperty("layout-template-id", PropsValues.DEFAULT_LAYOUT_TEMPLATE_ID);
            typeSettingsUnicodeProperties.setProperty("layout-template-id", layoutTemplateId);
            if (!Objects.equals(layoutTemplateId, layoutTypePortlet.getLayoutTemplateId())) {
                layoutTypePortlet.setLayoutTemplateId(serviceContext.getUserId(), layoutTemplateId);
            }
            unicodeProperties.putAll((Map)typeSettingsUnicodeProperties);
            layout.setTypeSettingsProperties(unicodeProperties);
        }
        return LayoutUtil._updatePortletLayout(layout, serviceContext, widgetPageSpecification);
    }

    private static void _addPortletLookAndFeelToConfigurationMap(long groupId, Map<String, Object> map, WidgetLookAndFeelConfig widgetLookAndFeelConfig) {
        Map customTitleI18n;
        if (widgetLookAndFeelConfig == null || widgetLookAndFeelConfig.getGeneralConfig() == null) {
            return;
        }
        GeneralConfig generalConfig = widgetLookAndFeelConfig.getGeneralConfig();
        if (generalConfig.getApplicationDecorator() != null) {
            map.put("portletSetupPortletDecoratorId", StringUtil.lowerCase((String)generalConfig.getApplicationDecoratorAsString()));
        }
        if ((customTitleI18n = generalConfig.getCustomTitle_i18n()) != null) {
            Map localizedMap = LocalizedMapUtil.getLocalizedMap((Map)customTitleI18n);
            for (Locale locale : LanguageUtil.getAvailableLocales((long)groupId)) {
                if (!localizedMap.containsKey(locale)) continue;
                map.put("portletSetupTitle_" + LocaleUtil.toLanguageId((Locale)locale), localizedMap.get(locale));
            }
        }
        if (generalConfig.getUseCustomTitle() != null) {
            map.put("portletSetupUseCustomTitle", Boolean.toString(generalConfig.getUseCustomTitle()));
        }
    }

    private static long _getFaviconFileEntryId(Settings settings, ServiceContext serviceContext) throws Exception {
        DLFileEntry dlFileEntry;
        if (settings == null || settings.getFavIcon() == null) {
            return 0L;
        }
        FavIcon favIcon = settings.getFavIcon();
        if (!(favIcon instanceof FavIconItemExternalReference)) {
            return 0L;
        }
        FavIconItemExternalReference favIconItemExternalReference = (FavIconItemExternalReference)favIcon;
        long groupId = serviceContext.getScopeGroupId();
        Scope scope = favIconItemExternalReference.getScope();
        if (scope != null) {
            groupId = GroupUtil.getGroupId(true, true, serviceContext.getCompanyId(), scope.getExternalReferenceCode());
        }
        if ((dlFileEntry = DLFileEntryServiceUtil.fetchFileEntryByExternalReferenceCode((long)groupId, (String)favIconItemExternalReference.getExternalReferenceCode())) == null) {
            throw new UnsupportedOperationException();
        }
        return dlFileEntry.getFileEntryId();
    }

    private static long _getMasterLayoutPlid(long groupId, Layout layout, Settings settings) throws Exception {
        if (settings == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = settings.getMasterPageItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return 0L;
        }
        if (itemExternalReference.getScope() != null) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid((long)layout.getPlid());
        if (layoutPageTemplateEntry != null && Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        layoutPageTemplateEntry = LayoutPageTemplateEntryServiceUtil.fetchLayoutPageTemplateEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (layoutPageTemplateEntry == null || !Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateEntry.getPlid();
    }

    private static String _getStyleBookEntryERC(long companyId, long groupId, Settings settings) {
        if (settings == null) {
            return null;
        }
        ItemExternalReference itemExternalReference = settings.getStyleBookItemExternalReference();
        if (itemExternalReference == null || Validator.isNull((String)itemExternalReference.getExternalReferenceCode())) {
            return null;
        }
        StyleBookEntry styleBookEntry = StyleBookEntryLocalServiceUtil.fetchStyleBookEntryByExternalReferenceCode((String)itemExternalReference.getExternalReferenceCode(), (long)groupId);
        if (styleBookEntry == null) {
            LogUtil.logOptionalReference(StyleBookEntry.class, itemExternalReference.getExternalReferenceCode(), companyId);
        }
        return itemExternalReference.getExternalReferenceCode();
    }

    private static void _importPortletConfiguration(Layout layout, String portletId, WidgetPageWidgetInstance widgetPageWidgetInstance) throws Exception {
        HashMap<String, Object> configurationMap = widgetPageWidgetInstance.getWidgetConfig();
        if (configurationMap != null && ListUtil.isNotEmpty((List)TransformUtil.transform(configurationMap.keySet(), key -> {
            if (_excludePreferencesNames.contains(key) || key.startsWith("portletSetupTitle_")) {
                return key;
            }
            return null;
        }))) {
            throw new UnsupportedOperationException();
        }
        if (configurationMap == null) {
            configurationMap = new HashMap<String, Object>();
        }
        LayoutUtil._addPortletLookAndFeelToConfigurationMap(layout.getGroupId(), configurationMap, widgetPageWidgetInstance.getWidgetLookAndFeelConfig());
        PortletPreferencesPortletConfigurationImporterUtil.importPortletConfiguration((long)layout.getPlid(), (String)portletId, configurationMap);
    }

    private static void _setExpandoBridgeAttributes(PageSpecification pageSpecification, ServiceContext serviceContext) {
        if (pageSpecification == null) {
            serviceContext.setExpandoBridgeAttributes(null);
        } else {
            serviceContext.setExpandoBridgeAttributes(CustomFieldsUtil.toMap((String)Layout.class.getName(), (long)serviceContext.getCompanyId(), (CustomField[])pageSpecification.getCustomFields(), null));
        }
    }

    private static void _updateClientExtensionEntryRel(CETManager cetManager, long classNameId, ClientExtension clientExtension, Layout layout, String type, ServiceContext serviceContext) throws Exception {
        ClientExtension[] clientExtensions = null;
        if (clientExtension != null) {
            clientExtensions = new ClientExtension[]{clientExtension};
        }
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, clientExtensions, layout, type, serviceContext);
    }

    private static void _updateClientExtensionEntryRels(CETManager cetManager, long classNameId, ClientExtension[] clientExtensions, Layout layout, String type, ServiceContext serviceContext) throws Exception {
        ClientExtensionEntryRelLocalServiceUtil.deleteClientExtensionEntryRels((long)classNameId, (long)layout.getPlid(), (String)type);
        if (ArrayUtil.isEmpty((Object[])clientExtensions)) {
            return;
        }
        for (ClientExtension clientExtension : clientExtensions) {
            CET cet = cetManager.getCET(layout.getCompanyId(), clientExtension.getExternalReferenceCode());
            if (cet == null) {
                LogUtil.logOptionalReference(ClientExtension.class, clientExtension.getExternalReferenceCode(), layout.getCompanyId());
            }
            ClientExtensionEntryRelLocalServiceUtil.addClientExtensionEntryRel((long)serviceContext.getUserId(), (long)layout.getGroupId(), (long)classNameId, (long)layout.getPlid(), (String)clientExtension.getExternalReferenceCode(), (String)type, (String)UnicodePropertiesBuilder.create((Map)clientExtension.getClientExtensionConfig(), (boolean)true).buildString(), (ServiceContext)serviceContext);
        }
    }

    private static void _updateClientExtensions(CETManager cetManager, Layout layout, Settings settings, ServiceContext serviceContext) throws Exception {
        if (settings == null) {
            ClientExtensionEntryRelLocalServiceUtil.deleteClientExtensionEntryRels((long)PortalUtil.getClassNameId(Layout.class), (long)layout.getPlid());
            return;
        }
        if (layout.isTypeUtility()) {
            if (Validator.isNotNull((Object)settings.getFavIcon()) || ArrayUtil.isNotEmpty((Object[])settings.getGlobalCSSClientExtensions()) || ArrayUtil.isNotEmpty((Object[])settings.getGlobalJSClientExtensions()) || Validator.isNotNull((Object)settings.getThemeCSSClientExtension()) || Validator.isNotNull((Object)settings.getThemeSpritemapClientExtension())) {
                throw new UnsupportedOperationException();
            }
            return;
        }
        long classNameId = PortalUtil.getClassNameId(Layout.class);
        ClientExtension clientExtension = null;
        FavIcon favIcon = settings.getFavIcon();
        if (favIcon instanceof FavIconClientExtension) {
            final FavIconClientExtension favIconClientExtension = (FavIconClientExtension)favIcon;
            clientExtension = new ClientExtension(){
                {
                    this.setClientExtensionConfig(() -> favIconClientExtension.getClientExtensionConfig());
                    this.setExternalReferenceCode(() -> favIconClientExtension.getExternalReferenceCode());
                }
            };
        }
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, settings.getGlobalCSSClientExtensions(), layout, "globalCSS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRels(cetManager, classNameId, settings.getGlobalJSClientExtensions(), layout, "globalJS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, settings.getThemeCSSClientExtension(), layout, "themeCSS", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, clientExtension, layout, "themeFavicon", serviceContext);
        LayoutUtil._updateClientExtensionEntryRel(cetManager, classNameId, settings.getThemeSpritemapClientExtension(), layout, "themeSpritemap", serviceContext);
    }

    private static Layout _updateLayout(CETManager cetManager, Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, Map<Locale, String> friendlyURLMap, PageSpecification pageSpecification, ServiceContext serviceContext) throws Exception {
        Settings settings = null;
        if (pageSpecification != null) {
            settings = pageSpecification.getSettings();
        }
        LayoutUtil._updateClientExtensions(cetManager, layout, settings, serviceContext);
        layout = LayoutUtil._updateLookAndFeel(layout, settings);
        LayoutUtil._setExpandoBridgeAttributes(pageSpecification, serviceContext);
        return LayoutUtil._updateLayout(layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, LayoutUtil._getStyleBookEntryERC(layout.getCompanyId(), layout.getGroupId(), settings), LayoutUtil._getFaviconFileEntryId(settings, serviceContext), LayoutUtil._getMasterLayoutPlid(serviceContext.getScopeGroupId(), layout, settings), friendlyURLMap, serviceContext);
    }

    private static Layout _updateLayout(Layout layout, Map<Locale, String> nameMap, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String styleBookEntryERC, long faviconFileEntryId, long masterLayoutPlid, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws Exception {
        if (layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        }
        return LayoutServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (long)GetterUtil.getLong((Object)serviceContext.getAttribute("parentLayoutId"), (long)layout.getParentLayoutId()), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, (String)layout.getType(), (boolean)GetterUtil.getBoolean((Object)serviceContext.getAttribute("hidden"), (boolean)layout.isHidden()), friendlyURLMap, (boolean)layout.getIconImage(), null, (String)styleBookEntryERC, (long)faviconFileEntryId, (long)masterLayoutPlid, (ServiceContext)serviceContext);
    }

    private static Layout _updateLookAndFeel(Layout layout, Settings settings) throws Exception {
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        if (settings != null) {
            unicodeProperties.setProperty("javascript", settings.getJavascript());
        } else {
            unicodeProperties.remove((Object)"javascript");
        }
        for (String key : ListUtil.fromCollection((Collection)unicodeProperties.keySet())) {
            if (!key.startsWith("lfr-theme:")) continue;
            unicodeProperties.remove((Object)key);
        }
        if (settings != null && MapUtil.isNotEmpty((Map)settings.getThemeSettings())) {
            unicodeProperties.putAll(settings.getThemeSettings());
        }
        layout = LayoutServiceUtil.updateTypeSettings((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
        String themeId = null;
        String colorSchemeId = null;
        String css = null;
        if (settings != null) {
            themeId = settings.getThemeName();
            colorSchemeId = settings.getColorSchemeName();
            css = settings.getCss();
        }
        return LayoutServiceUtil.updateLookAndFeel((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)themeId, (String)colorSchemeId, (String)css);
    }

    private static void _updatePageExperiences(InfoItemServiceRegistry infoItemServiceRegistry, Layout layout, PageExperience[] pageExperiences, ServiceContext serviceContext) throws Exception {
        List segmentsExperiences = SegmentsExperienceServiceUtil.getSegmentsExperiences((long)layout.getGroupId(), (long)layout.getPlid(), (boolean)true);
        if (pageExperiences == null || pageExperiences.length != segmentsExperiences.size()) {
            throw new UnsupportedOperationException();
        }
        HashMap<String, SegmentsExperience> segmentsExperiencesMap = new HashMap<String, SegmentsExperience>();
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            segmentsExperiencesMap.put(segmentsExperience.getExternalReferenceCode(), segmentsExperience);
        }
        for (PageExperience pageExperience : pageExperiences) {
            SegmentsExperience segmentsExperience = (SegmentsExperience)segmentsExperiencesMap.get(pageExperience.getExternalReferenceCode());
            if (segmentsExperience == null) {
                throw new UnsupportedOperationException();
            }
            SegmentsExperienceUtil.updateSegmentsExperience(infoItemServiceRegistry, layout, pageExperience, segmentsExperience, serviceContext);
        }
    }

    private static Layout _updatePortletLayout(Layout layout, ServiceContext serviceContext, WidgetPageSpecification widgetPageSpecification) throws Exception {
        LayoutTypePortlet layoutTypePortlet;
        List columns;
        UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        if (widgetPageSpecification == null) {
            return LayoutServiceUtil.updateTypeSettings((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
        }
        WidgetPageSection[] widgetPageSections = widgetPageSpecification.getWidgetPageSections();
        if (widgetPageSections.length != (columns = (layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).getColumns()).size()) {
            throw new UnsupportedOperationException();
        }
        List portletIds = layoutTypePortlet.getPortletIds();
        boolean layoutCustomizable = GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)"CUSTOMIZABLE_LAYOUT")));
        for (WidgetPageSection widgetPageSection : widgetPageSections) {
            boolean customizable = GetterUtil.getBoolean((String)((String)unicodeProperties.get((Object)CustomizedPages.namespaceColumnId((String)widgetPageSection.getId()))));
            if (!columns.contains(widgetPageSection.getId()) || !layoutCustomizable && customizable) {
                throw new UnsupportedOperationException();
            }
            for (WidgetPageWidgetInstance widgetPageWidgetInstance : widgetPageSection.getWidgetPageWidgetInstances()) {
                String portletId = PortletIdCodec.encode((String)widgetPageWidgetInstance.getWidgetName(), (String)widgetPageWidgetInstance.getWidgetInstanceId());
                if (!layoutTypePortlet.hasPortletId(portletId)) {
                    layoutTypePortlet.addPortletId(serviceContext.getUserId(), portletId, widgetPageWidgetInstance.getParentSectionId(), widgetPageWidgetInstance.getPosition().intValue());
                } else if (!Objects.equals(widgetPageWidgetInstance.getParentSectionId(), LayoutUtil.getParentSectionId(layout, portletId)) || !Objects.equals(widgetPageWidgetInstance.getPosition(), LayoutUtil.getPosition(layout, portletId))) {
                    layoutTypePortlet.movePortletId(serviceContext.getUserId(), portletId, widgetPageWidgetInstance.getParentSectionId(), widgetPageWidgetInstance.getPosition().intValue());
                }
                LayoutUtil._importPortletConfiguration(layout, portletId, widgetPageWidgetInstance);
                PortletPermissionsImporterUtil.importPortletPermissions((long)layout.getPlid(), (String)portletId, new HashSet(), (List)TransformUtil.transform((Collection)ListUtil.fromArray((Object[])widgetPageWidgetInstance.getWidgetPermissions()), widgetPermission -> HashMapBuilder.put((Object)"actionKeys", (Object)ListUtil.fromArray((Object[])widgetPermission.getActionIds())).put((Object)"roleKey", (Object)widgetPermission.getRoleName()).build()));
                portletIds.remove(portletId);
            }
        }
        for (String portletId : portletIds) {
            layoutTypePortlet.removePortletId(serviceContext.getUserId(), portletId);
        }
        return LayoutServiceUtil.updateTypeSettings((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)unicodeProperties.toString());
    }
}

