/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.NavigationMenu;
import com.liferay.headless.admin.site.resource.v1_0.NavigationMenuResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.Resource;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PermissionServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.ModelPermissionsUtil;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@Path(value="/v1.0")
public abstract class BaseNavigationMenuResourceImpl
implements EntityModelResource,
NavigationMenuResource,
VulcanBatchEngineTaskItemDelegate<NavigationMenu> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<NavigationMenu>, UnsafeFunction<NavigationMenu, NavigationMenu, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<NavigationMenu>, UnsafeConsumer<NavigationMenu, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseNavigationMenuResourceImpl.class);

    @Operation(description="Deletes a specific navigation menu of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="navigationMenuExternalReferenceCode")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @DELETE
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/{navigationMenuExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteNavigationMenu(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="navigationMenuExternalReferenceCode") String navigationMenuExternalReferenceCode) throws Exception {
    }

    protected abstract NavigationMenu doGetSiteNavigationMenu(String var1, String var2) throws Exception;

    @Operation(description="Retrieves a specific navigation menu of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="navigationMenuExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/{navigationMenuExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public final NavigationMenu getSiteNavigationMenu(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="navigationMenuExternalReferenceCode") String navigationMenuExternalReferenceCode) throws Exception {
        NavigationMenu getNavigationMenu = this.doGetSiteNavigationMenu(siteExternalReferenceCode, navigationMenuExternalReferenceCode);
        getNavigationMenu.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
            Page<Permission> permissionsPage = this.getSiteNavigationMenuPermissionsPage(siteExternalReferenceCode, getNavigationMenu.getExternalReferenceCode(), null);
            Collection permissions = permissionsPage.getItems();
            return permissions.toArray(new Permission[permissions.size()]);
        }));
        return getNavigationMenu;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="navigationMenuExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/{navigationMenuExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteNavigationMenuPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="navigationMenuExternalReferenceCode") String navigationMenuExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        Long groupId = this.getPermissionCheckerGroupId(siteExternalReferenceCode);
        Long resourceId = this.getPermissionCheckerResourceId(siteExternalReferenceCode, navigationMenuExternalReferenceCode);
        String resourceName = this.getPermissionCheckerResourceName(siteExternalReferenceCode, navigationMenuExternalReferenceCode);
        PermissionServiceUtil.checkPermission((long)groupId, (String)resourceName, (long)resourceId);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", resourceId, "getSiteNavigationMenuPermissionsPage", null, resourceName, groupId)).put((Object)"replace", this.addAction("PERMISSIONS", resourceId, "putSiteNavigationMenuPermissionsPage", null, resourceName, groupId)).build(), resourceId, resourceName, roleNames);
    }

    protected abstract Page<NavigationMenu> doGetSiteNavigationMenusPage(String var1, String var2, com.liferay.portal.kernel.search.filter.Filter var3, Pagination var4, Sort[] var5) throws Exception;

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus")
    @Produces(value={"application/json", "application/xml"})
    public final Page<NavigationMenu> getSiteNavigationMenusPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        Page<NavigationMenu> navigationMenusPage = this.doGetSiteNavigationMenusPage(siteExternalReferenceCode, search, filter, pagination, sorts);
        for (NavigationMenu navigationMenu : navigationMenusPage.getItems()) {
            navigationMenu.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Page<Permission> permissionsPage = this.getSiteNavigationMenuPermissionsPage(siteExternalReferenceCode, navigationMenu.getExternalReferenceCode(), null);
                Collection permissions = permissionsPage.getItems();
                return permissions.toArray(new Permission[permissions.size()]);
            }));
        }
        return navigationMenusPage;
    }

    protected abstract NavigationMenu doPostSiteNavigationMenu(String var1, NavigationMenu var2) throws Exception;

    @Operation(description="Creates a new navigation menu.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public final NavigationMenu postSiteNavigationMenu(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        Permission[] permissions = navigationMenu.getPermissions();
        NavigationMenu postNavigationMenu = this.doPostSiteNavigationMenu(siteExternalReferenceCode, navigationMenu);
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putSiteNavigationMenuPermissionsPage(siteExternalReferenceCode, postNavigationMenu.getExternalReferenceCode(), permissions);
            postNavigationMenu.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[collection.size()]);
            }));
        }
        return postNavigationMenu;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="callbackURL")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteNavigationMenuBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, Object object) throws Exception {
        this.vulcanBatchEngineImportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineImportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineImportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineImportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineImportTaskResource.setContextUser(this.contextUser);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineImportTaskResource.postImportTask(NavigationMenu.class.getName(), callbackURL, null, object)).build();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort"), @Parameter(in=ParameterIn.QUERY, name="callbackURL"), @Parameter(in=ParameterIn.QUERY, name="contentType"), @Parameter(in=ParameterIn.QUERY, name="fieldNames")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @Consumes(value={"application/json"})
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/export-batch")
    @POST
    @Produces(value={"application/json"})
    public Response postSiteNavigationMenusPageExportBatch(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Sort[] sorts, @Parameter(hidden=true) @QueryParam(value="callbackURL") String callbackURL, @Parameter(hidden=true) @DefaultValue(value="JSON") @QueryParam(value="contentType") String contentType, @Parameter(hidden=true) @QueryParam(value="fieldNames") String fieldNames) throws Exception {
        this.vulcanBatchEngineExportTaskResource.setContextAcceptLanguage(this.contextAcceptLanguage);
        this.vulcanBatchEngineExportTaskResource.setContextCompany(this.contextCompany);
        this.vulcanBatchEngineExportTaskResource.setContextHttpServletRequest(this.contextHttpServletRequest);
        this.vulcanBatchEngineExportTaskResource.setContextUriInfo(this.contextUriInfo);
        this.vulcanBatchEngineExportTaskResource.setContextUser(this.contextUser);
        this.vulcanBatchEngineExportTaskResource.setGroupLocalService(this.groupLocalService);
        Response.ResponseBuilder responseBuilder = Response.accepted();
        return responseBuilder.entity(this.vulcanBatchEngineExportTaskResource.postExportTask(NavigationMenu.class.getName(), callbackURL, contentType, fieldNames)).build();
    }

    protected abstract NavigationMenu doPutSiteNavigationMenu(String var1, String var2, NavigationMenu var3) throws Exception;

    @Operation(description="Updates the navigation menu with the given external reference code or creates it if it does not exist.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="navigationMenuExternalReferenceCode")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/{navigationMenuExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public final NavigationMenu putSiteNavigationMenu(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="navigationMenuExternalReferenceCode") String navigationMenuExternalReferenceCode, NavigationMenu navigationMenu) throws Exception {
        Permission[] permissions = navigationMenu.getPermissions();
        NavigationMenu putNavigationMenu = this.doPutSiteNavigationMenu(siteExternalReferenceCode, navigationMenuExternalReferenceCode, navigationMenu);
        if (permissions != null) {
            Page<Permission> permissionsPage = this.putSiteNavigationMenuPermissionsPage(siteExternalReferenceCode, putNavigationMenu.getExternalReferenceCode(), permissions);
            putNavigationMenu.setPermissions(() -> (Permission[])NestedFieldsSupplier.supply((String)"permissions", nestedField -> {
                Collection collection = permissionsPage.getItems();
                return collection.toArray(new Permission[collection.size()]);
            }));
        }
        return putNavigationMenu;
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="navigationMenuExternalReferenceCode")})
    @Tags(value={@Tag(name="NavigationMenu")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/navigation-menus/{navigationMenuExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteNavigationMenuPermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="navigationMenuExternalReferenceCode") String navigationMenuExternalReferenceCode, Permission[] permissions) throws Exception {
        Long groupId = this.getPermissionCheckerGroupId(siteExternalReferenceCode);
        Long resourceId = this.getPermissionCheckerResourceId(siteExternalReferenceCode, navigationMenuExternalReferenceCode);
        String resourceName = this.getPermissionCheckerResourceName(siteExternalReferenceCode, navigationMenuExternalReferenceCode);
        PermissionServiceUtil.checkPermission((long)groupId, (String)resourceName, (long)resourceId);
        ModelPermissions modelPermissions = ModelPermissionsUtil.toModelPermissions((long)this.contextCompany.getCompanyId(), (Permission[])permissions, (long)resourceId, (String)resourceName, (ResourceActionLocalService)this.resourceActionLocalService, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (RoleLocalService)this.roleLocalService);
        Collection roleNames = modelPermissions.getRoleNames();
        for (ResourcePermission resourcePermission : this.resourcePermissionLocalService.getResourcePermissions(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId))) {
            Role role = this.roleLocalService.fetchRole(resourcePermission.getRoleId());
            if (role == null || roleNames.contains(role.getName())) continue;
            for (ResourceAction resourceAction : this.resourceActionLocalService.getResourceActions(resourceName)) {
                this.resourcePermissionLocalService.removeResourcePermission(this.contextCompany.getCompanyId(), resourceName, 4, String.valueOf(resourceId), role.getRoleId(), resourceAction.getActionId());
            }
        }
        this.resourcePermissionLocalService.updateResourcePermissions(this.contextCompany.getCompanyId(), groupId.longValue(), resourceName, String.valueOf(resourceId), modelPermissions);
        return this.toPermissionPage(HashMapBuilder.put((Object)"get", this.addAction("PERMISSIONS", resourceId, "getSiteNavigationMenuPermissionsPage", null, resourceName, groupId)).put((Object)"replace", this.addAction("PERMISSIONS", resourceId, "putSiteNavigationMenuPermissionsPage", null, resourceName, groupId)).build(), resourceId, resourceName, null);
    }

    public void create(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        String updateStrategy;
        UnsafeFunction navigationMenuUnsafeFunction = null;
        String createStrategy = (String)((Object)parameters.getOrDefault("createStrategy", (Serializable)((Object)"INSERT")));
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"INSERT")) {
            if (parameters.containsKey("siteExternalReferenceCode")) {
                navigationMenuUnsafeFunction = navigationMenu -> this.postSiteNavigationMenu((String)parameters.get("siteExternalReferenceCode"), (NavigationMenu)navigationMenu);
            } else {
                throw new NotSupportedException("One of the following parameters must be specified: [siteExternalReferenceCode]");
            }
        }
        if (StringUtil.equalsIgnoreCase((String)createStrategy, (String)"UPSERT") && StringUtil.equalsIgnoreCase((String)(updateStrategy = (String)((Object)parameters.getOrDefault("updateStrategy", (Serializable)((Object)"UPDATE")))), (String)"UPDATE")) {
            navigationMenuUnsafeFunction = navigationMenu -> {
                NavigationMenu persistedNavigationMenu = null;
                if (!parameters.containsKey("siteExternalReferenceCode")) {
                    throw new NotSupportedException("One of the following parameters must be specified: [siteExternalReferenceCode]");
                }
                persistedNavigationMenu = this.putSiteNavigationMenu((String)parameters.get("siteExternalReferenceCode"), navigationMenu.getExternalReferenceCode(), (NavigationMenu)navigationMenu);
                return persistedNavigationMenu;
            };
        }
        if (navigationMenuUnsafeFunction == null) {
            throw new NotSupportedException("Create strategy \"" + createStrategy + "\" is not supported for NavigationMenu");
        }
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(navigationMenus, (Object)navigationMenuUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(navigationMenus, arg_0 -> ((UnsafeFunction)navigationMenuUnsafeFunction).apply(arg_0));
        } else {
            for (NavigationMenu navigationMenu2 : navigationMenus) {
                navigationMenuUnsafeFunction.apply((Object)navigationMenu2);
            }
        }
    }

    public void delete(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        UnsafeFunction navigationMenuUnsafeFunction = navigationMenu -> {
            if (parameters.containsKey("siteExternalReferenceCode")) {
                this.deleteSiteNavigationMenu((String)parameters.get("siteExternalReferenceCode"), navigationMenu.getExternalReferenceCode());
                return navigationMenu;
            }
            throw new UnsupportedOperationException("Unable to delete by external reference code or ID");
        };
        if (this.contextBatchUnsafeBiConsumer != null) {
            this.contextBatchUnsafeBiConsumer.accept(navigationMenus, (Object)navigationMenuUnsafeFunction);
        } else if (this.contextBatchUnsafeConsumer != null) {
            this.contextBatchUnsafeConsumer.accept(navigationMenus, arg_0 -> ((UnsafeFunction)navigationMenuUnsafeFunction).apply(arg_0));
        } else {
            for (NavigationMenu navigationMenu2 : navigationMenus) {
                navigationMenuUnsafeFunction.apply((Object)navigationMenu2);
            }
        }
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[]{"INSERT", "UPSERT"});
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public String getResourceName() {
        return "NavigationMenu";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<NavigationMenu> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (parameters.containsKey("siteExternalReferenceCode")) {
            return this.getSiteNavigationMenusPage((String)((Object)parameters.get("siteExternalReferenceCode")), search, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteExternalReferenceCode]");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<NavigationMenu> navigationMenus, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    protected Long getPermissionCheckerGroupId(String groupExternalReferenceCode) throws Exception {
        Group group = this.groupLocalService.getGroupByExternalReferenceCode(groupExternalReferenceCode, this.contextCompany.getCompanyId());
        return group.getGroupId();
    }

    protected Long getPermissionCheckerResourceId(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected String getPermissionCheckerResourceName(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    protected Page<Permission> toPermissionPage(Map<String, Map<String, String>> actions, long id, String resourceName, String roleNames) throws Exception {
        List resourceActions = this.resourceActionLocalService.getResourceActions(resourceName);
        if (Validator.isNotNull((String)roleNames)) {
            return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, StringUtil.split((String)roleNames)));
        }
        return Page.of(actions, this._getPermissions(this.contextCompany.getCompanyId(), resourceActions, id, resourceName, null));
    }

    private Collection<Permission> _getPermissions(long companyId, List<ResourceAction> resourceActions, long resourceId, String resourceName, String[] roleNames) throws Exception {
        HashMap<String, 2> permissions = new HashMap<String, 2>();
        int count = this.resourcePermissionLocalService.getResourcePermissionsCount(companyId, resourceName, 4, String.valueOf(resourceId));
        if (count == 0) {
            ResourceLocalServiceUtil.addResources((long)companyId, (long)resourceId, (long)0L, (String)resourceName, (String)String.valueOf(resourceId), (boolean)false, (boolean)true, (boolean)true);
        }
        List actionIds = this.transform(resourceActions, resourceAction -> resourceAction.getActionId());
        HashSet resourcePermissions = new HashSet();
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 1, String.valueOf(companyId)));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 2, String.valueOf(GroupThreadLocal.getGroupId())));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 3, "0"));
        resourcePermissions.addAll(this.resourcePermissionLocalService.getResourcePermissions(companyId, resourceName, 4, String.valueOf(resourceId)));
        List resources = this.transform(resourcePermissions, resourcePermission -> ResourceLocalServiceUtil.getResource((long)resourcePermission.getCompanyId(), (String)resourcePermission.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey()));
        HashSet<Role> roles = new HashSet<Role>();
        if (roleNames != null) {
            for (String string : roleNames) {
                roles.add(this.roleLocalService.getRole(companyId, string));
            }
        } else {
            for (ResourcePermission resourcePermission2 : resourcePermissions) {
                Role role = this.roleLocalService.getRole(resourcePermission2.getRoleId());
                roles.add(role);
            }
        }
        for (final Role role : roles) {
            final HashSet actionsIdsSet = new HashSet();
            for (Resource resource : resources) {
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 1, String.valueOf(resource.getCompanyId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 2, String.valueOf(GroupThreadLocal.getGroupId()), role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), 3, "0", role.getRoleId(), actionIds));
                actionsIdsSet.addAll(this.resourcePermissionLocalService.getAvailableResourcePermissionActionIds(resource.getCompanyId(), resource.getName(), resource.getScope(), resource.getPrimKey(), role.getRoleId(), actionIds));
            }
            if (actionsIdsSet.isEmpty()) continue;
            Permission permission = new Permission(){
                {
                    this.actionIds = actionsIdsSet.toArray(new String[0]);
                    this.roleName = role.getName();
                }
            };
            permissions.put(role.getName(), permission);
        }
        return permissions.values();
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<NavigationMenu>, UnsafeFunction<NavigationMenu, NavigationMenu, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<NavigationMenu>, UnsafeConsumer<NavigationMenu, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-admin-site";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    public static <R, E extends Throwable> R[] transform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((int[])array, unsafeFunction, clazz);
    }

    public static <R, E extends Throwable> R[] transform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((long[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        return TransformUtil.transformToBooleanArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> boolean[] transformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) {
        return TransformUtil.transformToBooleanArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) {
        return TransformUtil.transformToByteArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] transformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) {
        return TransformUtil.transformToByteArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) {
        return TransformUtil.transformToDoubleArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] transformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) {
        return TransformUtil.transformToDoubleArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) {
        return TransformUtil.transformToFloatArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] transformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) {
        return TransformUtil.transformToFloatArray((Object[])array, unsafeFunction);
    }

    public static <T, R, E extends Throwable> int[] transformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToIntArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> int[] transformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) {
        return TransformUtil.transformToIntArray((Object[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> transformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) {
        return TransformUtil.transformToList((int[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> transformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) {
        return TransformUtil.transformToList((long[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> long[] transformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) {
        return TransformUtil.transformToLongArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] transformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) {
        return TransformUtil.transformToShortArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] transformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) {
        return TransformUtil.transformToShortArray((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    public static <R, E extends Throwable> R[] unsafeTransform(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((int[])array, unsafeFunction, clazz);
    }

    public static <R, E extends Throwable> R[] unsafeTransform(long[] array, UnsafeFunction<Long, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((long[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(Collection<T> collection, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToBooleanArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> boolean[] unsafeTransformToBooleanArray(T[] array, UnsafeFunction<T, Boolean, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToBooleanArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(Collection<T> collection, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToByteArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> byte[] unsafeTransformToByteArray(T[] array, UnsafeFunction<T, Byte, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToByteArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(Collection<T> collection, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToDoubleArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> double[] unsafeTransformToDoubleArray(T[] array, UnsafeFunction<T, Double, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToDoubleArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(Collection<T> collection, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToFloatArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> float[] unsafeTransformToFloatArray(T[] array, UnsafeFunction<T, Float, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToFloatArray((Object[])array, unsafeFunction);
    }

    public static <T, R, E extends Throwable> int[] unsafeTransformToIntArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToIntArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> int[] unsafeTransformToIntArray(T[] array, UnsafeFunction<T, Integer, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToIntArray((Object[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(int[] array, UnsafeFunction<Integer, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((int[])array, unsafeFunction);
    }

    public static <R, E extends Throwable> List<R> unsafeTransformToList(long[] array, UnsafeFunction<Long, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((long[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> long[] unsafeTransformToLongArray(T[] array, UnsafeFunction<T, Long, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray((Object[])array, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(Collection<T> collection, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToShortArray(collection, unsafeFunction);
    }

    public static <T, E extends Throwable> short[] unsafeTransformToShortArray(T[] array, UnsafeFunction<T, Short, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToShortArray((Object[])array, unsafeFunction);
    }
}

