/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

public class ItemScopeUtil {
    public static Long getGroupId(long companyId, Scope scope, long scopeGroupId) {
        if (scope == null || Validator.isNull((String)scope.getExternalReferenceCode())) {
            return scopeGroupId;
        }
        Group group = GroupLocalServiceUtil.fetchGroupByExternalReferenceCode((String)scope.getExternalReferenceCode(), (long)companyId);
        if (group == null) {
            return null;
        }
        return group.getGroupId();
    }

    public static Long getItemGroupId(long companyId, Scope scope, long scopeGroupId) {
        if (scope == null || scope.getExternalReferenceCode() == null) {
            return scopeGroupId;
        }
        Group group = GroupLocalServiceUtil.fetchGroupByExternalReferenceCode((String)scope.getExternalReferenceCode(), (long)companyId);
        if (group == null) {
            return null;
        }
        return group.getGroupId();
    }

    public static Scope getItemScope(long itemScopeGroupId, long scopeGroupId) throws Exception {
        if (scopeGroupId == itemScopeGroupId) {
            return null;
        }
        return ItemScopeUtil._getScope(GroupLocalServiceUtil.getGroup((long)itemScopeGroupId));
    }

    public static Scope getItemScope(long companyId, final String itemGroupExternalReferenceCode, long scopeGroupId) {
        if (Validator.isNull((String)itemGroupExternalReferenceCode)) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroupByExternalReferenceCode((String)itemGroupExternalReferenceCode, (long)companyId);
        if (group == null) {
            return new Scope(){
                {
                    this.setExternalReferenceCode(() -> itemGroupExternalReferenceCode);
                    this.setType(() -> Scope.Type.SITE);
                }
            };
        }
        if (group.getGroupId() == scopeGroupId) {
            return null;
        }
        return ItemScopeUtil._getScope(group);
    }

    public static String getItemScopeExternalReferenceCode(Scope itemScope, long scopeGroupId) throws PortalException {
        if (itemScope == null) {
            return null;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)scopeGroupId);
        if (StringUtil.equals((String)itemScope.getExternalReferenceCode(), (String)group.getExternalReferenceCode())) {
            return null;
        }
        return itemScope.getExternalReferenceCode();
    }

    private static Scope _getScope(final Group group) {
        return new Scope(){
            {
                this.setExternalReferenceCode(() -> ((Group)group).getExternalReferenceCode());
                this.setType(() -> {
                    if (group.getType() == 5) {
                        return Scope.Type.ASSET_LIBRARY;
                    }
                    return Scope.Type.SITE;
                });
            }
        };
    }
}

