/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.util;

import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.ItemScopeUtil;
import com.liferay.headless.admin.site.internal.util.LogUtil;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemDetails;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemDetailsProvider;
import com.liferay.info.item.provider.InfoItemObjectProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;

public class InfoItemUtil {
    private static final Log _log = LogFactoryUtil.getLog(InfoItemUtil.class);

    public static ClassPKInfoItemIdentifier getClassPKInfoItemIdentifier(String className, String externalReferenceCode, InfoItemServiceRegistry infoItemServiceRegistry, Scope scope, long scopeGroupId) {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className, ClassPKInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
        InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)infoItemServiceRegistry.getFirstInfoItemService(InfoItemDetailsProvider.class, className, ClassPKInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
        if (infoItemObjectProvider == null || infoItemDetailsProvider == null) {
            return null;
        }
        try {
            Object infoItem = infoItemObjectProvider.getInfoItem(scopeGroupId, (InfoItemIdentifier)new ERCInfoItemIdentifier(externalReferenceCode, ItemScopeUtil.getItemScopeExternalReferenceCode(scope, scopeGroupId)));
            InfoItemDetails infoItemDetails = infoItemDetailsProvider.getInfoItemDetails(scopeGroupId, ClassPKInfoItemIdentifier.class, infoItem);
            if (infoItemDetails == null) {
                return null;
            }
            InfoItemReference infoItemReference = infoItemDetails.getInfoItemReference();
            if (infoItemReference == null) {
                return null;
            }
            return (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            LogUtil.logOptionalReference(className, externalReferenceCode, scope, scopeGroupId);
            return null;
        }
    }

    public static ERCInfoItemIdentifier getERCInfoItemIdentifier(String className, long classPK, InfoItemServiceRegistry infoItemServiceRegistry, long scopeGroupId) {
        InfoItemObjectProvider infoItemObjectProvider = (InfoItemObjectProvider)infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectProvider.class, className, ClassPKInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
        InfoItemDetailsProvider infoItemDetailsProvider = (InfoItemDetailsProvider)infoItemServiceRegistry.getFirstInfoItemService(InfoItemDetailsProvider.class, className, ERCInfoItemIdentifier.INFO_ITEM_SERVICE_FILTER);
        if (infoItemObjectProvider == null || infoItemDetailsProvider == null) {
            return null;
        }
        try {
            Object infoItem = infoItemObjectProvider.getInfoItem(scopeGroupId, (InfoItemIdentifier)new ClassPKInfoItemIdentifier(classPK));
            InfoItemDetails infoItemDetails = infoItemDetailsProvider.getInfoItemDetails(scopeGroupId, ERCInfoItemIdentifier.class, infoItem);
            if (infoItemDetails == null) {
                return null;
            }
            InfoItemReference infoItemReference = infoItemDetails.getInfoItemReference();
            if (infoItemReference == null) {
                return null;
            }
            return (ERCInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return null;
        }
    }

    public static JSONObject getMappedItemJSONObject(String className, String externalReferenceCode, String fieldKey, InfoItemServiceRegistry infoItemServiceRegistry, Scope scope, long scopeGroupId) {
        return JSONUtil.put((String)"className", (Object)className).put("classNameId", PortalUtil.getClassNameId((String)className)).put("classPK", () -> {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = InfoItemUtil.getClassPKInfoItemIdentifier(className, externalReferenceCode, infoItemServiceRegistry, scope, scopeGroupId);
            if (classPKInfoItemIdentifier == null) {
                return null;
            }
            return classPKInfoItemIdentifier.getClassPK();
        }).put("externalReferenceCode", externalReferenceCode).put("fieldId", fieldKey).put("scopeExternalReferenceCode", () -> ItemScopeUtil.getItemScopeExternalReferenceCode(scope, scopeGroupId));
    }
}

