/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstance;
import com.liferay.headless.admin.site.dto.v1_0.WidgetInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPermission;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.FragmentViewportUtil;
import com.liferay.layout.exporter.PortletPermissionsExporter;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import jakarta.portlet.PortletPreferences;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem"}, service={DTOConverter.class})
public class WidgetInstancePageElementDefinitionDTOConverter
implements DTOConverter<FragmentStyledLayoutStructureItem, WidgetInstancePageElementDefinition> {
    @Reference
    private FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private PortletPermissionsExporter _portletPermissionsExporter;

    public String getContentType() {
        return WidgetInstancePageElementDefinition.class.getSimpleName();
    }

    public WidgetInstancePageElementDefinition toDTO(DTOConverterContext dtoConverterContext, FragmentStyledLayoutStructureItem fragmentStyledLayoutStructureItem) throws Exception {
        FragmentEntryLink fragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLink(fragmentStyledLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            throw new UnsupportedOperationException();
        }
        WidgetInstancePageElementDefinition widgetInstancePageElementDefinition = new WidgetInstancePageElementDefinition();
        widgetInstancePageElementDefinition.setCssClasses(() -> {
            Set cssClasses = fragmentStyledLayoutStructureItem.getCssClasses();
            if (SetUtil.isEmpty((Set)cssClasses)) {
                return null;
            }
            return ArrayUtil.toStringArray((Collection)cssClasses);
        });
        widgetInstancePageElementDefinition.setCustomCSS(() -> {
            String customCSS = fragmentStyledLayoutStructureItem.getCustomCSS();
            if (Validator.isNotNull((String)customCSS)) {
                return customCSS;
            }
            return null;
        });
        widgetInstancePageElementDefinition.setDraftWidgetInstanceExternalReferenceCode(() -> {
            FragmentEntryLink originalFragmentEntryLink = this._fragmentEntryLinkLocalService.fetchFragmentEntryLinkByExternalReferenceCode(fragmentEntryLink.getOriginalFragmentEntryLinkERC(), fragmentEntryLink.getGroupId());
            if (originalFragmentEntryLink == null) {
                return null;
            }
            return originalFragmentEntryLink.getExternalReferenceCode();
        });
        widgetInstancePageElementDefinition.setFragmentViewports(() -> FragmentViewportUtil.toFragmentViewports(fragmentStyledLayoutStructureItem.getItemConfigJSONObject()));
        widgetInstancePageElementDefinition.setIndexed(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).isIndexed());
        widgetInstancePageElementDefinition.setName(() -> ((FragmentStyledLayoutStructureItem)fragmentStyledLayoutStructureItem).getName());
        widgetInstancePageElementDefinition.setWidgetInstance(() -> this._getWidgetInstance(fragmentEntryLink));
        widgetInstancePageElementDefinition.setWidgetInstanceExternalReferenceCode(() -> ((FragmentEntryLink)fragmentEntryLink).getExternalReferenceCode());
        return widgetInstancePageElementDefinition;
    }

    private Map<String, Object> _getWidgetConfig(long plid, String portletId) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return null;
        }
        Portlet portlet = this._portletLocalService.getPortletById(PortletIdCodec.decodePortletName((String)portletId));
        if (portlet == null) {
            return null;
        }
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getLayoutPortletSetup((long)layout.getCompanyId(), (long)0L, (int)3, (long)layout.getPlid(), (String)portletId, (String)portlet.getDefaultPreferences());
        if (portletPreferences == null) {
            return null;
        }
        TreeMap<String, Object> portletConfigurationMap = new TreeMap<String, Object>();
        Map portletPreferencesMap = portletPreferences.getMap();
        for (Map.Entry entrySet : portletPreferencesMap.entrySet()) {
            String[] values = (String[])entrySet.getValue();
            if (values == null) {
                portletConfigurationMap.put((String)entrySet.getKey(), "");
                continue;
            }
            if (values.length == 1) {
                portletConfigurationMap.put((String)entrySet.getKey(), values[0]);
                continue;
            }
            portletConfigurationMap.put((String)entrySet.getKey(), values);
        }
        return portletConfigurationMap;
    }

    private WidgetInstance _getWidgetInstance(final FragmentEntryLink fragmentEntryLink) {
        JSONObject jsonObject = fragmentEntryLink.getEditableValuesJSONObject();
        if (JSONUtil.isEmpty((JSONObject)jsonObject) || !jsonObject.has("portletId")) {
            return null;
        }
        final String instanceId = jsonObject.getString("instanceId", null);
        final String portletId = PortletIdCodec.encode((String)jsonObject.getString("portletId"), (String)instanceId);
        return new WidgetInstance(){
            {
                this.setWidgetConfig(() -> WidgetInstancePageElementDefinitionDTOConverter.this._getWidgetConfig(fragmentEntryLink.getPlid(), portletId));
                this.setWidgetInstanceId(() -> instanceId);
                this.setWidgetName(() -> PortletIdCodec.decodePortletName((String)portletId));
                this.setWidgetPermissions(() -> WidgetInstancePageElementDefinitionDTOConverter.this._getWidgetPermissions(fragmentEntryLink.getPlid(), portletId));
            }
        };
    }

    private WidgetPermission[] _getWidgetPermissions(long plid, String portletId) {
        Map permissionsMap = this._portletPermissionsExporter.getPortletPermissions(plid, portletId);
        if (MapUtil.isEmpty((Map)permissionsMap)) {
            return new WidgetPermission[0];
        }
        return (WidgetPermission[])TransformUtil.transformToArray(permissionsMap.entrySet(), entry -> {
            if (ArrayUtil.isEmpty((Object[])((Object[])entry.getValue()))) {
                return null;
            }
            return new WidgetPermission((Map.Entry)entry){
                final /* synthetic */ Map.Entry val$entry;
                {
                    this.val$entry = entry;
                    this.setActionIds(this.val$entry::getValue);
                    this.setRoleName(this.val$entry::getKey);
                }
            };
        }, WidgetPermission.class);
    }
}

