/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.vulcan.batch.engine.ExportImportVulcanBatchEngineTaskItemDelegate;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.CustomMetaTag;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.NavigationSettings;
import com.liferay.headless.admin.site.dto.v1_0.OpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.SEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.Scope;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.SitemapSettings;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.headless.admin.site.internal.odata.entity.v1_0.SitePageEntityModel;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PageSpecificationUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.SitePageResource;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.seo.model.LayoutSEOEntryCustomMetaTagProperty;
import com.liferay.layout.seo.service.LayoutSEOEntryService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, property={"export.import.vulcan.batch.engine.task.item.delegate=true"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl
implements ExportImportVulcanBatchEngineTaskItemDelegate<SitePage> {
    private static final Log _log = LogFactoryUtil.getLog(SitePageResourceImpl.class);
    private static final EntityModel _entityModel = new SitePageEntityModel();
    @Reference
    private CETManager _cetManager;
    @Reference
    private DLFileEntryService _dlFileEntryService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutSEOEntryService _layoutSEOEntryService;
    @Reference
    private LayoutService _layoutService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.SitePageDTOConverter)")
    private DTOConverter<Layout, SitePage> _sitePageDTOConverter;

    @Override
    public void deleteSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        this._layoutService.deleteLayout(layout.getPlid(), ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId()));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) {
        return _entityModel;
    }

    public ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor getExportImportDescriptor() {
        return new ExportImportVulcanBatchEngineTaskItemDelegate.ExportImportDescriptor(){

            public String getItemClassName() {
                return Layout.class.getName();
            }

            public Map<String, Serializable> getParameters(PortletDataContext portletDataContext) {
                return HashMapBuilder.put((Object)"filter", () -> {
                    if (portletDataContext.getLayoutIds() == null || portletDataContext.getLayoutIds().length == 0 || portletDataContext.getLayoutIds().length == 1 && portletDataContext.getLayoutIds()[0] == 0L) {
                        return null;
                    }
                    HashSet<String> layoutExternalReferenceCodes = new HashSet<String>();
                    for (long layoutId : portletDataContext.getLayoutIds()) {
                        Layout layout;
                        block4: {
                            layout = null;
                            try {
                                layout = SitePageResourceImpl.this._layoutService.fetchLayout(portletDataContext.getScopeGroupId(), portletDataContext.isPrivateLayout(), layoutId);
                            }
                            catch (PortalException portalException) {
                                if (!_log.isWarnEnabled()) break block4;
                                _log.warn((Throwable)portalException);
                            }
                        }
                        if (layout == null) continue;
                        layoutExternalReferenceCodes.add(layout.getExternalReferenceCode());
                    }
                    StringBundler sb = new StringBundler(3);
                    sb.append("externalReferenceCode in ('");
                    sb.append(ListUtil.toString((List)ListUtil.fromCollection(layoutExternalReferenceCodes), (String)"", (String)"', '"));
                    sb.append("')");
                    return sb.toString();
                }).build();
            }

            public String getPortletId() {
                return "com_liferay_layout_admin_web_portlet_LayoutSetLayoutsPortlet";
            }

            public ExportImportVulcanBatchEngineTaskItemDelegate.Scope getScope() {
                return ExportImportVulcanBatchEngineTaskItemDelegate.Scope.SITE;
            }

            public boolean isActive(PortletDataContext portletDataContext) {
                return !portletDataContext.isPrivateLayout() && FeatureFlagManagerUtil.isEnabled((String)"LPD-35443");
            }
        };
    }

    @Override
    public ContentPageSpecification postSiteSitePagePageSpecification(String siteExternalReferenceCode, String sitePageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!layout.isTypeContent()) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(this._cetManager, contentPageSpecification, this._infoItemServiceRegistry, layout, ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public Page<SitePage> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return super.read(filter, pagination, sorts, parameters, search);
    }

    @Override
    protected SitePage doGetSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        return this._toSitePage(layout);
    }

    @Override
    protected Page<SitePage> doGetSiteSitePagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return SearchUtil.search(null, booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("groupId", String.valueOf(groupId)), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)Layout.class.getName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("title", (Serializable)((Object)search));
            searchContext.setAttribute("type", (Serializable)new String[]{"content", "portlet"});
            searchContext.setAttribute("privateLayout", (Serializable)((Object)Boolean.FALSE.toString()));
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("systemLayout", (Serializable)((Object)Boolean.FALSE.toString()));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{groupId});
            searchContext.setKeywords(search);
        }, (Sort[])sorts, document -> {
            long plid = GetterUtil.getLong((String)document.get("entryClassPK"));
            return this._toSitePage(this._layoutLocalService.getLayout(plid));
        });
    }

    @Override
    protected SitePage doPostSiteSitePage(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._addLayout(sitePage.getExternalReferenceCode(), GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), sitePage));
    }

    @Override
    protected SitePage doPutSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, groupId);
        if (layout == null) {
            return this._toSitePage(this._addLayout(sitePageExternalReferenceCode, groupId, sitePage));
        }
        this._validateSitePageLayout(layout);
        if (sitePage.getType() != null && !Objects.equals(layout.getType(), SitePageTypeUtil.toInternalType(sitePage.getType()))) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._updateLayout(layout, sitePage));
    }

    @Override
    protected Long getPermissionCheckerResourceId(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(externalReferenceCode, this.getPermissionCheckerGroupId(groupExternalReferenceCode).longValue());
        return layout.getPrimaryKey();
    }

    @Override
    protected String getPermissionCheckerResourceName(String groupExternalReferenceCode, String externalReferenceCode) throws Exception {
        return Layout.class.getName();
    }

    @Override
    protected void preparePatch(SitePage sitePage, SitePage existingSitePage) {
        if (sitePage.getPageSettings() != null) {
            existingSitePage.setPageSettings(() -> ((SitePage)sitePage).getPageSettings());
        }
        if (sitePage.getPageSpecifications() != null) {
            existingSitePage.setPageSpecifications(() -> ((SitePage)sitePage).getPageSpecifications());
        }
    }

    private Layout _addLayout(String externalReferenceCode, long groupId, SitePage sitePage) throws Exception {
        PageSettings pageSettings;
        if (sitePage.getExternalReferenceCode() == null) {
            sitePage.setExternalReferenceCode(() -> externalReferenceCode);
        }
        if (!Objects.equals(externalReferenceCode, sitePage.getExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(sitePage.getTaxonomyCategoryItemExternalReferences(), this.contextCompany.getCompanyId(), sitePage.getDateCreated(), groupId, this.contextHttpServletRequest, sitePage.getKeywords(), sitePage.getDateModified(), this.contextUser.getUserId(), sitePage.getUuid(), sitePage.getPageSettings());
        this._validatePageSpecificationExternalReferenceCode(serviceContext, sitePage);
        Map nameMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n());
        HashMap<Locale, String> titleMap = new HashMap();
        HashMap<Locale, String> descriptionMap = new HashMap();
        HashMap<Locale, String> keywordsMap = new HashMap();
        HashMap<Locale, String> robotsMap = new HashMap();
        if (sitePage.getPageSettings() != null && (pageSettings = sitePage.getPageSettings()).getSeoSettings() != null) {
            SEOSettings seoSettings = pageSettings.getSeoSettings();
            titleMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getHtmlTitle_i18n());
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getDescription_i18n());
            keywordsMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getSeoKeywords_i18n());
            robotsMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getRobots_i18n());
        }
        UnicodeProperties typeSettingsUnicodeProperties = this._getTypeSettingsUnicodeProperties(sitePage);
        Layout layout = null;
        layout = Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) ? LayoutUtil.addContentLayout(this._cetManager, groupId, this._infoItemServiceRegistry, sitePage.getPageSpecifications(), this._getParentLayoutId(0L, groupId, sitePage.getParentSitePageExternalReferenceCode(), serviceContext), false, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, SitePageTypeUtil.toInternalType(sitePage.getType()), typeSettingsUnicodeProperties, this._isHiddenFromNavigation(false, sitePage.getPageSettings()), false, LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), 0, serviceContext) : LayoutUtil.addPortletLayout(this._cetManager, sitePage.getExternalReferenceCode(), this._infoItemServiceRegistry, groupId, this._getParentLayoutId(0L, groupId, sitePage.getParentSitePageExternalReferenceCode(), serviceContext), nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, typeSettingsUnicodeProperties, this._isHiddenFromNavigation(false, sitePage.getPageSettings()), LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), serviceContext, PageSpecificationUtil.getWidgetPageSpecification(sitePage.getPageSpecifications()));
        PageSettings pageSettings2 = sitePage.getPageSettings();
        this._updateSEOEntry(layout.getGroupId(), layout.getLayoutId(), pageSettings2, serviceContext);
        if (pageSettings2 != null && pageSettings2.getPriority() != null) {
            layout = this._layoutService.updatePriority(layout.getPlid(), pageSettings2.getPriority().intValue());
        }
        return layout;
    }

    private long _getFileEntryId(ItemExternalReference itemExternalReference, ServiceContext serviceContext) throws Exception {
        DLFileEntry dlFileEntry;
        long groupId = serviceContext.getScopeGroupId();
        Scope scope = itemExternalReference.getScope();
        if (scope != null) {
            groupId = GroupUtil.getGroupId(true, true, serviceContext.getCompanyId(), scope.getExternalReferenceCode());
        }
        if ((dlFileEntry = this._dlFileEntryService.fetchFileEntryByExternalReferenceCode(groupId, itemExternalReference.getExternalReferenceCode())) == null) {
            throw new UnsupportedOperationException();
        }
        return dlFileEntry.getFileEntryId();
    }

    private long _getParentLayoutId(long defaultParentLayoutId, long groupId, String parentSitePageExternalReferenceCode, ServiceContext serviceContext) throws Exception {
        if (parentSitePageExternalReferenceCode == null) {
            return defaultParentLayoutId;
        }
        if (Validator.isNull((String)parentSitePageExternalReferenceCode)) {
            return 0L;
        }
        Layout layout = this._layoutService.getOrAddEmptyLayout(parentSitePageExternalReferenceCode, groupId, serviceContext);
        return layout.getLayoutId();
    }

    private UnicodeProperties _getTypeSettingsUnicodeProperties(SitePage sitePage) {
        Object[] customizableSectionIds;
        SitemapSettings sitemapSettings;
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings == null) {
            return null;
        }
        if (sitePage.getType() == SitePage.Type.CONTENT_PAGE && !(pageSettings instanceof ContentPageSettings)) {
            throw new UnsupportedOperationException();
        }
        if (sitePage.getType() == SitePage.Type.WIDGET_PAGE && !(pageSettings instanceof WidgetPageSettings)) {
            throw new UnsupportedOperationException();
        }
        String target = "";
        String targetTypeString = "";
        NavigationSettings navigationSettings = pageSettings.getNavigationSettings();
        if (navigationSettings != null) {
            target = navigationSettings.getTarget();
            NavigationSettings.TargetType targetType = navigationSettings.getTargetType();
            if (targetType == NavigationSettings.TargetType.NEW_TAB) {
                targetTypeString = "useNewTab";
            }
        }
        SitemapSettings.ChangeFrequency changeFrequency = SitemapSettings.ChangeFrequency.DAILY;
        String sitemapInclude = "1";
        String sitemapIncludeChildLayouts = "true";
        String sitemapPagePriority = "0.0";
        SEOSettings seoSettings = pageSettings.getSeoSettings();
        if (seoSettings != null && (sitemapSettings = seoSettings.getSitemapSettings()) != null) {
            if (sitemapSettings.getChangeFrequency() != null) {
                changeFrequency = sitemapSettings.getChangeFrequency();
            }
            if (Boolean.FALSE.equals(sitemapSettings.getInclude())) {
                sitemapInclude = "0";
            }
            if (Boolean.FALSE.equals(sitemapSettings.getIncludeChildSitePages())) {
                sitemapIncludeChildLayouts = "false";
            }
            if (sitemapSettings.getPagePriority() != null) {
                sitemapPagePriority = String.valueOf(sitemapSettings.getPagePriority());
            }
        }
        UnicodePropertiesBuilder.UnicodePropertiesWrapper unicodePropertiesWrapper = UnicodePropertiesBuilder.create((boolean)true).setProperty("query-string", GetterUtil.getString((String)pageSettings.getQueryString())).setProperty("sitemap-changefreq", StringUtil.toLowerCase((String)changeFrequency.getValue())).setProperty("sitemap-include", sitemapInclude).setProperty("sitemap-priority", sitemapPagePriority).setProperty("target", target).setProperty("sitemap-include-child-layouts", sitemapIncludeChildLayouts).setProperty("targetType", targetTypeString);
        if (sitePage.getType() == SitePage.Type.CONTENT_PAGE) {
            return unicodePropertiesWrapper.build();
        }
        WidgetPageSettings widgetPageSettings = (WidgetPageSettings)pageSettings;
        unicodePropertiesWrapper.setProperty("CUSTOMIZABLE_LAYOUT", String.valueOf(GetterUtil.getBoolean((Object)widgetPageSettings.getCustomizable())));
        if (widgetPageSettings.getLayoutTemplateId() != null) {
            unicodePropertiesWrapper.setProperty("layout-template-id", widgetPageSettings.getLayoutTemplateId());
        }
        if (ArrayUtil.isEmpty((Object[])(customizableSectionIds = widgetPageSettings.getCustomizableSectionIds()))) {
            return unicodePropertiesWrapper.build();
        }
        for (Object customizableSectionId : customizableSectionIds) {
            unicodePropertiesWrapper.setProperty(CustomizedPages.namespaceColumnId((String)customizableSectionId), "true");
        }
        return unicodePropertiesWrapper.build();
    }

    private boolean _isHiddenFromNavigation(boolean defaultValue, PageSettings pageSettings) {
        if (pageSettings == null) {
            return defaultValue;
        }
        return GetterUtil.getBoolean((Object)pageSettings.getHiddenFromNavigation(), (boolean)defaultValue);
    }

    private SitePage _toSitePage(Layout layout) throws Exception {
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)layout);
    }

    private Layout _updateLayout(Layout layout, SitePage sitePage) throws Exception {
        PageSettings pageSettings;
        Map nameMap = layout.getNameMap();
        if (sitePage.getName_i18n() != null) {
            nameMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n());
        }
        HashMap<Locale, String> titleMap = new HashMap();
        HashMap<Locale, String> descriptionMap = new HashMap();
        HashMap<Locale, String> keywordsMap = new HashMap();
        HashMap<Locale, String> robotsMap = new HashMap();
        if (sitePage.getPageSettings() != null && (pageSettings = sitePage.getPageSettings()).getSeoSettings() != null) {
            SEOSettings seoSettings = pageSettings.getSeoSettings();
            titleMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getHtmlTitle_i18n());
            descriptionMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getDescription_i18n());
            keywordsMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getSeoKeywords_i18n());
            robotsMap = LocalizedMapUtil.getLocalizedMap((Map)seoSettings.getRobots_i18n());
        }
        Map friendlyURLMap = layout.getFriendlyURLMap();
        if (sitePage.getFriendlyUrlPath_i18n() != null) {
            friendlyURLMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n());
        }
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(sitePage.getTaxonomyCategoryItemExternalReferences(), this.contextCompany.getCompanyId(), sitePage.getDateCreated(), layout.getGroupId(), this.contextHttpServletRequest, sitePage.getKeywords(), sitePage.getDateModified(), this.contextUser.getUserId(), sitePage.getUuid(), sitePage.getPageSettings());
        serviceContext.setAttribute("hidden", (Serializable)Boolean.valueOf(this._isHiddenFromNavigation(layout.isHidden(), sitePage.getPageSettings())));
        serviceContext.setAttribute("parentLayoutId", (Serializable)Long.valueOf(this._getParentLayoutId(layout.getParentLayoutId(), layout.getGroupId(), sitePage.getParentSitePageExternalReferenceCode(), serviceContext)));
        layout = Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) ? LayoutUtil.updateContentLayout(this._cetManager, this._infoItemServiceRegistry, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, this._getTypeSettingsUnicodeProperties(sitePage), sitePage.getPageSpecifications(), serviceContext) : LayoutUtil.updatePortletLayout(this._cetManager, layout, nameMap, titleMap, descriptionMap, keywordsMap, robotsMap, friendlyURLMap, this._getTypeSettingsUnicodeProperties(sitePage), serviceContext, PageSpecificationUtil.getWidgetPageSpecification(sitePage.getPageSpecifications()));
        PageSettings pageSettings2 = sitePage.getPageSettings();
        this._updateSEOEntry(layout.getGroupId(), layout.getLayoutId(), pageSettings2, serviceContext);
        int priority = Integer.MAX_VALUE;
        if (pageSettings2 != null && pageSettings2.getPriority() != null) {
            priority = pageSettings2.getPriority();
        }
        if (layout.getPriority() == priority) {
            return layout;
        }
        return this._layoutService.updatePriority(layout.getPlid(), priority);
    }

    private void _updateSEOEntry(long groupId, long layoutId, PageSettings pageSettings, ServiceContext serviceContext) throws Exception {
        SEOSettings seoSettings;
        boolean canonicalURLEnabled = false;
        Map canonicalURLMap = new HashMap();
        if (pageSettings != null && pageSettings.getSeoSettings() != null && MapUtil.isNotEmpty(canonicalURLMap = LocalizedMapUtil.getLocalizedMap((Map)(seoSettings = pageSettings.getSeoSettings()).getCustomCanonicalURL_i18n()))) {
            canonicalURLEnabled = true;
        }
        boolean openGraphDescriptionEnabled = false;
        Map openGraphDescriptionMap = new HashMap();
        Map openGraphImageAltMap = new HashMap();
        long openGraphImageFileEntryId = 0L;
        boolean openGraphTitleEnabled = false;
        Map openGraphTitleMap = new HashMap();
        if (pageSettings != null && pageSettings.getOpenGraphSettings() != null) {
            OpenGraphSettings openGraphSettings = pageSettings.getOpenGraphSettings();
            openGraphDescriptionMap = LocalizedMapUtil.getLocalizedMap((Map)openGraphSettings.getDescription_i18n());
            if (MapUtil.isNotEmpty(openGraphDescriptionMap)) {
                openGraphDescriptionEnabled = true;
            }
            openGraphImageAltMap = LocalizedMapUtil.getLocalizedMap((Map)openGraphSettings.getImageAlt_i18n());
            ItemExternalReference itemExternalReference = openGraphSettings.getImage();
            if (itemExternalReference != null) {
                openGraphImageFileEntryId = this._getFileEntryId(itemExternalReference, serviceContext);
            }
            if (MapUtil.isNotEmpty(openGraphTitleMap = LocalizedMapUtil.getLocalizedMap((Map)openGraphSettings.getTitle_i18n()))) {
                openGraphTitleEnabled = true;
            }
        }
        this._layoutSEOEntryService.updateLayoutSEOEntry(groupId, false, layoutId, canonicalURLEnabled, canonicalURLMap, openGraphDescriptionEnabled, openGraphDescriptionMap, openGraphImageAltMap, openGraphImageFileEntryId, openGraphTitleEnabled, openGraphTitleMap, serviceContext);
        CustomMetaTag[] customMetaTags = new CustomMetaTag[]{};
        if (pageSettings != null) {
            customMetaTags = pageSettings.getCustomMetaTags();
        }
        this._layoutSEOEntryService.updateCustomMetaTags(groupId, false, layoutId, this.transformToList(customMetaTags, customMetaTag -> new LayoutSEOEntryCustomMetaTagProperty(LocalizedMapUtil.getLocalizedMap((Map)customMetaTag.getValue_i18n()), customMetaTag.getKey())), serviceContext);
    }

    private void _validatePageSpecificationExternalReferenceCode(ServiceContext serviceContext, SitePage sitePage) {
        Object[] pageSpecifications = sitePage.getPageSpecifications();
        if (ArrayUtil.isEmpty((Object[])pageSpecifications)) {
            serviceContext.setAttribute("layoutExternalReferenceCode", (Serializable)((Object)sitePage.getExternalReferenceCode()));
            return;
        }
        Object publishedPageSpecification = null;
        if (Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) && pageSpecifications.length == 2) {
            ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
            if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
                publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
            }
            publishedPageSpecification = publishedContentPageSpecification;
        } else if (Objects.equals(sitePage.getType(), SitePage.Type.WIDGET_PAGE) && pageSpecifications.length == 1) {
            publishedPageSpecification = pageSpecifications[0];
        } else {
            throw new UnsupportedOperationException();
        }
        if (publishedPageSpecification.getExternalReferenceCode() != null && !Objects.equals(sitePage.getExternalReferenceCode(), publishedPageSpecification.getExternalReferenceCode())) {
            throw new ValidationException(StringBundler.concat((String[])new String[]{"Site page external reference code ", sitePage.getExternalReferenceCode(), " does not match published page specification external ", "reference code ", publishedPageSpecification.getExternalReferenceCode()}));
        }
        publishedPageSpecification.setExternalReferenceCode(() -> ((SitePage)sitePage).getExternalReferenceCode());
    }

    private void _validateSitePageLayout(Layout layout) {
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
    }
}

