/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.CollectionItemPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.CollectionPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.ColumnPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.ContainerPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.DropZonePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FormPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FormStepContainerPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FormStepPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentDropZonePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.FragmentInstancePageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.RowPageElementDefinition;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FormStepContainerStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FormStyledLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentDropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentStyledLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RowStyledLayoutStructureItem;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.LayoutStructureItem"}, service={DTOConverter.class})
public class PageElementDTOConverter
implements DTOConverter<LayoutStructureItem, PageElement> {
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.CollectionPageElementDefinitionDTOConverter)")
    private DTOConverter<CollectionStyledLayoutStructureItem, CollectionPageElementDefinition> _collectionPageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.ColumnPageElementDefinitionDTOConverter)")
    private DTOConverter<ColumnLayoutStructureItem, ColumnPageElementDefinition> _columnPageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.ContainerPageElementDefinitionDTOConverter)")
    private DTOConverter<ContainerStyledLayoutStructureItem, ContainerPageElementDefinition> _containerPageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.FormPageElementDefinitionDTOConverter)")
    private DTOConverter<FormStyledLayoutStructureItem, FormPageElementDefinition> _formPageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.FormStepContainerPageElementDefinitionDTOConverter)")
    private DTOConverter<FormStepContainerStyledLayoutStructureItem, FormStepContainerPageElementDefinition> _formStepContainerPageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.FragmentDropZonePageElementDefinitionDTOConverter)")
    private DTOConverter<FragmentDropZoneLayoutStructureItem, FragmentDropZonePageElementDefinition> _fragmentDropZonePageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.FragmentInstancePageElementDefinitionDTOConverter)")
    private DTOConverter<FragmentStyledLayoutStructureItem, FragmentInstancePageElementDefinition> _fragmentInstancePageElementDefinitionDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.RowPageElementDefinitionDTOConverter)")
    private DTOConverter<RowStyledLayoutStructureItem, RowPageElementDefinition> _rowPageElementDefinitionDTOConverter;

    public String getContentType() {
        return PageElement.class.getSimpleName();
    }

    public PageElement toDTO(final DTOConverterContext dtoConverterContext, final LayoutStructureItem layoutStructureItem) throws Exception {
        if (dtoConverterContext == null) {
            throw new UnsupportedOperationException();
        }
        final LayoutStructure layoutStructure = (LayoutStructure)dtoConverterContext.getAttribute(LayoutStructure.class.getName());
        if (layoutStructure == null) {
            throw new UnsupportedOperationException();
        }
        return new PageElement(){
            {
                this.setExternalReferenceCode(() -> ((LayoutStructureItem)layoutStructureItem).getItemId());
                this.setPageElementDefinition(() -> PageElementDTOConverter.this._getPageElementDefinition(dtoConverterContext, layoutStructureItem));
                this.setPageElements(() -> PageElementDTOConverter.this._getPageElements(dtoConverterContext, layoutStructure, layoutStructureItem));
                this.setParentExternalReferenceCode(() -> {
                    if (Objects.equals(layoutStructure.getMainItemId(), layoutStructureItem.getParentItemId())) {
                        return "";
                    }
                    return layoutStructureItem.getParentItemId();
                });
                this.setPosition(() -> {
                    LayoutStructureItem parentLayoutStructureItem = layoutStructure.getLayoutStructureItem(layoutStructureItem.getParentItemId());
                    List childrenItemIds = parentLayoutStructureItem.getChildrenItemIds();
                    return childrenItemIds.indexOf(layoutStructureItem.getItemId());
                });
            }
        };
    }

    private PageElementDefinition _getPageElementDefinition(DTOConverterContext dtoConverterContext, LayoutStructureItem layoutStructureItem) throws Exception {
        if (Objects.equals(layoutStructureItem.getItemType(), "collection")) {
            return (PageElementDefinition)this._collectionPageElementDefinitionDTOConverter.toDTO((Object)((CollectionStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "collection-item")) {
            CollectionItemPageElementDefinition collectionItemPageElementDefinition = new CollectionItemPageElementDefinition();
            collectionItemPageElementDefinition.setType(PageElementDefinition.Type.COLLECTION_ITEM);
            return collectionItemPageElementDefinition;
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "column")) {
            return (PageElementDefinition)this._columnPageElementDefinitionDTOConverter.toDTO((Object)((ColumnLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "container")) {
            return (PageElementDefinition)this._containerPageElementDefinitionDTOConverter.toDTO(dtoConverterContext, (Object)((ContainerStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "drop-zone")) {
            DropZonePageElementDefinition dropZonePageElementDefinition = new DropZonePageElementDefinition();
            dropZonePageElementDefinition.setType(PageElementDefinition.Type.DROP_ZONE);
            return dropZonePageElementDefinition;
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form")) {
            return (PageElementDefinition)this._formPageElementDefinitionDTOConverter.toDTO((Object)((FormStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form-step")) {
            FormStepPageElementDefinition formStepPageElementDefinition = new FormStepPageElementDefinition();
            formStepPageElementDefinition.setType(PageElementDefinition.Type.FORM_STEP);
            return formStepPageElementDefinition;
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "form-step-container")) {
            return (PageElementDefinition)this._formStepContainerPageElementDefinitionDTOConverter.toDTO((Object)((FormStepContainerStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment")) {
            return (PageElementDefinition)this._fragmentInstancePageElementDefinitionDTOConverter.toDTO((Object)((FragmentStyledLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "fragment-drop-zone")) {
            return (PageElementDefinition)this._fragmentDropZonePageElementDefinitionDTOConverter.toDTO((Object)((FragmentDropZoneLayoutStructureItem)layoutStructureItem));
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "root")) {
            throw new UnsupportedOperationException();
        }
        if (Objects.equals(layoutStructureItem.getItemType(), "row")) {
            return (PageElementDefinition)this._rowPageElementDefinitionDTOConverter.toDTO((Object)((RowStyledLayoutStructureItem)layoutStructureItem));
        }
        throw new UnsupportedOperationException();
    }

    private PageElement[] _getPageElements(DTOConverterContext dtoConverterContext, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem) {
        return (PageElement[])TransformUtil.transformToArray((Collection)layoutStructureItem.getChildrenItemIds(), childrenItemId -> this.toDTO(dtoConverterContext, layoutStructure.getLayoutStructureItem(childrenItemId)), PageElement.class);
    }
}

