/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PageSpecificationUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.SitePageResource;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.CustomizedPages;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.NotSupportedException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl {
    @Reference
    private CETManager _cetManager;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.SitePageDTOConverter)")
    private DTOConverter<Layout, SitePage> _sitePageDTOConverter;

    @Override
    public void deleteSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        this._layoutService.deleteLayout(layout.getPlid(), ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId()));
    }

    @Override
    public SitePage getSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        return this._toSitePage(layout);
    }

    @Override
    public Page<SitePage> getSiteSitePagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutService.getLayouts(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), false, search, new String[]{"content", "portlet"}, null, pagination.getStartPosition(), pagination.getEndPosition(), null), layout -> this._toSitePage((Layout)layout)), (Pagination)pagination, (long)this._layoutService.getLayoutsCount(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), false, search, new String[]{"content", "portlet"}, null));
    }

    @Override
    public SitePage postSiteSitePage(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._addLayout(sitePage.getExternalReferenceCode(), GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), sitePage));
    }

    @Override
    public ContentPageSpecification postSiteSitePagePageSpecification(String siteExternalReferenceCode, String sitePageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!layout.isTypeContent()) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(this._cetManager, contentPageSpecification, layout, ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public SitePage putSiteSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, groupId);
        if (layout == null) {
            return this._toSitePage(this._addLayout(sitePageExternalReferenceCode, groupId, sitePage));
        }
        this._validateSitePageLayout(layout);
        if (sitePage.getType() != null && !Objects.equals(layout.getType(), SitePageTypeUtil.toInternalType(sitePage.getType()))) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._updateLayout(layout, sitePage));
    }

    @Override
    public Page<SitePage> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        if (parameters.containsKey("siteId")) {
            Group group = this._groupLocalService.getGroup(((Long)parameters.get("siteId")).longValue());
            return this.getSiteSitePagesPage(group.getExternalReferenceCode(), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId]");
    }

    @Override
    protected void preparePatch(SitePage sitePage, SitePage existingSitePage) {
        if (sitePage.getPageSettings() != null) {
            existingSitePage.setPageSettings(() -> ((SitePage)sitePage).getPageSettings());
        }
        if (sitePage.getPageSpecifications() != null) {
            existingSitePage.setPageSpecifications(() -> ((SitePage)sitePage).getPageSpecifications());
        }
    }

    private Layout _addLayout(String externalReferenceCode, long groupId, SitePage sitePage) throws Exception {
        if (sitePage.getExternalReferenceCode() == null) {
            sitePage.setExternalReferenceCode(() -> externalReferenceCode);
        }
        if (!Objects.equals(externalReferenceCode, sitePage.getExternalReferenceCode())) {
            throw new UnsupportedOperationException();
        }
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(sitePage.getTaxonomyCategoryItemExternalReferences(), this.contextCompany.getCompanyId(), sitePage.getDateCreated(), groupId, this.contextHttpServletRequest, sitePage.getKeywords(), sitePage.getDateModified(), this.contextUser.getUserId(), sitePage.getUuid());
        this._validatePageSpecificationExternalReferenceCode(serviceContext, sitePage);
        Map nameMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n());
        UnicodeProperties typeSettingsUnicodeProperties = this._getTypeSettingsUnicodeProperties(sitePage);
        Layout layout = null;
        layout = Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) ? LayoutUtil.addContentLayout(this._cetManager, groupId, sitePage.getPageSpecifications(), this._getParentLayoutId(0L, groupId, sitePage.getParentSitePageExternalReferenceCode(), serviceContext), false, nameMap, null, null, null, SitePageTypeUtil.toInternalType(sitePage.getType()), typeSettingsUnicodeProperties, this._isHiddenFromNavigation(false, sitePage.getPageSettings()), false, LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), 0, serviceContext) : LayoutUtil.addPortletLayout(this._cetManager, sitePage.getExternalReferenceCode(), groupId, this._getParentLayoutId(0L, groupId, sitePage.getParentSitePageExternalReferenceCode(), serviceContext), nameMap, typeSettingsUnicodeProperties, this._isHiddenFromNavigation(false, sitePage.getPageSettings()), LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), serviceContext, PageSpecificationUtil.getWidgetPageSpecification(sitePage.getPageSpecifications()));
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings != null && pageSettings.getPriority() != null) {
            layout = this._layoutService.updatePriority(layout.getPlid(), pageSettings.getPriority().intValue());
        }
        return layout;
    }

    private long _getParentLayoutId(long defaultParentLayoutId, long groupId, String parentSitePageExternalReferenceCode, ServiceContext serviceContext) throws Exception {
        if (parentSitePageExternalReferenceCode == null) {
            return defaultParentLayoutId;
        }
        if (Validator.isNull((String)parentSitePageExternalReferenceCode)) {
            return 0L;
        }
        Layout layout = this._layoutService.getOrAddEmptyLayout(parentSitePageExternalReferenceCode, groupId, serviceContext);
        return layout.getLayoutId();
    }

    private UnicodeProperties _getTypeSettingsUnicodeProperties(SitePage sitePage) {
        Object[] customizableSectionIds;
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings == null) {
            return null;
        }
        if (sitePage.getType() == SitePage.Type.CONTENT_PAGE) {
            if (!(pageSettings instanceof ContentPageSettings)) {
                throw new UnsupportedOperationException();
            }
            return null;
        }
        if (sitePage.getType() != SitePage.Type.WIDGET_PAGE || !(pageSettings instanceof WidgetPageSettings)) {
            throw new UnsupportedOperationException();
        }
        WidgetPageSettings widgetPageSettings = (WidgetPageSettings)pageSettings;
        UnicodePropertiesBuilder.UnicodePropertiesWrapper unicodePropertiesWrapper = UnicodePropertiesBuilder.create((boolean)true).setProperty("CUSTOMIZABLE_LAYOUT", String.valueOf(GetterUtil.getBoolean((Object)widgetPageSettings.getCustomizable())));
        if (widgetPageSettings.getLayoutTemplateId() != null) {
            unicodePropertiesWrapper.setProperty("layout-template-id", widgetPageSettings.getLayoutTemplateId());
        }
        if (ArrayUtil.isEmpty((Object[])(customizableSectionIds = widgetPageSettings.getCustomizableSectionIds()))) {
            return unicodePropertiesWrapper.build();
        }
        for (Object customizableSectionId : customizableSectionIds) {
            unicodePropertiesWrapper.setProperty(CustomizedPages.namespaceColumnId((String)customizableSectionId), "true");
        }
        return unicodePropertiesWrapper.build();
    }

    private boolean _isHiddenFromNavigation(boolean defaultValue, PageSettings pageSettings) {
        if (pageSettings == null) {
            return defaultValue;
        }
        return GetterUtil.getBoolean((Object)pageSettings.getHiddenFromNavigation(), (boolean)defaultValue);
    }

    private SitePage _toSitePage(Layout layout) throws Exception {
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)layout);
    }

    private Layout _updateLayout(Layout layout, SitePage sitePage) throws Exception {
        Map nameMap = layout.getNameMap();
        if (sitePage.getName_i18n() != null) {
            nameMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n());
        }
        Map friendlyURLMap = layout.getFriendlyURLMap();
        if (sitePage.getFriendlyUrlPath_i18n() != null) {
            friendlyURLMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n());
        }
        ServiceContext serviceContext = ServiceContextUtil.createServiceContext(sitePage.getTaxonomyCategoryItemExternalReferences(), this.contextCompany.getCompanyId(), sitePage.getDateCreated(), layout.getGroupId(), this.contextHttpServletRequest, sitePage.getKeywords(), sitePage.getDateModified(), this.contextUser.getUserId(), sitePage.getUuid());
        serviceContext.setAttribute("hidden", (Serializable)Boolean.valueOf(this._isHiddenFromNavigation(layout.isHidden(), sitePage.getPageSettings())));
        serviceContext.setAttribute("parentLayoutId", (Serializable)Long.valueOf(this._getParentLayoutId(layout.getParentLayoutId(), layout.getGroupId(), sitePage.getParentSitePageExternalReferenceCode(), serviceContext)));
        layout = Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) ? LayoutUtil.updateContentLayout(this._cetManager, layout, nameMap, layout.getTitleMap(), layout.getDescriptionMap(), layout.getRobotsMap(), friendlyURLMap, sitePage.getPageSpecifications(), serviceContext) : LayoutUtil.updatePortletLayout(this._cetManager, layout, nameMap, friendlyURLMap, this._getTypeSettingsUnicodeProperties(sitePage), serviceContext, PageSpecificationUtil.getWidgetPageSpecification(sitePage.getPageSpecifications()));
        int priority = Integer.MAX_VALUE;
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings != null && pageSettings.getPriority() != null) {
            priority = pageSettings.getPriority();
        }
        if (layout.getPriority() == priority) {
            return layout;
        }
        return this._layoutService.updatePriority(layout.getPlid(), priority);
    }

    private void _validatePageSpecificationExternalReferenceCode(ServiceContext serviceContext, SitePage sitePage) {
        Object[] pageSpecifications = sitePage.getPageSpecifications();
        if (ArrayUtil.isEmpty((Object[])pageSpecifications)) {
            serviceContext.setAttribute("layoutExternalReferenceCode", (Serializable)((Object)sitePage.getExternalReferenceCode()));
            return;
        }
        Object publishedPageSpecification = null;
        if (Objects.equals(sitePage.getType(), SitePage.Type.CONTENT_PAGE) && pageSpecifications.length == 2) {
            ContentPageSpecification publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[0];
            if (Validator.isNull((String)publishedContentPageSpecification.getDraftContentPageSpecificationExternalReferenceCode())) {
                publishedContentPageSpecification = (ContentPageSpecification)pageSpecifications[1];
            }
            publishedPageSpecification = publishedContentPageSpecification;
        } else if (Objects.equals(sitePage.getType(), SitePage.Type.WIDGET_PAGE) && pageSpecifications.length == 1) {
            publishedPageSpecification = pageSpecifications[0];
        } else {
            throw new UnsupportedOperationException();
        }
        if (publishedPageSpecification.getExternalReferenceCode() != null && !Objects.equals(sitePage.getExternalReferenceCode(), publishedPageSpecification.getExternalReferenceCode())) {
            throw new ValidationException(StringBundler.concat((String[])new String[]{"Site page external reference code ", sitePage.getExternalReferenceCode(), " does not match published page specification external ", "reference code ", publishedPageSpecification.getExternalReferenceCode()}));
        }
        publishedPageSpecification.setExternalReferenceCode(() -> ((SitePage)sitePage).getExternalReferenceCode());
    }

    private void _validateSitePageLayout(Layout layout) {
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
    }
}

