/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.PageElement;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageExperienceResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.LayoutStructureItemImporter;
import com.liferay.headless.admin.site.internal.resource.v1_0.layout.structure.item.importer.context.LayoutStructureItemImporterContext;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutStructureItemImporterUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.SegmentsExperienceUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.PageExperienceResource;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.segments.exception.NoSuchExperienceException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsExperienceService;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-experience.properties"}, scope=ServiceScope.PROTOTYPE, service={PageExperienceResource.class})
public class PageExperienceResourceImpl
extends BasePageExperienceResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageExperienceDTOConverter)")
    private DTOConverter<LayoutPageTemplateStructureRel, PageExperience> _pageExperienceDTOConverter;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;

    @Override
    public void deleteSitePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode) throws Exception {
        FeatureFlagManagerUtil.checkEnabled((String)"LPD-35443");
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        SegmentsExperience segmentsExperience = this._segmentsExperienceService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            throw new NoSuchExperienceException();
        }
        Layout layout = this._layoutLocalService.fetchLayout(segmentsExperience.getPlid());
        if (!layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        this._segmentsExperienceService.deleteSegmentsExperience(pageExperienceExternalReferenceCode, groupId);
    }

    @Override
    public PageExperience getSitePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._toPageExperience(this._segmentsExperienceService.getSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode)));
    }

    @Override
    public Page<PageExperience> getSitePageSpecificationPageExperiencesPage(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout == null) {
            return Page.of(Collections.emptyList());
        }
        return Page.of(this.transform(this._segmentsExperienceService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true, -1, -1, null), this::_toPageExperience));
    }

    @Override
    public PageExperience postSitePageSpecificationPageExperience(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, PageExperience pageExperience) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageExperience.getPageSpecificationExternalReferenceCode(), groupId);
        if (!layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        return this._addPageExperience(groupId, pageExperience);
    }

    @Override
    public PageExperience putSitePageExperience(String siteExternalReferenceCode, String pageExperienceExternalReferenceCode, PageExperience pageExperience) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageExperience.getPageSpecificationExternalReferenceCode(), groupId);
        if (!layout.isDraftLayout()) {
            throw new UnsupportedOperationException();
        }
        SegmentsExperience segmentsExperience = this._segmentsExperienceService.fetchSegmentsExperienceByExternalReferenceCode(pageExperienceExternalReferenceCode, groupId);
        if (segmentsExperience == null) {
            return this._addPageExperience(groupId, pageExperience);
        }
        if (pageExperience.getPriority() != null && segmentsExperience.getPriority() != pageExperience.getPriority().intValue()) {
            segmentsExperience = this._segmentsExperienceService.updateSegmentsExperiencePriority(segmentsExperience.getSegmentsExperienceId(), GetterUtil.getInteger((Object)pageExperience.getPriority()));
        }
        return this._toPageExperience(SegmentsExperienceUtil.updateSegmentsExperience(layout, pageExperience, segmentsExperience, ServiceContextUtil.createServiceContext(groupId, this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    protected void preparePatch(PageExperience pageExperience, PageExperience existingPageExperience) {
        if (pageExperience.getPageElements() != null) {
            existingPageExperience.setPageElements(() -> ((PageExperience)pageExperience).getPageElements());
        }
    }

    private void _addLayoutStructureItem(LayoutStructure layoutStructure, LayoutStructureItemImporterContext layoutStructureItemImporterContext, PageElement pageElement) throws Exception {
        LayoutStructureItemImporter layoutStructureItemImporter = LayoutStructureItemImporterUtil.getLayoutStructureItemImporter(pageElement.getPageElementDefinition());
        layoutStructureItemImporter.addLayoutStructureItem(layoutStructure, layoutStructureItemImporterContext, pageElement);
        for (PageElement childPageElement : pageElement.getPageElements()) {
            this._addLayoutStructureItem(layoutStructure, layoutStructureItemImporterContext, childPageElement);
        }
    }

    private PageExperience _addPageExperience(long groupId, PageExperience pageExperience) throws Exception {
        Layout layout = this._layoutLocalService.fetchLayoutByExternalReferenceCode(pageExperience.getPageSpecificationExternalReferenceCode(), groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        return this._toPageExperience(SegmentsExperienceUtil.addSegmentsExperience(layout, pageExperience, ServiceContextUtil.createServiceContext(groupId, this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    private PageExperience _toPageExperience(SegmentsExperience segmentsExperience) throws Exception {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(segmentsExperience.getGroupId(), segmentsExperience.getPlid());
        LayoutPageTemplateStructureRel layoutPageTemplateStructureRel = this._layoutPageTemplateStructureRelLocalService.fetchLayoutPageTemplateStructureRel(layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperience.getSegmentsExperienceId());
        if (layoutPageTemplateStructureRel == null) {
            throw new UnsupportedOperationException();
        }
        return (PageExperience)this._pageExperienceDTOConverter.toDTO((Object)layoutPageTemplateStructureRel);
    }
}

