/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.headless.admin.site.dto.v1_0.ClassSubtypeReference;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateFolder;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateOpenGraphSettings;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSEOSettings;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplateSettings;
import com.liferay.headless.admin.site.dto.v1_0.ItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.SitemapSettings;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseDisplayPageTemplateResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.DisplayPageTemplateFolderUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.FileEntryUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.PageSpecificationUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.DisplayPageTemplateResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.info.item.InfoItemFormVariation;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFormVariationsProvider;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.lazy.referencing.LazyReferencingThreadLocal;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/display-page-template.properties"}, scope=ServiceScope.PROTOTYPE, service={DisplayPageTemplateResource.class})
public class DisplayPageTemplateResourceImpl
extends BaseDisplayPageTemplateResourceImpl {
    @Reference
    private CETManager _cetManager;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.DisplayPageTemplateDTOConverter)")
    private DTOConverter<LayoutPageTemplateEntry, DisplayPageTemplate> _displayPageTemplateDTOConverter;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateCollectionService _layoutPageTemplateCollectionService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference
    private Portal _portal;

    @Override
    public void deleteSiteDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        this._layoutPageTemplateEntryService.deleteLayoutPageTemplateEntry(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
    }

    @Override
    public DisplayPageTemplate getSiteDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)layoutPageTemplateEntry);
    }

    @Override
    public Page<DisplayPageTemplate> getSiteDisplayPageTemplateFolderDisplayPageTemplatesPage(String siteExternalReferenceCode, String displayPageTemplateFolderExternalReferenceCode, Boolean flatten) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(displayPageTemplateFolderExternalReferenceCode, groupId);
        if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId(), -1, -1, null), layoutPageTemplateEntry -> (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)));
    }

    @Override
    public Page<DisplayPageTemplate> getSiteDisplayPageTemplatesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return Page.of(this.transform(this._layoutPageTemplateEntryService.getLayoutPageTemplateEntries(groupId, 1, pagination.getStartPosition(), pagination.getEndPosition(), null), layoutPageTemplateEntry -> (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO(layoutPageTemplateEntry)), (Pagination)pagination, (long)this._layoutPageTemplateEntryService.getLayoutPageTemplateEntriesCount(groupId, 1));
    }

    @Override
    public DisplayPageTemplate postSiteDisplayPageTemplate(String siteExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        return this._addDisplayPageTemplate(displayPageTemplate, groupId, this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId));
    }

    @Override
    public DisplayPageTemplate postSiteDisplayPageTemplateFolderDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateFolderExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.getLayoutPageTemplateCollection(displayPageTemplateFolderExternalReferenceCode, groupId);
        if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return this._addDisplayPageTemplate(displayPageTemplate, groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId());
    }

    @Override
    public ContentPageSpecification postSiteDisplayPageTemplatePageSpecification(String siteExternalReferenceCode, String pageTemplateExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(this._cetManager, contentPageSpecification, this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid()), ServiceContextUtil.createServiceContext(layoutPageTemplateEntry.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public DisplayPageTemplate putSiteDisplayPageTemplate(String siteExternalReferenceCode, String displayPageTemplateExternalReferenceCode, DisplayPageTemplate displayPageTemplate) throws Exception {
        long previewFileEntryId;
        ClassSubtypeReference contentTypeReference;
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry == null) {
            return this._addDisplayPageTemplate(displayPageTemplate, groupId, this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId));
        }
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        long layoutPageTemplateCollectionId = this._getLayoutPageTemplateCollectionId(displayPageTemplate, groupId);
        if (!Objects.equals(layoutPageTemplateEntry.getLayoutPageTemplateCollectionId(), layoutPageTemplateCollectionId)) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.moveLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), layoutPageTemplateCollectionId);
        }
        if ((contentTypeReference = displayPageTemplate.getContentTypeReference()) == null) {
            throw new UnsupportedOperationException();
        }
        ClassName className = this._classNameLocalService.fetchClassName(contentTypeReference.getClassName());
        if (className == null) {
            throw new UnsupportedOperationException();
        }
        long classTypeId = this._getClassTypeId(contentTypeReference, groupId);
        if (!className.equals((Object)layoutPageTemplateEntry.getClassName()) || classTypeId != layoutPageTemplateEntry.getClassTypeId()) {
            this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), className.getClassNameId(), classTypeId);
        }
        if (!Objects.equals(GetterUtil.getBoolean((Object)displayPageTemplate.getMarkedAsDefault()), layoutPageTemplateEntry.isDefaultTemplate())) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), GetterUtil.getBoolean((Object)displayPageTemplate.getMarkedAsDefault()));
        }
        if ((previewFileEntryId = FileEntryUtil.getPreviewFileEntryId(groupId, displayPageTemplate.getThumbnail())) != layoutPageTemplateEntry.getPreviewFileEntryId()) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), previewFileEntryId);
        }
        Layout layout = this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        UnicodeProperties typeSettingsUnicodeProperties = this._getUnicodeProperties(displayPageTemplate.getDisplayPageTemplateSettings());
        layout = this._layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), typeSettingsUnicodeProperties.toString());
        layout = LayoutUtil.updateContentLayout(this._cetManager, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), this._getRobotsMap(displayPageTemplate.getDisplayPageTemplateSettings()), LocalizedMapUtil.getLocalizedMap((Map)displayPageTemplate.getFriendlyUrlPath_i18n()), displayPageTemplate.getPageSpecifications(), this._getServiceContext(displayPageTemplate, groupId));
        if (!layoutPageTemplateEntry.isApproved() && LayoutUtil.isPublished(layout)) {
            layoutPageTemplateEntry = this._layoutPageTemplateEntryService.updateStatus(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), 0);
        }
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry.getLayoutPageTemplateEntryId(), displayPageTemplate.getName()));
    }

    @Override
    protected void preparePatch(DisplayPageTemplate displayPageTemplate, DisplayPageTemplate existingDisplayPageTemplate) {
        if (displayPageTemplate.getContentTypeReference() != null) {
            existingDisplayPageTemplate.setContentTypeReference(() -> ((DisplayPageTemplate)displayPageTemplate).getContentTypeReference());
        }
        if (displayPageTemplate.getDisplayPageTemplateSettings() != null) {
            existingDisplayPageTemplate.setDisplayPageTemplateSettings(() -> ((DisplayPageTemplate)displayPageTemplate).getDisplayPageTemplateSettings());
        }
        if (displayPageTemplate.getFriendlyUrlPath_i18n() != null) {
            existingDisplayPageTemplate.setFriendlyUrlPath_i18n(() -> ((DisplayPageTemplate)displayPageTemplate).getFriendlyUrlPath_i18n());
        }
        if (displayPageTemplate.getPageSpecifications() != null) {
            existingDisplayPageTemplate.setPageSpecifications(() -> ((DisplayPageTemplate)displayPageTemplate).getPageSpecifications());
        }
        if (displayPageTemplate.getParentFolder() != null) {
            existingDisplayPageTemplate.setParentFolder(() -> ((DisplayPageTemplate)displayPageTemplate).getParentFolder());
        }
        if (displayPageTemplate.getThumbnail() != null) {
            existingDisplayPageTemplate.setThumbnail(() -> ((DisplayPageTemplate)displayPageTemplate).getThumbnail());
        }
    }

    private DisplayPageTemplate _addDisplayPageTemplate(DisplayPageTemplate displayPageTemplate, long groupId, long layoutPageTemplateCollectionId) throws Exception {
        ClassSubtypeReference contentTypeReference = displayPageTemplate.getContentTypeReference();
        if (contentTypeReference == null) {
            throw new UnsupportedOperationException();
        }
        Map<Locale, String> nameMap = Collections.singletonMap(this._portal.getSiteDefaultLocale(groupId), displayPageTemplate.getName());
        DisplayPageTemplateSettings displayPageTemplateSettings = displayPageTemplate.getDisplayPageTemplateSettings();
        ServiceContext serviceContext = this._getServiceContext(displayPageTemplate, groupId);
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        serviceContext.setAttribute("layout.page.template.entry.type", (Serializable)Integer.valueOf(1));
        Layout layout = LayoutUtil.addContentLayout(this._cetManager, groupId, displayPageTemplate.getPageSpecifications(), 0L, false, nameMap, nameMap, null, this._getRobotsMap(displayPageTemplateSettings), "asset_display", this._getUnicodeProperties(displayPageTemplateSettings), true, true, LocalizedMapUtil.getLocalizedMap((Map)displayPageTemplate.getFriendlyUrlPath_i18n()), 0, serviceContext);
        return (DisplayPageTemplate)this._displayPageTemplateDTOConverter.toDTO((Object)this._layoutPageTemplateEntryService.addLayoutPageTemplateEntry(displayPageTemplate.getExternalReferenceCode(), groupId, layoutPageTemplateCollectionId, displayPageTemplate.getKey(), this._portal.getClassNameId(contentTypeReference.getClassName()), this._getClassTypeId(contentTypeReference, groupId), displayPageTemplate.getName(), 1, FileEntryUtil.getPreviewFileEntryId(groupId, displayPageTemplate.getThumbnail()), false, 0L, layout.getPlid(), 0L, PageSpecificationUtil.getPublishedStatus(displayPageTemplate.getPageSpecifications()), serviceContext));
    }

    private long _getClassTypeId(ClassSubtypeReference contentTypeReference, long groupId) {
        InfoItemFormVariationsProvider infoItemFormVariationsProvider = (InfoItemFormVariationsProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFormVariationsProvider.class, contentTypeReference.getClassName());
        if (infoItemFormVariationsProvider == null) {
            return 0L;
        }
        ItemExternalReference itemExternalReference = contentTypeReference.getSubTypeExternalReference();
        if (itemExternalReference == null) {
            throw new UnsupportedOperationException();
        }
        InfoItemFormVariation infoItemFormVariation = infoItemFormVariationsProvider.getInfoItemFormVariationByExternalReferenceCode(itemExternalReference.getExternalReferenceCode(), groupId);
        if (infoItemFormVariation != null) {
            return GetterUtil.getLong((String)infoItemFormVariation.getKey());
        }
        return -1L;
    }

    private long _getLayoutPageTemplateCollectionId(DisplayPageTemplate displayPageTemplate, long groupId) throws Exception {
        DisplayPageTemplateFolder displayPageTemplateFolder = displayPageTemplate.getParentFolder();
        if (displayPageTemplateFolder == null) {
            return 0L;
        }
        LayoutPageTemplateCollection layoutPageTemplateCollection = this._layoutPageTemplateCollectionService.fetchLayoutPageTemplateCollection(displayPageTemplateFolder.getExternalReferenceCode(), groupId);
        if (layoutPageTemplateCollection == null) {
            if (!LazyReferencingThreadLocal.isEnabled()) {
                throw new UnsupportedOperationException();
            }
            layoutPageTemplateCollection = DisplayPageTemplateFolderUtil.addLayoutPageTemplateCollection(displayPageTemplateFolder, groupId, this.contextHttpServletRequest);
        } else if (!Objects.equals(1, layoutPageTemplateCollection.getType())) {
            throw new UnsupportedOperationException();
        }
        return layoutPageTemplateCollection.getLayoutPageTemplateCollectionId();
    }

    private Map<Locale, String> _getRobotsMap(DisplayPageTemplateSettings displayPageTemplateSettings) {
        Map<Locale, String> robotsMap = new HashMap<Locale, String>();
        if (displayPageTemplateSettings != null && displayPageTemplateSettings.getSeoSettings() != null) {
            DisplayPageTemplateSEOSettings displayPageTemplateSEOSettings = displayPageTemplateSettings.getSeoSettings();
            robotsMap = LocalizedMapUtil.getLocalizedMap((Locale)this.contextAcceptLanguage.getPreferredLocale(), null, (Map)displayPageTemplateSEOSettings.getRobots_i18n());
        }
        return robotsMap;
    }

    private ServiceContext _getServiceContext(DisplayPageTemplate displayPageTemplate, long groupId) {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setCompanyId(this.contextCompany.getCompanyId());
        serviceContext.setCreateDate(displayPageTemplate.getDateCreated());
        serviceContext.setModifiedDate(displayPageTemplate.getDateModified());
        serviceContext.setUserId(this.contextUser.getUserId());
        serviceContext.setUuid(displayPageTemplate.getUuid());
        return serviceContext;
    }

    private UnicodeProperties _getUnicodeProperties(DisplayPageTemplateSettings displayPageTemplateSettings) {
        UnicodeProperties unicodeProperties = new UnicodeProperties();
        if (displayPageTemplateSettings == null) {
            return unicodeProperties;
        }
        DisplayPageTemplateOpenGraphSettings displayPageTemplateOpenGraphSettings = displayPageTemplateSettings.getOpenGraphSettings();
        if (displayPageTemplateOpenGraphSettings != null) {
            unicodeProperties.setProperty("mapped-openGraphDescription", displayPageTemplateOpenGraphSettings.getDescriptionTemplate());
            unicodeProperties.setProperty("mapped-openGraphImageAlt", displayPageTemplateOpenGraphSettings.getImageAltTemplate());
            unicodeProperties.setProperty("mapped-openGraphImage", displayPageTemplateOpenGraphSettings.getImageTemplate());
            unicodeProperties.setProperty("mapped-openGraphTitle", displayPageTemplateOpenGraphSettings.getTitleTemplate());
        }
        SitemapSettings sitemapSettings = null;
        DisplayPageTemplateSEOSettings displayPageTemplateSEOSettings = displayPageTemplateSettings.getSeoSettings();
        if (displayPageTemplateSEOSettings != null) {
            sitemapSettings = displayPageTemplateSEOSettings.getSitemapSettings();
            unicodeProperties.setProperty("mapped-description", displayPageTemplateSEOSettings.getDescriptionTemplate());
            unicodeProperties.setProperty("mapped-title", displayPageTemplateSEOSettings.getHtmlTitleTemplate());
        }
        if (sitemapSettings != null) {
            Boolean include;
            SitemapSettings.ChangeFrequency changeFrequency = sitemapSettings.getChangeFrequency();
            if (changeFrequency != null) {
                unicodeProperties.setProperty("sitemap-changefreq", StringUtil.lowerCaseFirstLetter((String)changeFrequency.toString()));
            }
            if ((include = sitemapSettings.getInclude()) != null) {
                String sitemapInclude = "0";
                if (include.booleanValue()) {
                    sitemapInclude = "1";
                }
                unicodeProperties.setProperty("sitemap-include", sitemapInclude);
            }
            unicodeProperties.setProperty("sitemap-priority", String.valueOf(sitemapSettings.getPagePriority()));
        }
        return unicodeProperties;
    }
}

