/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.AssetUtil;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DTOConverter.class})
public class SitePageDTOConverter
implements DTOConverter<Layout, SitePage> {
    @Reference
    private LayoutLocalService _layoutLocalService;

    public String getContentType() {
        return SitePage.class.getSimpleName();
    }

    public SitePage toDTO(DTOConverterContext dtoConverterContext, final Layout layout) throws Exception {
        return new SitePage(){
            {
                this.setAvailableLanguages(() -> LocaleUtil.toW3cLanguageIds((String[])layout.getAvailableLanguageIds()));
                this.setDateCreated(() -> ((Layout)layout).getCreateDate());
                this.setDateModified(() -> ((Layout)layout).getModifiedDate());
                this.setDatePublished(() -> ((Layout)layout).getPublishDate());
                this.setExternalReferenceCode(() -> ((Layout)layout).getExternalReferenceCode());
                this.setFriendlyUrlPath_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getFriendlyURLMap()));
                this.setKeywords(() -> AssetUtil.getKeywords(Layout.class.getName(), layout.getPlid()));
                this.setName_i18n(() -> LocalizedMapUtil.getI18nMap((boolean)true, (Map)layout.getNameMap()));
                this.setPageSettings(() -> SitePageDTOConverter.this._toPageSettings(layout));
                this.setParentSitePageExternalReferenceCode(() -> {
                    if (layout.getParentLayoutId() == 0L) {
                        return null;
                    }
                    Layout parentLayout = SitePageDTOConverter.this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getParentLayoutId());
                    return parentLayout.getExternalReferenceCode();
                });
                this.setTaxonomyCategoryItemExternalReferences(() -> AssetUtil.getTaxonomyCategoryItemExternalReferences(Layout.class.getName(), layout.getPlid(), layout.getGroupId()));
                this.setType(() -> SitePageTypeUtil.toExternalType(layout.getType()));
                this.setUuid(() -> ((Layout)layout).getUuid());
            }
        };
    }

    private PageSettings _getPageSettings(Layout layout) {
        SitePage.Type type = SitePageTypeUtil.toExternalType(layout.getType());
        if (type == SitePage.Type.CONTENT_PAGE) {
            return new ContentPageSettings();
        }
        return this._toWidgetPageSettings(layout);
    }

    private PageSettings _toPageSettings(Layout layout) {
        PageSettings pageSettings = this._getPageSettings(layout);
        pageSettings.setHiddenFromNavigation(() -> ((Layout)layout).isHidden());
        pageSettings.setPriority(() -> ((Layout)layout).getPriority());
        return pageSettings;
    }

    private WidgetPageSettings _toWidgetPageSettings(Layout layout) {
        WidgetPageSettings widgetPageSettings = new WidgetPageSettings();
        widgetPageSettings.setCustomizable(() -> ((Layout)layout).isCustomizable());
        widgetPageSettings.setCustomizableSectionIds(() -> {
            ArrayList customizableSectionIds = new ArrayList();
            UnicodeProperties typeSettingsUnicodeProperties = UnicodePropertiesBuilder.fastLoad((String)layout.getTypeSettings()).build();
            typeSettingsUnicodeProperties.forEach((key, value) -> {
                if (key.contains("-customizable") && Objects.equals(value, "true")) {
                    customizableSectionIds.add(key.substring(0, key.indexOf("-customizable")));
                }
            });
            List sortedCustomizableSectionIds = ListUtil.sort(customizableSectionIds);
            return sortedCustomizableSectionIds.toArray(new String[0]);
        });
        widgetPageSettings.setLayoutTemplateId(() -> layout.getTypeSettingsProperty("layout-template-id"));
        return widgetPageSettings;
    }
}

