/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.DisplayPageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.dto.v1_0.PageExperience;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageTemplate;
import com.liferay.headless.admin.site.dto.v1_0.Settings;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.UtilityPage;
import com.liferay.headless.admin.site.internal.resource.v1_0.BasePageSpecificationResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.resource.v1_0.PageSpecificationResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryService;
import com.liferay.portal.kernel.exception.LockedLayoutException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.fields.NestedField;
import com.liferay.portal.vulcan.fields.NestedFieldId;
import com.liferay.portal.vulcan.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/page-specification.properties"}, property={"nested.field.support=true"}, scope=ServiceScope.PROTOTYPE, service={PageSpecificationResource.class})
public class PageSpecificationResourceImpl
extends BasePageSpecificationResourceImpl {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutPageTemplateEntryService _layoutPageTemplateEntryService;
    @Reference
    private LayoutService _layoutService;
    @Reference
    private LayoutUtilityPageEntryService _layoutUtilityPageEntryService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._getLayout(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageSpecificationExternalReferenceCode);
        if (!layout.isDraftLayout() || layout.isApproved() && GetterUtil.getBoolean((String)layout.getTypeSettingsProperty("published"))) {
            throw new UnsupportedOperationException();
        }
        this._discardDraftLayout(layout);
    }

    @Override
    @NestedField(parentClass=DisplayPageTemplate.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSiteByExternalReferenceCodeDisplayPageTemplatePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String displayPageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(displayPageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(1, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    @NestedField(parentClass=MasterPage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSiteByExternalReferenceCodeMasterPagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String masterPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(masterPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(3, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    public PageSpecification getSiteSiteByExternalReferenceCodePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._getLayout(GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), pageSpecificationExternalReferenceCode);
        if (!(layout.isTypeAssetDisplay() || layout.isTypeContent() || layout.isTypePortlet())) {
            throw new UnsupportedOperationException();
        }
        return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout);
    }

    @Override
    @NestedField(parentClass=PageTemplate.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSiteByExternalReferenceCodePageTemplatePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String pageTemplateExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.getLayoutPageTemplateEntryByExternalReferenceCode(pageTemplateExternalReferenceCode, GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!Objects.equals(0, layoutPageTemplateEntry.getType()) && !Objects.equals(2, layoutPageTemplateEntry.getType())) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid())));
    }

    @Override
    @NestedField(parentClass=SitePage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSiteByExternalReferenceCodeSitePagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this._toPageSpecifications(layout));
    }

    @Override
    @NestedField(parentClass=UtilityPage.class, value="pageSpecifications")
    public Page<PageSpecification> getSiteSiteByExternalReferenceCodeUtilityPagePageSpecificationsPage(String siteExternalReferenceCode, @NestedFieldId(value="externalReferenceCode") String utilityPageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryService.getLayoutUtilityPageEntryByExternalReferenceCode(utilityPageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        return Page.of(this._toPageSpecifications(this._layoutLocalService.getLayout(layoutUtilityPageEntry.getPlid())));
    }

    @Override
    public PageSpecification putSiteSiteByExternalReferenceCodePageSpecification(String siteExternalReferenceCode, String pageSpecificationExternalReferenceCode, PageSpecification pageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(true, true, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._getLayout(groupId, pageSpecificationExternalReferenceCode);
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, null).build();
        serviceContext.setUserId(this.contextUser.getUserId());
        if (!layout.isTypeAssetDisplay() && !layout.isTypeContent()) {
            if (!Objects.equals(pageSpecification.getStatus(), PageSpecification.Status.APPROVED) || !Objects.equals(PageSpecification.Type.WIDGET_PAGE_SPECIFICATION, pageSpecification.getType())) {
                throw new UnsupportedOperationException();
            }
            return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.updateLayout(layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), pageSpecification.getSettings(), serviceContext));
        }
        if (!(Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, pageSpecification.getType()) && layout.isDraftLayout() && Objects.equals(pageSpecification.getStatus(), PageSpecification.Status.DRAFT))) {
            throw new UnsupportedOperationException();
        }
        return (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.updateLayout((ContentPageSpecification)pageSpecification, layout, layout.getNameMap(), layout.getTitleMap(), layout.getDescriptionMap(), layout.getRobotsMap(), layout.getFriendlyURLMap(), 2, serviceContext));
    }

    @Override
    protected void preparePatch(PageSpecification pageSpecification, PageSpecification existingPageSpecification) {
        Settings settings = pageSpecification.getSettings();
        if (settings != null) {
            Settings existingSettings = existingPageSpecification.getSettings();
            if (settings.getColorSchemeName() != null) {
                existingSettings.setColorSchemeName(() -> ((Settings)settings).getColorSchemeName());
            }
            if (settings.getCss() != null) {
                existingSettings.setCss(() -> ((Settings)settings).getCss());
            }
            if (settings.getFavIcon() != null) {
                existingSettings.setFavIcon(() -> ((Settings)settings).getFavIcon());
            }
            if (settings.getGlobalCSSClientExtensions() != null) {
                existingSettings.setGlobalCSSClientExtensions(() -> ((Settings)settings).getGlobalCSSClientExtensions());
            }
            if (settings.getGlobalJSClientExtensions() != null) {
                existingSettings.setGlobalJSClientExtensions(() -> ((Settings)settings).getGlobalJSClientExtensions());
            }
            if (settings.getJavascript() != null) {
                existingSettings.setJavascript(() -> ((Settings)settings).getJavascript());
            }
            if (settings.getMasterPageItemExternalReference() != null) {
                existingSettings.setMasterPageItemExternalReference(() -> ((Settings)settings).getMasterPageItemExternalReference());
            }
            if (settings.getStyleBookItemExternalReference() != null) {
                existingSettings.setStyleBookItemExternalReference(() -> ((Settings)settings).getStyleBookItemExternalReference());
            }
            if (settings.getThemeCSSClientExtension() != null) {
                existingSettings.setThemeCSSClientExtension(() -> ((Settings)settings).getThemeCSSClientExtension());
            }
            if (settings.getThemeName() != null) {
                existingSettings.setThemeName(() -> ((Settings)settings).getThemeName());
            }
            if (settings.getThemeSettings() != null) {
                existingSettings.setThemeSettings(() -> ((Settings)settings).getThemeSettings());
            }
            if (settings.getThemeSpritemapClientExtension() != null) {
                existingSettings.setThemeSpritemapClientExtension(() -> ((Settings)settings).getThemeSpritemapClientExtension());
            }
        }
        if (!Objects.equals(PageSpecification.Type.CONTENT_PAGE_SPECIFICATION, existingPageSpecification.getType())) {
            return;
        }
        this._preparePatch((ContentPageSpecification)pageSpecification, (ContentPageSpecification)existingPageSpecification);
    }

    private void _discardDraftLayout(Layout draftLayout) throws Exception {
        block2: {
            Layout layout = this._layoutLocalService.getLayout(draftLayout.getClassPK());
            try {
                boolean published = LayoutUtil.isPublished(layout);
                draftLayout = this._layoutLocalService.copyLayoutContent(layout, draftLayout);
                ServiceContext serviceContext = ServiceContextBuilder.create((long)layout.getGroupId(), (HttpServletRequest)this.contextHttpServletRequest, null).build();
                serviceContext.setAttribute("published", (Serializable)Boolean.valueOf(published));
                serviceContext.setUserId(this.contextUser.getUserId());
                this._layoutLocalService.updateStatus(this.contextUser.getUserId(), draftLayout.getPlid(), 0, serviceContext);
            }
            catch (Exception exception) {
                if (exception instanceof LockedLayoutException || exception.getCause() instanceof LockedLayoutException) break block2;
                throw new UnsupportedOperationException();
            }
        }
    }

    private Layout _getLayout(long groupId, String pageSpecificationExternalReferenceCode) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryService.fetchLayoutPageTemplateEntryByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
        if (layoutPageTemplateEntry != null && layoutPageTemplateEntry.getType() == 2) {
            return this._layoutLocalService.getLayout(layoutPageTemplateEntry.getPlid());
        }
        return this._layoutService.getLayoutByExternalReferenceCode(pageSpecificationExternalReferenceCode, groupId);
    }

    private PageExperience _getPageExperience(ContentPageSpecification contentPageSpecification, String pageExperienceExternalReferenceCode) {
        for (PageExperience pageExperience : contentPageSpecification.getPageExperiences()) {
            if (!Objects.equals(pageExperience.getExternalReferenceCode(), pageExperienceExternalReferenceCode)) continue;
            return pageExperience;
        }
        throw new UnsupportedOperationException();
    }

    private void _preparePatch(ContentPageSpecification contentPageSpecification, ContentPageSpecification existingContentPageSpecification) {
        if (contentPageSpecification.getPageExperiences() == null) {
            return;
        }
        for (PageExperience pageExperience : contentPageSpecification.getPageExperiences()) {
            PageExperience existingPageExperience = this._getPageExperience(existingContentPageSpecification, pageExperience.getExternalReferenceCode());
            existingPageExperience.setPageElements(() -> ((PageExperience)pageExperience).getPageElements());
        }
    }

    private List<PageSpecification> _toPageSpecifications(Layout layout) throws Exception {
        Layout draftLayout = layout.fetchDraftLayout();
        if (draftLayout == null) {
            if (!layout.isTypePortlet()) {
                throw new UnsupportedOperationException();
            }
            return ListUtil.fromArray((Object[])new PageSpecification[]{(PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout)});
        }
        return ListUtil.fromArray((Object[])new PageSpecification[]{(PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)layout), (PageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)draftLayout)});
    }
}

