/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSettings;
import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.PageSettings;
import com.liferay.headless.admin.site.dto.v1_0.PageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.SitePage;
import com.liferay.headless.admin.site.dto.v1_0.WidgetPageSettings;
import com.liferay.headless.admin.site.internal.dto.v1_0.util.SitePageTypeUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.BaseSitePageResourceImpl;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.GroupUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.LayoutUtil;
import com.liferay.headless.admin.site.internal.resource.v1_0.util.ServiceContextUtil;
import com.liferay.headless.admin.site.resource.v1_0.SitePageResource;
import com.liferay.headless.common.spi.service.context.ServiceContextBuilder;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.NotSupportedException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/site-page.properties"}, scope=ServiceScope.PROTOTYPE, service={SitePageResource.class})
public class SitePageResourceImpl
extends BaseSitePageResourceImpl {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    @Reference
    private LayoutService _layoutService;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.PageSpecificationDTOConverter)")
    private DTOConverter<Layout, PageSpecification> _pageSpecificationDTOConverter;
    @Reference(target="(component.name=com.liferay.headless.admin.site.internal.dto.v1_0.converter.SitePageDTOConverter)")
    private DTOConverter<Layout, SitePage> _sitePageDTOConverter;

    @Override
    public void deleteSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        this._layoutService.deleteLayout(layout.getPlid(), ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId()));
    }

    @Override
    public SitePage getSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        this._validateSitePageLayout(layout);
        return this._toSitePage(layout);
    }

    @Override
    public Page<SitePage> getSiteSiteByExternalReferenceCodeSitePagesPage(String siteExternalReferenceCode, String search, Aggregation aggregation, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return Page.of(this.transform(this._layoutService.getLayouts(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), false, search, new String[]{"content", "portlet"}, null, pagination.getStartPosition(), pagination.getEndPosition(), null), layout -> this._toSitePage((Layout)layout)), (Pagination)pagination, (long)this._layoutService.getLayoutsCount(GroupUtil.getGroupId(true, this.contextCompany.getCompanyId(), siteExternalReferenceCode), false, search, new String[]{"content", "portlet"}, null));
    }

    @Override
    public SitePage postByExternalReferenceCodeSitePage(String siteExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._addLayout(sitePage.getExternalReferenceCode(), GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode), sitePage));
    }

    @Override
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeSitePagePageSpecification(String siteExternalReferenceCode, String sitePageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        Layout layout = this._layoutService.getLayoutByExternalReferenceCode(sitePageExternalReferenceCode, GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode));
        if (!layout.isTypeContent()) {
            throw new UnsupportedOperationException();
        }
        return (ContentPageSpecification)this._pageSpecificationDTOConverter.toDTO((Object)LayoutUtil.addDraftToLayout(contentPageSpecification, layout, ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId())));
    }

    @Override
    public SitePage putSiteSiteByExternalReferenceCodeSitePage(String siteExternalReferenceCode, String sitePageExternalReferenceCode, SitePage sitePage) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        long groupId = GroupUtil.getGroupId(false, this.contextCompany.getCompanyId(), siteExternalReferenceCode);
        Layout layout = this._layoutService.fetchLayoutByExternalReferenceCode(sitePageExternalReferenceCode, groupId);
        if (layout == null) {
            return this._toSitePage(this._addLayout(sitePageExternalReferenceCode, groupId, sitePage));
        }
        this._validateSitePageLayout(layout);
        if (sitePage.getType() != null && !Objects.equals(layout.getType(), SitePageTypeUtil.toInternalType(sitePage.getType()))) {
            throw new UnsupportedOperationException();
        }
        return this._toSitePage(this._updateLayout(layout, sitePage));
    }

    @Override
    public Page<SitePage> read(Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-35443")) {
            throw new UnsupportedOperationException();
        }
        if (parameters.containsKey("siteId")) {
            Group group = this._groupLocalService.getGroup(((Long)parameters.get("siteId")).longValue());
            return this.getSiteSiteByExternalReferenceCodeSitePagesPage(group.getExternalReferenceCode(), search, null, filter, pagination, sorts);
        }
        throw new NotSupportedException("One of the following parameters must be specified: [siteId]");
    }

    @Override
    protected void preparePatch(SitePage sitePage, SitePage existingSitePage) {
        if (sitePage.getPageSettings() != null) {
            existingSitePage.setPageSettings(() -> ((SitePage)sitePage).getPageSettings());
        }
    }

    private Layout _addLayout(String externalReferenceCode, long groupId, SitePage sitePage) throws Exception {
        ServiceContext serviceContext = ServiceContextBuilder.create((long)groupId, (HttpServletRequest)this.contextHttpServletRequest, (String)sitePage.getViewableByAsString()).build();
        serviceContext.setUuid(sitePage.getUuid());
        Layout layout = this._layoutService.addLayout(externalReferenceCode, groupId, false, this._getParentLayoutId(0L, groupId, sitePage.getParentSitePageExternalReferenceCode()), LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n()), null, null, null, null, SitePageTypeUtil.toInternalType(sitePage.getType()), this._getTypeSettings(sitePage), this._isHiddenFromNavigation(false, sitePage.getPageSettings()), LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n()), 0L, serviceContext);
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings != null && pageSettings.getPriority() != null) {
            layout = this._layoutService.updatePriority(layout.getPlid(), pageSettings.getPriority().intValue());
        }
        return layout;
    }

    private long _getParentLayoutId(long defaultParentLayoutId, long groupId, String parentSitePageExternalReferenceCode) throws Exception {
        if (parentSitePageExternalReferenceCode == null) {
            return defaultParentLayoutId;
        }
        if (Validator.isNull((String)parentSitePageExternalReferenceCode)) {
            return 0L;
        }
        Layout layout = this._layoutService.fetchLayoutByExternalReferenceCode(parentSitePageExternalReferenceCode, groupId);
        if (layout == null) {
            throw new UnsupportedOperationException();
        }
        return layout.getLayoutId();
    }

    private String _getTypeSettings(SitePage sitePage) {
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings == null) {
            return null;
        }
        if (sitePage.getType() == SitePage.Type.CONTENT_PAGE) {
            if (!(pageSettings instanceof ContentPageSettings)) {
                throw new UnsupportedOperationException();
            }
            return null;
        }
        if (sitePage.getType() != SitePage.Type.WIDGET_PAGE || !(pageSettings instanceof WidgetPageSettings)) {
            throw new UnsupportedOperationException();
        }
        WidgetPageSettings widgetPageSettings = (WidgetPageSettings)pageSettings;
        return UnicodePropertiesBuilder.create((boolean)true).setProperty("layout-template-id", widgetPageSettings.getLayoutTemplateId()).buildString();
    }

    private boolean _isHiddenFromNavigation(boolean defaultValue, PageSettings pageSettings) {
        if (pageSettings == null) {
            return defaultValue;
        }
        return GetterUtil.getBoolean((Object)pageSettings.getHiddenFromNavigation(), (boolean)defaultValue);
    }

    private SitePage _toSitePage(Layout layout) throws Exception {
        return (SitePage)this._sitePageDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(this.contextAcceptLanguage.isAcceptAllLanguages(), null, this._dtoConverterRegistry, this.contextHttpServletRequest, (Object)layout.getPlid(), this.contextAcceptLanguage.getPreferredLocale(), this.contextUriInfo, this.contextUser), (Object)layout);
    }

    private Layout _updateLayout(Layout layout, SitePage sitePage) throws Exception {
        String typeSettings;
        Map nameMap = layout.getNameMap();
        if (sitePage.getName_i18n() != null) {
            nameMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getName_i18n());
        }
        Map friendlyURLMap = layout.getFriendlyURLMap();
        if (sitePage.getFriendlyUrlPath_i18n() != null) {
            friendlyURLMap = LocalizedMapUtil.getLocalizedMap((Map)sitePage.getFriendlyUrlPath_i18n());
        }
        layout = this._layoutService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), this._getParentLayoutId(layout.getParentLayoutId(), layout.getGroupId(), sitePage.getParentSitePageExternalReferenceCode()), nameMap, layout.getTitleMap(), layout.getDescriptionMap(), layout.getKeywordsMap(), layout.getRobotsMap(), layout.getType(), this._isHiddenFromNavigation(layout.isHidden(), sitePage.getPageSettings()), friendlyURLMap, layout.isIconImage(), null, layout.getStyleBookEntryId(), layout.getFaviconFileEntryId(), layout.getMasterLayoutPlid(), ServiceContextUtil.createServiceContext(layout.getGroupId(), this.contextHttpServletRequest, this.contextUser.getUserId()));
        int priority = Integer.MAX_VALUE;
        PageSettings pageSettings = sitePage.getPageSettings();
        if (pageSettings != null && pageSettings.getPriority() != null) {
            priority = pageSettings.getPriority();
        }
        if (layout.getPriority() != priority) {
            layout = this._layoutService.updatePriority(layout.getPlid(), priority);
        }
        if ((typeSettings = this._getTypeSettings(sitePage)) == null) {
            return layout;
        }
        return this._layoutService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), typeSettings);
    }

    private void _validateSitePageLayout(Layout layout) {
        if (layout.isDraftLayout() || layout.isTypeAssetDisplay() || layout.isTypeUtility()) {
            throw new UnsupportedOperationException();
        }
        LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntryByPlid(layout.getPlid());
        if (layoutPageTemplateEntry != null) {
            throw new UnsupportedOperationException();
        }
    }
}

