/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.dto.v1_0.converter;

import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.headless.admin.site.dto.v1_0.ClassNameReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionItemExternalReference;
import com.liferay.headless.admin.site.dto.v1_0.CollectionPageElementDefinition;
import com.liferay.headless.admin.site.dto.v1_0.CollectionReference;
import com.liferay.headless.admin.site.dto.v1_0.EmptyCollectionConfig;
import com.liferay.headless.admin.site.dto.v1_0.PageElementDefinition;
import com.liferay.info.list.provider.item.selector.criterion.InfoListProviderItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoListItemSelectorReturnType;
import com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem;
import com.liferay.layout.util.structure.collection.EmptyCollectionOptions;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.layout.util.structure.CollectionStyledLayoutStructureItem"}, service={DTOConverter.class})
public class CollectionPageElementDefinitionDTOConverter
implements DTOConverter<CollectionStyledLayoutStructureItem, CollectionPageElementDefinition> {
    private static final Map<String, CollectionPageElementDefinition.PaginationType> _internalToExternalValuesMap = HashMapBuilder.put((Object)"none", (Object)CollectionPageElementDefinition.PaginationType.NONE).put((Object)"numeric", (Object)CollectionPageElementDefinition.PaginationType.NUMERIC).put((Object)"regular", (Object)CollectionPageElementDefinition.PaginationType.REGULAR).put((Object)"simple", (Object)CollectionPageElementDefinition.PaginationType.SIMPLE).build();
    @Reference
    private AssetListEntryLocalService _assetListEntryLocalService;

    public String getContentType() {
        return CollectionPageElementDefinition.class.getSimpleName();
    }

    public CollectionPageElementDefinition toDTO(DTOConverterContext dtoConverterContext, final CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) throws Exception {
        return new CollectionPageElementDefinition(){
            {
                this.setCollectionReference(() -> CollectionPageElementDefinitionDTOConverter.this._toCollectionReference(collectionStyledLayoutStructureItem));
                this.setDisplayAllItems(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).isDisplayAllItems());
                this.setDisplayAllPages(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).isDisplayAllPages());
                this.setEmptyCollectionConfig(() -> CollectionPageElementDefinitionDTOConverter.this._toEmptyCollectionOption(collectionStyledLayoutStructureItem));
                this.setListItemStyle(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getListItemStyle());
                this.setListStyle(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getListStyle());
                this.setName(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getName());
                this.setNumberOfColumns(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfColumns());
                this.setNumberOfItems(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfItems());
                this.setNumberOfItemsPerPage(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfItemsPerPage());
                this.setNumberOfPages(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getNumberOfPages());
                this.setPaginationType(() -> _internalToExternalValuesMap.get(collectionStyledLayoutStructureItem.getPaginationType()));
                this.setTemplateKey(() -> ((CollectionStyledLayoutStructureItem)collectionStyledLayoutStructureItem).getTemplateKey());
                this.setType(PageElementDefinition.Type.COLLECTION);
            }
        };
    }

    private CollectionReference _toCollectionReference(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final JSONObject jsonObject = collectionStyledLayoutStructureItem.getCollectionJSONObject();
        if (jsonObject == null) {
            return null;
        }
        String type = jsonObject.getString("type");
        if (Validator.isNull((String)type)) {
            return null;
        }
        if (Objects.equals(type, InfoListItemSelectorReturnType.class.getName())) {
            final AssetListEntry assetListEntry = this._assetListEntryLocalService.fetchAssetListEntry(jsonObject.getLong("classPK"));
            if (assetListEntry == null) {
                return null;
            }
            return new CollectionItemExternalReference(){
                {
                    this.setCollectionType(CollectionReference.CollectionType.COLLECTION);
                    this.setExternalReferenceCode(() -> ((AssetListEntry)assetListEntry).getExternalReferenceCode());
                }
            };
        }
        if (Objects.equals(type, InfoListProviderItemSelectorReturnType.class.getName())) {
            return new ClassNameReference(){
                {
                    this.setClassName(() -> jsonObject.getString("key"));
                    this.setCollectionType(CollectionReference.CollectionType.COLLECTION_PROVIDER);
                }
            };
        }
        return null;
    }

    private EmptyCollectionConfig _toEmptyCollectionOption(CollectionStyledLayoutStructureItem collectionStyledLayoutStructureItem) {
        final EmptyCollectionOptions emptyCollectionOptions = collectionStyledLayoutStructureItem.getEmptyCollectionOptions();
        if (emptyCollectionOptions == null) {
            return null;
        }
        return new EmptyCollectionConfig(){
            {
                this.setDisplayMessage(() -> ((EmptyCollectionOptions)emptyCollectionOptions).isDisplayMessage());
                this.setMessage_i18n(() -> ((EmptyCollectionOptions)emptyCollectionOptions).getMessage());
            }
        };
    }
}

