/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.headless.admin.site.internal.resource.v1_0;

import com.liferay.headless.admin.site.dto.v1_0.ContentPageSpecification;
import com.liferay.headless.admin.site.dto.v1_0.MasterPage;
import com.liferay.headless.admin.site.resource.v1_0.MasterPageResource;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.Filter;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.batch.engine.VulcanBatchEngineTaskItemDelegate;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineExportTaskResource;
import com.liferay.portal.vulcan.batch.engine.resource.VulcanBatchEngineImportTaskResource;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.resource.EntityModelResource;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.UriInfoUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

@Path(value="/v1.0")
public abstract class BaseMasterPageResourceImpl
implements EntityModelResource,
MasterPageResource,
VulcanBatchEngineTaskItemDelegate<MasterPage> {
    protected AcceptLanguage contextAcceptLanguage;
    protected UnsafeBiConsumer<Collection<MasterPage>, UnsafeFunction<MasterPage, MasterPage, Exception>, Exception> contextBatchUnsafeBiConsumer;
    protected UnsafeBiConsumer<Collection<MasterPage>, UnsafeConsumer<MasterPage, Exception>, Exception> contextBatchUnsafeConsumer;
    protected Company contextCompany;
    protected HttpServletRequest contextHttpServletRequest;
    protected HttpServletResponse contextHttpServletResponse;
    protected Object contextScopeChecker;
    protected UriInfo contextUriInfo;
    protected User contextUser;
    protected ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert;
    protected FilterParserProvider filterParserProvider;
    protected GroupLocalService groupLocalService;
    protected ResourceActionLocalService resourceActionLocalService;
    protected ResourcePermissionLocalService resourcePermissionLocalService;
    protected RoleLocalService roleLocalService;
    protected SortParserProvider sortParserProvider;
    protected VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource;
    protected VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource;
    private static final Log _log = LogFactoryUtil.getLog(BaseMasterPageResourceImpl.class);

    @Operation(description="Deletes a specific master page of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode")})
    @Tags(value={@Tag(name="MasterPage")})
    @DELETE
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public void deleteSiteSiteByExternalReferenceCodeMasterPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode) throws Exception {
    }

    @Operation(description="Retrieves a specific master page of a site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MasterPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public MasterPage getSiteSiteByExternalReferenceCodeMasterPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode) throws Exception {
        return new MasterPage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MasterPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteSiteByExternalReferenceCodeMasterPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Retrieves the master pages of the site.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="aggregationTerms"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="filter"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="page"), @Parameter(in=ParameterIn.QUERY, name="pageSize"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="search"), @Parameter(in=ParameterIn.QUERY, name="sort")})
    @Tags(value={@Tag(name="MasterPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages")
    @Produces(value={"application/json", "application/xml"})
    public Page<MasterPage> getSiteSiteByExternalReferenceCodeMasterPagesPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="search") String search, @Context Aggregation aggregation, @Context com.liferay.portal.kernel.search.filter.Filter filter, @Context Pagination pagination, @Context Sort[] sorts) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields"), @Parameter(in=ParameterIn.QUERY, name="roleNames")})
    @Tags(value={@Tag(name="MasterPage")})
    @GET
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    public Page<Permission> getSiteSiteExternalReferenceCodeMasterPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode, @Parameter(hidden=true) @QueryParam(value="roleNames") String roleNames) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Operation(description="Updates only the fields received in the request body, leaving any other fields untouched.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @PATCH
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    public MasterPage patchSiteSiteByExternalReferenceCodeMasterPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode, MasterPage masterPage) throws Exception {
        MasterPage existingMasterPage = this.getSiteSiteByExternalReferenceCodeMasterPage(siteExternalReferenceCode, masterPageExternalReferenceCode);
        if (masterPage.getCreatorExternalReferenceCode() != null) {
            existingMasterPage.setCreatorExternalReferenceCode(masterPage.getCreatorExternalReferenceCode());
        }
        if (masterPage.getDateCreated() != null) {
            existingMasterPage.setDateCreated(masterPage.getDateCreated());
        }
        if (masterPage.getDateModified() != null) {
            existingMasterPage.setDateModified(masterPage.getDateModified());
        }
        if (masterPage.getDatePublished() != null) {
            existingMasterPage.setDatePublished(masterPage.getDatePublished());
        }
        if (masterPage.getExternalReferenceCode() != null) {
            existingMasterPage.setExternalReferenceCode(masterPage.getExternalReferenceCode());
        }
        if (masterPage.getKey() != null) {
            existingMasterPage.setKey(masterPage.getKey());
        }
        if (masterPage.getMarkedAsDefault() != null) {
            existingMasterPage.setMarkedAsDefault(masterPage.getMarkedAsDefault());
        }
        if (masterPage.getName() != null) {
            existingMasterPage.setName(masterPage.getName());
        }
        if (masterPage.getUuid() != null) {
            existingMasterPage.setUuid(masterPage.getUuid());
        }
        this.preparePatch(masterPage, existingMasterPage);
        return this.putSiteSiteByExternalReferenceCodeMasterPage(siteExternalReferenceCode, masterPageExternalReferenceCode, existingMasterPage);
    }

    @Operation(description="Adds a new master page.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public MasterPage postSiteSiteByExternalReferenceCodeMasterPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, MasterPage masterPage) throws Exception {
        return new MasterPage();
    }

    @Operation(description="Adds a new page specification in draft status to a master page.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}/page-specifications")
    @POST
    @Produces(value={"application/json", "application/xml"})
    public ContentPageSpecification postSiteSiteByExternalReferenceCodeMasterPagePageSpecification(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode, ContentPageSpecification contentPageSpecification) throws Exception {
        return new ContentPageSpecification();
    }

    @Operation(description="Updates the master page with the given external reference code, or creates it if it does not exist.")
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode"), @Parameter(in=ParameterIn.QUERY, name="fields"), @Parameter(in=ParameterIn.QUERY, name="nestedFields"), @Parameter(in=ParameterIn.QUERY, name="restrictFields")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public MasterPage putSiteSiteByExternalReferenceCodeMasterPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode, MasterPage masterPage) throws Exception {
        return new MasterPage();
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteSiteByExternalReferenceCodeMasterPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, Permission[] permissions) throws Exception {
        return Page.of(Collections.emptyList());
    }

    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="siteExternalReferenceCode"), @Parameter(in=ParameterIn.PATH, name="masterPageExternalReferenceCode")})
    @Tags(value={@Tag(name="MasterPage")})
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="/sites/{siteExternalReferenceCode}/master-pages/{masterPageExternalReferenceCode}/permissions")
    @Produces(value={"application/json", "application/xml"})
    @PUT
    public Page<Permission> putSiteSiteExternalReferenceCodeMasterPagePermissionsPage(@Parameter(hidden=true) @NotNull @PathParam(value="siteExternalReferenceCode") String siteExternalReferenceCode, @Parameter(hidden=true) @NotNull @PathParam(value="masterPageExternalReferenceCode") String masterPageExternalReferenceCode, Permission[] permissions) throws Exception {
        return Page.of(Collections.emptyList());
    }

    public void create(Collection<MasterPage> masterPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void delete(Collection<MasterPage> masterPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public Set<String> getAvailableCreateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public Set<String> getAvailableUpdateStrategies() {
        return SetUtil.fromArray((Object[])new String[0]);
    }

    public EntityModel getEntityModel(Map<String, List<String>> multivaluedMap) throws Exception {
        return this.getEntityModel((MultivaluedMap)new MultivaluedHashMap(multivaluedMap));
    }

    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return null;
    }

    public String getResourceName() {
        return "MasterPage";
    }

    public String getVersion() {
        return "v1.0";
    }

    public Page<MasterPage> read(com.liferay.portal.kernel.search.filter.Filter filter, Pagination pagination, Sort[] sorts, Map<String, Serializable> parameters, String search) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setLanguageId(final String languageId) {
        this.contextAcceptLanguage = new AcceptLanguage(){

            public List<Locale> getLocales() {
                return null;
            }

            public String getPreferredLanguageId() {
                return languageId;
            }

            public Locale getPreferredLocale() {
                return LocaleUtil.fromLanguageId((String)languageId);
            }
        };
    }

    public void update(Collection<MasterPage> masterPages, Map<String, Serializable> parameters) throws Exception {
        throw new UnsupportedOperationException("This method needs to be implemented");
    }

    public void setContextAcceptLanguage(AcceptLanguage contextAcceptLanguage) {
        this.contextAcceptLanguage = contextAcceptLanguage;
    }

    public void setContextBatchUnsafeBiConsumer(UnsafeBiConsumer<Collection<MasterPage>, UnsafeFunction<MasterPage, MasterPage, Exception>, Exception> contextBatchUnsafeBiConsumer) {
        this.contextBatchUnsafeBiConsumer = contextBatchUnsafeBiConsumer;
    }

    public void setContextBatchUnsafeConsumer(UnsafeBiConsumer<Collection<MasterPage>, UnsafeConsumer<MasterPage, Exception>, Exception> contextBatchUnsafeConsumer) {
        this.contextBatchUnsafeConsumer = contextBatchUnsafeConsumer;
    }

    public void setContextCompany(Company contextCompany) {
        this.contextCompany = contextCompany;
    }

    public void setContextHttpServletRequest(HttpServletRequest contextHttpServletRequest) {
        this.contextHttpServletRequest = contextHttpServletRequest;
    }

    public void setContextHttpServletResponse(HttpServletResponse contextHttpServletResponse) {
        this.contextHttpServletResponse = contextHttpServletResponse;
    }

    public void setContextUriInfo(UriInfo contextUriInfo) {
        this.contextUriInfo = UriInfoUtil.getVulcanUriInfo((String)this.getApplicationPath(), (UriInfo)contextUriInfo);
    }

    public void setContextUser(User contextUser) {
        this.contextUser = contextUser;
    }

    public void setExpressionConvert(ExpressionConvert<com.liferay.portal.kernel.search.filter.Filter> expressionConvert) {
        this.expressionConvert = expressionConvert;
    }

    public void setFilterParserProvider(FilterParserProvider filterParserProvider) {
        this.filterParserProvider = filterParserProvider;
    }

    public void setGroupLocalService(GroupLocalService groupLocalService) {
        this.groupLocalService = groupLocalService;
    }

    public void setResourceActionLocalService(ResourceActionLocalService resourceActionLocalService) {
        this.resourceActionLocalService = resourceActionLocalService;
    }

    public void setResourcePermissionLocalService(ResourcePermissionLocalService resourcePermissionLocalService) {
        this.resourcePermissionLocalService = resourcePermissionLocalService;
    }

    public void setRoleLocalService(RoleLocalService roleLocalService) {
        this.roleLocalService = roleLocalService;
    }

    public void setSortParserProvider(SortParserProvider sortParserProvider) {
        this.sortParserProvider = sortParserProvider;
    }

    protected String getApplicationPath() {
        return "headless-admin-site";
    }

    public void setVulcanBatchEngineExportTaskResource(VulcanBatchEngineExportTaskResource vulcanBatchEngineExportTaskResource) {
        this.vulcanBatchEngineExportTaskResource = vulcanBatchEngineExportTaskResource;
    }

    public void setVulcanBatchEngineImportTaskResource(VulcanBatchEngineImportTaskResource vulcanBatchEngineImportTaskResource) {
        this.vulcanBatchEngineImportTaskResource = vulcanBatchEngineImportTaskResource;
    }

    public com.liferay.portal.kernel.search.filter.Filter toFilter(String filterString, Map<String, List<String>> multivaluedMap) {
        try {
            EntityModel entityModel = this.getEntityModel(multivaluedMap);
            FilterParser filterParser = this.filterParserProvider.provide(entityModel);
            Filter oDataFilter = new Filter(filterParser.parse(filterString));
            return (com.liferay.portal.kernel.search.filter.Filter)this.expressionConvert.convert(oDataFilter.getExpression(), this.contextAcceptLanguage.getPreferredLocale(), entityModel);
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid filter " + filterString), (Throwable)exception);
            return null;
        }
    }

    public Sort[] toSorts(String sortString) {
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        try {
            SortParser sortParser = this.sortParserProvider.provide(this.getEntityModel(Collections.emptyMap()));
            if (sortParser == null) {
                return null;
            }
            com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
            List sortFields = oDataSort.getSortFields();
            Sort[] sorts = new Sort[sortFields.size()];
            for (int i = 0; i < sortFields.size(); ++i) {
                SortField sortField = (SortField)sortFields.get(i);
                sorts[i] = new Sort(sortField.getSortableFieldName(this.contextAcceptLanguage.getPreferredLocale()), !sortField.isAscending());
            }
            return sorts;
        }
        catch (Exception exception) {
            _log.error((Object)("Invalid sort " + sortString), (Throwable)exception);
            return new Sort[0];
        }
    }

    protected Map<String, String> addAction(String actionName, GroupedModel groupedModel, String methodName) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (GroupedModel)groupedModel, (String)methodName, (Object)this.contextScopeChecker, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, Long ownerId, String permissionName, Long siteId) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (Long)ownerId, (String)permissionName, (Long)siteId, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, Long id, String methodName, ModelResourcePermission modelResourcePermission) {
        return ActionUtil.addAction((String)actionName, this.getClass(), (Long)id, (String)methodName, (Object)this.contextScopeChecker, (ModelResourcePermission)modelResourcePermission, (UriInfo)this.contextUriInfo);
    }

    protected Map<String, String> addAction(String actionName, String methodName, String permissionName, Long siteId) {
        return this.addAction(actionName, siteId, methodName, null, permissionName, siteId);
    }

    protected void preparePatch(MasterPage masterPage, MasterPage existingMasterPage) {
    }

    protected <T, R, E extends Throwable> List<R> transform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] transform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] transformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) {
        return TransformUtil.transformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> transformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] transformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) {
        return TransformUtil.transformToLongArray(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransform(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransform(collection, unsafeFunction);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransform(T[] array, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransform((Object[])array, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> R[] unsafeTransformToArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction, Class<? extends R> clazz) throws E {
        return TransformUtil.unsafeTransformToArray(collection, unsafeFunction, clazz);
    }

    protected <T, R, E extends Throwable> List<R> unsafeTransformToList(T[] array, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToList((Object[])array, unsafeFunction);
    }

    protected <T, R, E extends Throwable> long[] unsafeTransformToLongArray(Collection<T> collection, UnsafeFunction<T, R, E> unsafeFunction) throws E {
        return TransformUtil.unsafeTransformToLongArray(collection, unsafeFunction);
    }
}

